/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.services;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import me.rafaelldi.aspire.AspireService;
import me.rafaelldi.aspire.generated.ResourceEnvironmentVariable;
import me.rafaelldi.aspire.generated.ResourceLog;
import me.rafaelldi.aspire.generated.ResourceModel;
import me.rafaelldi.aspire.generated.ResourceProperty;
import me.rafaelldi.aspire.generated.ResourceState;
import me.rafaelldi.aspire.generated.ResourceStateStyle;
import me.rafaelldi.aspire.generated.ResourceType;
import me.rafaelldi.aspire.generated.ResourceUrl;
import me.rafaelldi.aspire.generated.ResourceWrapper;
import me.rafaelldi.aspire.services.AspireHostService;
import me.rafaelldi.aspire.services.AspireServiceContributor;
import me.rafaelldi.aspire.services.ResourceListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010Q\u001a\u00020R2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020T0#H\u0002\u00a2\u0006\u0002\u0010UJ\u0010\u0010V\u001a\u00020R2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020R2\u0006\u0010Z\u001a\u00020[H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\"\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u001f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R,\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020$0#@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010(\u001a\u0004\b&\u0010'R,\u0010*\u001a\b\u0012\u0004\u0012\u00020)0#2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020)0#@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b+\u0010,R\"\u0010/\u001a\u0004\u0018\u00010.2\b\u0010\u000e\u001a\u0004\u0018\u00010.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R$\u00103\u001a\u0004\u0018\u0001022\b\u0010\u000e\u001a\u0004\u0018\u000102@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b4\u00105R$\u00107\u001a\u0004\u0018\u0001022\b\u0010\u000e\u001a\u0004\u0018\u000102@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b8\u00105R\"\u0010:\u001a\u0004\u0018\u0001092\b\u0010\u000e\u001a\u0004\u0018\u000109@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\"\u0010=\u001a\u0004\u0018\u0001092\b\u0010\u000e\u001a\u0004\u0018\u000109@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010<R\"\u0010?\u001a\u0004\u0018\u0001092\b\u0010\u000e\u001a\u0004\u0018\u000109@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010<R\"\u0010A\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010\u0012R\"\u0010C\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010\u0012R\"\u0010E\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010\u0012R\"\u0010G\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u0012R\"\u0010I\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0012R\"\u0010K\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010\u0012R\u0011\u0010M\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010P\u00a8\u0006\\"}, d2={"Lme/rafaelldi/aspire/services/AspireResourceService;", "", "wrapper", "Lme/rafaelldi/aspire/generated/ResourceWrapper;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "hostService", "Lme/rafaelldi/aspire/services/AspireHostService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lme/rafaelldi/aspire/generated/ResourceWrapper;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lme/rafaelldi/aspire/services/AspireHostService;Lcom/intellij/openapi/project/Project;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "value", "", "uid", "getUid", "()Ljava/lang/String;", "name", "getName", "Lme/rafaelldi/aspire/generated/ResourceType;", "type", "getType", "()Lme/rafaelldi/aspire/generated/ResourceType;", "displayName", "getDisplayName", "Lme/rafaelldi/aspire/generated/ResourceState;", "state", "getState", "()Lme/rafaelldi/aspire/generated/ResourceState;", "Lme/rafaelldi/aspire/generated/ResourceStateStyle;", "stateStyle", "getStateStyle", "()Lme/rafaelldi/aspire/generated/ResourceStateStyle;", "", "Lme/rafaelldi/aspire/generated/ResourceUrl;", "urls", "getUrls", "()[Lme/rafaelldi/aspire/generated/ResourceUrl;", "[Lme/rafaelldi/aspire/generated/ResourceUrl;", "Lme/rafaelldi/aspire/generated/ResourceEnvironmentVariable;", "environment", "getEnvironment", "()[Lme/rafaelldi/aspire/generated/ResourceEnvironmentVariable;", "[Lme/rafaelldi/aspire/generated/ResourceEnvironmentVariable;", "Lkotlinx/datetime/LocalDateTime;", "startTime", "getStartTime", "()Lkotlinx/datetime/LocalDateTime;", "", "exitCode", "getExitCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "pid", "getPid", "Ljava/nio/file/Path;", "projectPath", "getProjectPath", "()Ljava/nio/file/Path;", "executablePath", "getExecutablePath", "executableWorkDir", "getExecutableWorkDir", "args", "getArgs", "containerImage", "getContainerImage", "containerId", "getContainerId", "containerPorts", "getContainerPorts", "containerCommand", "getContainerCommand", "containerArgs", "getContainerArgs", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "fillFromProperties", "", "properties", "Lme/rafaelldi/aspire/generated/ResourceProperty;", "([Lme/rafaelldi/aspire/generated/ResourceProperty;)V", "update", "resourceModel", "Lme/rafaelldi/aspire/generated/ResourceModel;", "logReceived", "log", "Lme/rafaelldi/aspire/generated/ResourceLog;", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireResourceService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireResourceService.kt\nme/rafaelldi/aspire/services/AspireResourceService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class AspireResourceService {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final AspireHostService hostService;
    @NotNull
    private final Project project;
    @NotNull
    private String uid;
    @NotNull
    private String name;
    @NotNull
    private ResourceType type;
    @NotNull
    private String displayName;
    @Nullable
    private ResourceState state;
    @Nullable
    private ResourceStateStyle stateStyle;
    @NotNull
    private ResourceUrl[] urls;
    @NotNull
    private ResourceEnvironmentVariable[] environment;
    @Nullable
    private LocalDateTime startTime;
    @Nullable
    private Integer exitCode;
    @Nullable
    private Integer pid;
    @Nullable
    private Path projectPath;
    @Nullable
    private Path executablePath;
    @Nullable
    private Path executableWorkDir;
    @Nullable
    private String args;
    @Nullable
    private String containerImage;
    @Nullable
    private String containerId;
    @Nullable
    private String containerPorts;
    @Nullable
    private String containerCommand;
    @Nullable
    private String containerArgs;
    @NotNull
    private final ConsoleView consoleView;

    /*
     * WARNING - void declaration
     */
    public AspireResourceService(@NotNull ResourceWrapper wrapper, @NotNull Lifetime lifetime, @NotNull AspireHostService hostService, @NotNull Project project) {
        void $this$consoleView_u24lambda_u240;
        TextConsoleBuilder textConsoleBuilder;
        Intrinsics.checkNotNullParameter((Object)((Object)wrapper), (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)hostService, (String)"hostService");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.lifetime = lifetime;
        this.hostService = hostService;
        this.project = project;
        TextConsoleBuilder textConsoleBuilder2 = textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.project);
        AspireResourceService aspireResourceService = this;
        boolean bl = false;
        $this$consoleView_u24lambda_u240.setViewer(true);
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getConsole(...)");
        aspireResourceService.consoleView = consoleView;
        ResourceUrl[] model = (ResourceUrl[])wrapper.getModel().getValueOrNull();
        Object object = model;
        if (model == null || (object = ((ResourceModel)object).getUid()) == null) {
            object = "";
        }
        this.uid = object;
        Object object2 = model;
        if (model == null || (object2 = ((ResourceModel)object2).getName()) == null) {
            object2 = "";
        }
        this.name = object2;
        Object object3 = model;
        if (model == null || (object3 = object3.getType()) == null) {
            object3 = ResourceType.Unknown;
        }
        this.type = object3;
        Object object4 = model;
        if (model == null || (object4 = ((ResourceModel)object4).getDisplayName()) == null) {
            object4 = "";
        }
        this.displayName = object4;
        this.state = model != null ? model.getState() : null;
        this.stateStyle = model != null ? model.getStateStyle() : null;
        ResourceUrl[] resourceUrlArray = model;
        if (model == null || (resourceUrlArray = resourceUrlArray.getUrls()) == null) {
            resourceUrlArray = new ResourceUrl[]{};
        }
        this.urls = resourceUrlArray;
        Object[] objectArray = model;
        if (model == null || (objectArray = objectArray.getEnvironment()) == null) {
            objectArray = new ResourceEnvironmentVariable[]{};
        }
        this.environment = objectArray;
        Object[] objectArray2 = model;
        if (model == null || (objectArray2 = objectArray2.getProperties()) == null) {
            objectArray2 = new ResourceProperty[]{};
        }
        this.fillFromProperties((ResourceProperty[])objectArray2);
        wrapper.getModel().advise(this.lifetime, (Function1)new Function1<ResourceModel, Unit>((Object)this){

            public final void invoke(ResourceModel p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AspireResourceService)this.receiver).update(p0);
            }
        });
        wrapper.getLogReceived().advise(this.lifetime, (Function1)new Function1<ResourceLog, Unit>((Object)this){

            public final void invoke(ResourceLog p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AspireResourceService)this.receiver).logReceived(p0);
            }
        });
        Disposer.register((Disposable)AspireService.Companion.getInstance(this.project), (Disposable)((Disposable)this.consoleView));
        ((ResourceListener)this.project.getMessageBus().syncPublisher(ResourceListener.Companion.getTOPIC())).resourceCreated(this);
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final String getUid() {
        return this.uid;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final ResourceType getType() {
        return this.type;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    public final ResourceState getState() {
        return this.state;
    }

    @Nullable
    public final ResourceStateStyle getStateStyle() {
        return this.stateStyle;
    }

    @NotNull
    public final ResourceUrl[] getUrls() {
        return this.urls;
    }

    @NotNull
    public final ResourceEnvironmentVariable[] getEnvironment() {
        return this.environment;
    }

    @Nullable
    public final LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    public final Integer getExitCode() {
        return this.exitCode;
    }

    @Nullable
    public final Integer getPid() {
        return this.pid;
    }

    @Nullable
    public final Path getProjectPath() {
        return this.projectPath;
    }

    @Nullable
    public final Path getExecutablePath() {
        return this.executablePath;
    }

    @Nullable
    public final Path getExecutableWorkDir() {
        return this.executableWorkDir;
    }

    @Nullable
    public final String getArgs() {
        return this.args;
    }

    @Nullable
    public final String getContainerImage() {
        return this.containerImage;
    }

    @Nullable
    public final String getContainerId() {
        return this.containerId;
    }

    @Nullable
    public final String getContainerPorts() {
        return this.containerPorts;
    }

    @Nullable
    public final String getContainerCommand() {
        return this.containerCommand;
    }

    @Nullable
    public final String getContainerArgs() {
        return this.containerArgs;
    }

    @NotNull
    public final ConsoleView getConsoleView() {
        return this.consoleView;
    }

    private final void fillFromProperties(ResourceProperty[] properties) {
        block28: for (ResourceProperty property : properties) {
            switch (property.getName()) {
                case "resource.createTime": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.startTime = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.parse$default((Instant.Companion)Instant.Companion, (CharSequence)it, null, (int)2, null), (TimeZone)TimeZone.Companion.currentSystemDefault());
                    continue block28;
                }
                case "resource.exitCode": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.exitCode = MathKt.roundToInt((double)Double.parseDouble(it));
                    continue block28;
                }
                case "project.path": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Paths.get(it, new String[0]), (String)"get(...)");
                    this.projectPath = this.projectPath;
                    continue block28;
                }
                case "executable.pid": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.pid = Integer.parseInt(it);
                    continue block28;
                }
                case "executable.path": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Paths.get(it, new String[0]), (String)"get(...)");
                    this.executablePath = this.executablePath;
                    continue block28;
                }
                case "executable.workDir": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Paths.get(it, new String[0]), (String)"get(...)");
                    this.executableWorkDir = this.executableWorkDir;
                    continue block28;
                }
                case "executable.args": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.args = it;
                    continue block28;
                }
                case "container.image": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.containerImage = it;
                    continue block28;
                }
                case "container.id": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.containerId = it;
                    continue block28;
                }
                case "container.ports": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.containerPorts = it;
                    continue block28;
                }
                case "container.command": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.containerCommand = it;
                    continue block28;
                }
                case "container.args": {
                    String it;
                    if (property.getValue() == null) continue block28;
                    boolean bl = false;
                    this.containerArgs = it;
                    continue block28;
                }
            }
        }
    }

    private final void update(ResourceModel resourceModel) {
        this.uid = resourceModel.getUid();
        this.name = resourceModel.getName();
        this.type = resourceModel.getType();
        this.displayName = resourceModel.getDisplayName();
        this.state = resourceModel.getState();
        this.stateStyle = resourceModel.getStateStyle();
        this.urls = resourceModel.getUrls();
        this.environment = resourceModel.getEnvironment();
        this.fillFromProperties(resourceModel.getProperties());
        ((ResourceListener)this.project.getMessageBus().syncPublisher(ResourceListener.Companion.getTOPIC())).resourceUpdated(this);
        ServiceEventListener.ServiceEvent serviceEvent = ServiceEventListener.ServiceEvent.createEvent((ServiceEventListener.EventType)ServiceEventListener.EventType.SERVICE_CHILDREN_CHANGED, (Object)this.hostService, AspireServiceContributor.class);
        MessageBus messageBus = this.project.getMessageBus();
        Topic topic = ServiceEventListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        ((ServiceEventListener)messageBus.syncPublisher(topic)).handle(serviceEvent);
    }

    private final void logReceived(ResourceLog log) {
        this.consoleView.print(log.getText() + "\n", !log.isError() ? ConsoleViewContentType.NORMAL_OUTPUT : ConsoleViewContentType.ERROR_OUTPUT);
    }
}

