/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.services;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.DotNetProcessRunProfileStateKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.rafaelldi.aspire.AspireService;
import me.rafaelldi.aspire.generated.AspireSessionHostModel;
import me.rafaelldi.aspire.services.AspireHostServiceViewDescriptor;
import me.rafaelldi.aspire.services.AspireResourceService;
import me.rafaelldi.aspire.services.AspireResourceServiceViewDescriptor;
import me.rafaelldi.aspire.services.AspireServiceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020 J\u0006\u0010-\u001a\u00020)J\u000e\u0010.\u001a\u00020)2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0010\u0010\r\u001a\u00020\f2\u0006\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0002042\u0006\u00101\u001a\u000202H\u0016J\b\u00105\u001a\u00020\u0000H\u0016J\u0018\u00106\u001a\u0002072\u0006\u00101\u001a\u0002022\u0006\u00108\u001a\u00020\u0002H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0014\u001a\u0004\u0018\u00010 @BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\"\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u0014\u001a\u0004\u0018\u00010$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u00069"}, d2={"Lme/rafaelldi/aspire/services/AspireHostService;", "Lcom/intellij/execution/services/ServiceViewProvidingContributor;", "Lme/rafaelldi/aspire/services/AspireResourceService;", "name", "", "projectPath", "Ljava/nio/file/Path;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "getProjectPath", "()Ljava/nio/file/Path;", "viewDescriptor", "Lme/rafaelldi/aspire/services/AspireHostServiceViewDescriptor;", "getViewDescriptor", "()Lme/rafaelldi/aspire/services/AspireHostServiceViewDescriptor;", "viewDescriptor$delegate", "Lkotlin/Lazy;", "projectPathString", "getProjectPathString", "()Ljava/lang/String;", "value", "displayName", "getDisplayName", "", "isActive", "()Z", "dashboardUrl", "getDashboardUrl", "Lme/rafaelldi/aspire/generated/AspireSessionHostModel;", "model", "getModel", "()Lme/rafaelldi/aspire/generated/AspireSessionHostModel;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetime", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/intellij/execution/ui/ConsoleView;", "consoleView", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "startHost", "", "aspireHostDashboardUrl", "sessionHostModel", "aspireHostServiceLifetime", "stopHost", "update", "executionResult", "Lcom/intellij/execution/ExecutionResult;", "project", "Lcom/intellij/openapi/project/Project;", "getServices", "", "asService", "getServiceDescriptor", "Lme/rafaelldi/aspire/services/AspireResourceServiceViewDescriptor;", "service", "aspire-plugin"})
public final class AspireHostService
implements ServiceViewProvidingContributor<AspireResourceService, AspireHostService> {
    @NotNull
    private final Path projectPath;
    @NotNull
    private final Lazy viewDescriptor$delegate;
    @NotNull
    private final String projectPathString;
    @NotNull
    private String displayName;
    private boolean isActive;
    @Nullable
    private String dashboardUrl;
    @Nullable
    private AspireSessionHostModel model;
    @Nullable
    private Lifetime lifetime;
    @Nullable
    private ConsoleView consoleView;

    public AspireHostService(@NotNull String name, @NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this.projectPath = projectPath;
        this.viewDescriptor$delegate = LazyKt.lazy(() -> AspireHostService.viewDescriptor_delegate$lambda$0(this));
        this.projectPathString = ((Object)this.projectPath.toAbsolutePath()).toString();
        this.displayName = name;
    }

    @NotNull
    public final Path getProjectPath() {
        return this.projectPath;
    }

    private final AspireHostServiceViewDescriptor getViewDescriptor() {
        Lazy lazy = this.viewDescriptor$delegate;
        return (AspireHostServiceViewDescriptor)lazy.getValue();
    }

    @NotNull
    public final String getProjectPathString() {
        return this.projectPathString;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    public final boolean isActive() {
        return this.isActive;
    }

    @Nullable
    public final String getDashboardUrl() {
        return this.dashboardUrl;
    }

    @Nullable
    public final AspireSessionHostModel getModel() {
        return this.model;
    }

    @Nullable
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public final ConsoleView getConsoleView() {
        return this.consoleView;
    }

    public final void startHost(@NotNull String aspireHostDashboardUrl, @NotNull AspireSessionHostModel sessionHostModel, @NotNull Lifetime aspireHostServiceLifetime) {
        Intrinsics.checkNotNullParameter((Object)aspireHostDashboardUrl, (String)"aspireHostDashboardUrl");
        Intrinsics.checkNotNullParameter((Object)((Object)sessionHostModel), (String)"sessionHostModel");
        Intrinsics.checkNotNullParameter((Object)aspireHostServiceLifetime, (String)"aspireHostServiceLifetime");
        this.isActive = true;
        this.dashboardUrl = aspireHostDashboardUrl;
        this.model = sessionHostModel;
        this.lifetime = aspireHostServiceLifetime;
    }

    public final void stopHost() {
        this.isActive = false;
        this.dashboardUrl = null;
        this.model = null;
        this.lifetime = null;
    }

    public final void update(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.displayName = name;
    }

    public final void update(@NotNull ExecutionResult executionResult, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)executionResult, (String)"executionResult");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProcessHandler processHandler = executionResult.getProcessHandler();
        Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
        ConsoleView console = DotNetProcessRunProfileStateKt.createConsole$default((ConsoleKind)ConsoleKind.Normal, (ProcessHandler)processHandler, (Project)project, null, (int)8, null);
        Disposer.register((Disposable)AspireService.Companion.getInstance(project), (Disposable)((Disposable)console));
        this.consoleView = console;
    }

    @NotNull
    public AspireHostServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getViewDescriptor();
    }

    @NotNull
    public List<AspireResourceService> getServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.toMutableList((Collection)AspireServiceManager.Companion.getInstance(project).getResourceServices(this.projectPathString));
    }

    @NotNull
    public AspireHostService asService() {
        return this;
    }

    @NotNull
    public AspireResourceServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull AspireResourceService service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        return new AspireResourceServiceViewDescriptor(service);
    }

    private static final AspireHostServiceViewDescriptor viewDescriptor_delegate$lambda$0(AspireHostService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new AspireHostServiceViewDescriptor(this$0);
    }
}

