/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.run;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.reactive.ViewableList;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.controls.ControlBase;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.LaunchProfile;
import com.jetbrains.rider.run.configurations.controls.LaunchProfileSelector;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.ProjectSelectorKt;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.controls.ViewSeparator;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettings;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettingsEditor;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJson;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJsonService;
import com.jetbrains.rider.run.configurations.project.DotNetStartBrowserParameters;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import me.rafaelldi.aspire.run.AspireLaunchProfileUtilsKt;
import me.rafaelldi.aspire.run.AspireRunnableProjectKinds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\b\u00101\u001a\u00020.H\u0002J\b\u00102\u001a\u00020.H\u0002J\b\u00103\u001a\u00020.H\u0002JB\u00104\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002062\u0006\u0010%\u001a\u00020$2\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u000206092\u0006\u0010*\u001a\u00020$2\u0006\u0010:\u001a\u00020;J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020=0\u001f2\u0006\u0010/\u001a\u000200H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010'\"\u0004\b,\u0010)\u00a8\u0006>"}, d2={"Lme/rafaelldi/aspire/run/AspireHostConfigurationViewModel;", "Lcom/jetbrains/rider/run/configurations/controls/RunConfigurationViewModelBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "runnableProjectsModel", "Lcom/jetbrains/rider/model/RunnableProjectsModel;", "projectSelector", "Lcom/jetbrains/rider/run/configurations/controls/ProjectSelector;", "launchProfileSelector", "Lcom/jetbrains/rider/run/configurations/controls/LaunchProfileSelector;", "environmentVariablesEditor", "Lcom/jetbrains/rider/run/configurations/controls/EnvironmentVariablesEditor;", "separator", "Lcom/jetbrains/rider/run/configurations/controls/ViewSeparator;", "urlEditor", "Lcom/jetbrains/rider/run/configurations/controls/TextEditor;", "dotNetBrowserSettingsEditor", "Lcom/jetbrains/rider/run/configurations/controls/startBrowser/BrowserSettingsEditor;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/RunnableProjectsModel;Lcom/jetbrains/rider/run/configurations/controls/ProjectSelector;Lcom/jetbrains/rider/run/configurations/controls/LaunchProfileSelector;Lcom/jetbrains/rider/run/configurations/controls/EnvironmentVariablesEditor;Lcom/jetbrains/rider/run/configurations/controls/ViewSeparator;Lcom/jetbrains/rider/run/configurations/controls/TextEditor;Lcom/jetbrains/rider/run/configurations/controls/startBrowser/BrowserSettingsEditor;)V", "getProjectSelector", "()Lcom/jetbrains/rider/run/configurations/controls/ProjectSelector;", "getLaunchProfileSelector", "()Lcom/jetbrains/rider/run/configurations/controls/LaunchProfileSelector;", "getEnvironmentVariablesEditor", "()Lcom/jetbrains/rider/run/configurations/controls/EnvironmentVariablesEditor;", "getUrlEditor", "()Lcom/jetbrains/rider/run/configurations/controls/TextEditor;", "getDotNetBrowserSettingsEditor", "()Lcom/jetbrains/rider/run/configurations/controls/startBrowser/BrowserSettingsEditor;", "controls", "", "Lcom/jetbrains/rider/run/configurations/controls/ControlBase;", "getControls", "()Ljava/util/List;", "isLoaded", "", "trackEnvs", "getTrackEnvs", "()Z", "setTrackEnvs", "(Z)V", "trackUrl", "getTrackUrl", "setTrackUrl", "handleProjectSelection", "", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "handleProfileSelection", "handleEnvValueChange", "handleUrlValueChange", "reset", "projectFilePath", "", "launchProfileName", "envs", "", "dotNetStartBrowserParameters", "Lcom/jetbrains/rider/run/configurations/project/DotNetStartBrowserParameters;", "getLaunchProfiles", "Lcom/jetbrains/rider/run/configurations/controls/LaunchProfile;", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nAspireHostConfigurationViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AspireHostConfigurationViewModel.kt\nme/rafaelldi/aspire/run/AspireHostConfigurationViewModel\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n603#2:219\n2624#3,3:220\n288#3,2:223\n661#3,11:225\n288#3,2:236\n*S KotlinDebug\n*F\n+ 1 AspireHostConfigurationViewModel.kt\nme/rafaelldi/aspire/run/AspireHostConfigurationViewModel\n*L\n215#1:219\n138#1:220,3\n142#1:223,2\n167#1:225,11\n178#1:236,2\n*E\n"})
public final class AspireHostConfigurationViewModel
extends RunConfigurationViewModelBase {
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final RunnableProjectsModel runnableProjectsModel;
    @NotNull
    private final ProjectSelector projectSelector;
    @NotNull
    private final LaunchProfileSelector launchProfileSelector;
    @NotNull
    private final EnvironmentVariablesEditor environmentVariablesEditor;
    @NotNull
    private final TextEditor urlEditor;
    @NotNull
    private final BrowserSettingsEditor dotNetBrowserSettingsEditor;
    @NotNull
    private final List<ControlBase> controls;
    private boolean isLoaded;
    private boolean trackEnvs;
    private boolean trackUrl;

    public AspireHostConfigurationViewModel(@NotNull Lifetime lifetime, @Nullable RunnableProjectsModel runnableProjectsModel, @NotNull ProjectSelector projectSelector, @NotNull LaunchProfileSelector launchProfileSelector, @NotNull EnvironmentVariablesEditor environmentVariablesEditor, @NotNull ViewSeparator separator2, @NotNull TextEditor urlEditor, @NotNull BrowserSettingsEditor dotNetBrowserSettingsEditor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)projectSelector, (String)"projectSelector");
        Intrinsics.checkNotNullParameter((Object)launchProfileSelector, (String)"launchProfileSelector");
        Intrinsics.checkNotNullParameter((Object)environmentVariablesEditor, (String)"environmentVariablesEditor");
        Intrinsics.checkNotNullParameter((Object)separator2, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)urlEditor, (String)"urlEditor");
        Intrinsics.checkNotNullParameter((Object)dotNetBrowserSettingsEditor, (String)"dotNetBrowserSettingsEditor");
        this.lifetime = lifetime;
        this.runnableProjectsModel = runnableProjectsModel;
        this.projectSelector = projectSelector;
        this.launchProfileSelector = launchProfileSelector;
        this.environmentVariablesEditor = environmentVariablesEditor;
        this.urlEditor = urlEditor;
        this.dotNetBrowserSettingsEditor = dotNetBrowserSettingsEditor;
        Object[] objectArray = new ControlBase[]{this.projectSelector, this.launchProfileSelector, this.environmentVariablesEditor, separator2, this.urlEditor, this.dotNetBrowserSettingsEditor};
        this.controls = CollectionsKt.listOf((Object[])objectArray);
        this.trackEnvs = true;
        this.trackUrl = true;
        this.disable();
        if (this.runnableProjectsModel != null) {
            ProjectSelectorKt.bindTo((ProjectSelector)this.projectSelector, (RunnableProjectsModel)this.runnableProjectsModel, (Lifetime)this.lifetime, AspireHostConfigurationViewModel::_init_$lambda$0, (Function0)((Function0)new Function0<Unit>((Object)this){

                public final void invoke() {
                    ((AspireHostConfigurationViewModel)((Object)this.receiver)).enable();
                }
            }), (Function1)((Function1)new Function1<RunnableProject, Unit>((Object)this){

                public final void invoke(RunnableProject p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((AspireHostConfigurationViewModel)((Object)this.receiver)).handleProjectSelection(p0);
                }
            }));
        }
        this.launchProfileSelector.getProfile().advise(this.lifetime, arg_0 -> AspireHostConfigurationViewModel._init_$lambda$1(this, arg_0));
        this.environmentVariablesEditor.getEnvs().advise(this.lifetime, arg_0 -> AspireHostConfigurationViewModel._init_$lambda$2(this, arg_0));
        this.urlEditor.getText().advise(this.lifetime, arg_0 -> AspireHostConfigurationViewModel._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final ProjectSelector getProjectSelector() {
        return this.projectSelector;
    }

    @NotNull
    public final LaunchProfileSelector getLaunchProfileSelector() {
        return this.launchProfileSelector;
    }

    @NotNull
    public final EnvironmentVariablesEditor getEnvironmentVariablesEditor() {
        return this.environmentVariablesEditor;
    }

    @NotNull
    public final TextEditor getUrlEditor() {
        return this.urlEditor;
    }

    @NotNull
    public final BrowserSettingsEditor getDotNetBrowserSettingsEditor() {
        return this.dotNetBrowserSettingsEditor;
    }

    @NotNull
    public List<ControlBase> getControls() {
        return this.controls;
    }

    public final boolean getTrackEnvs() {
        return this.trackEnvs;
    }

    public final void setTrackEnvs(boolean bl) {
        this.trackEnvs = bl;
    }

    public final boolean getTrackUrl() {
        return this.trackUrl;
    }

    public final void setTrackUrl(boolean bl) {
        this.trackUrl = bl;
    }

    private final void handleProjectSelection(RunnableProject runnableProject) {
        ViewableList viewableList;
        if (!this.isLoaded) {
            return;
        }
        List<LaunchProfile> launchProfiles = this.getLaunchProfiles(runnableProject);
        ViewableList $this$handleProjectSelection_u24lambda_u244 = viewableList = this.launchProfileSelector.getProfileList();
        boolean bl = false;
        $this$handleProjectSelection_u24lambda_u244.clear();
        $this$handleProjectSelection_u24lambda_u244.addAll((Collection)launchProfiles);
        if (CollectionsKt.any((Iterable)launchProfiles)) {
            this.launchProfileSelector.getProfile().set(CollectionsKt.first(launchProfiles));
        }
        this.handleProfileSelection();
    }

    private final void handleProfileSelection() {
        if (!this.isLoaded) {
            return;
        }
        LaunchProfile launchProfile = (LaunchProfile)this.launchProfileSelector.getProfile().getValueOrNull();
        if (launchProfile == null) {
            return;
        }
        LaunchProfile launchProfile2 = launchProfile;
        Map<String, String> environmentVariables = AspireLaunchProfileUtilsKt.getEnvironmentVariables(launchProfile2.getName(), launchProfile2.getContent());
        this.environmentVariablesEditor.getEnvs().set(environmentVariables);
        String applicationUrl = AspireLaunchProfileUtilsKt.getApplicationUrl(launchProfile2.getContent());
        CharSequence charSequence = applicationUrl;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.urlEditor.getDefaultValue().setValue((Object)applicationUrl);
            this.urlEditor.getText().setValue((Object)applicationUrl);
            this.dotNetBrowserSettingsEditor.getSettings().setValue((Object)new BrowserSettings(launchProfile2.getContent().getLaunchBrowser(), false, null));
        }
    }

    private final void handleEnvValueChange() {
        if (!this.isLoaded) {
            return;
        }
        LaunchProfile launchProfile = (LaunchProfile)this.launchProfileSelector.getProfile().getValueOrNull();
        if (launchProfile == null) {
            this.trackEnvs = false;
            return;
        }
        SortedMap envs = MapsKt.toSortedMap(AspireLaunchProfileUtilsKt.getEnvironmentVariables(launchProfile.getName(), launchProfile.getContent()));
        SortedMap editorEnvs = MapsKt.toSortedMap((Map)((Map)this.environmentVariablesEditor.getEnvs().getValue()));
        this.trackEnvs = Intrinsics.areEqual((Object)envs, (Object)editorEnvs);
    }

    private final void handleUrlValueChange() {
        if (!this.isLoaded) {
            return;
        }
        LaunchProfile launchProfile = (LaunchProfile)this.launchProfileSelector.getProfile().getValueOrNull();
        if (launchProfile == null) {
            this.trackUrl = false;
            return;
        }
        String applicationUrl = AspireLaunchProfileUtilsKt.getApplicationUrl(launchProfile.getContent());
        this.trackUrl = Intrinsics.areEqual((Object)this.urlEditor.getText().getValue(), (Object)applicationUrl);
    }

    public final void reset(@NotNull String projectFilePath, @NotNull String launchProfileName, boolean trackEnvs, @NotNull Map<String, String> envs, boolean trackUrl, @NotNull DotNetStartBrowserParameters dotNetStartBrowserParameters) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
            Intrinsics.checkNotNullParameter((Object)launchProfileName, (String)"launchProfileName");
            Intrinsics.checkNotNullParameter(envs, (String)"envs");
            Intrinsics.checkNotNullParameter((Object)dotNetStartBrowserParameters, (String)"dotNetStartBrowserParameters");
            this.isLoaded = false;
            this.trackEnvs = trackEnvs;
            this.trackUrl = trackUrl;
            RunnableProjectsModel runnableProjectsModel = this.runnableProjectsModel;
            if (runnableProjectsModel == null || (runnableProjectsModel = runnableProjectsModel.getProjects()) == null) break block0;
            SourceExKt.adviseOnce((ISource)((ISource)runnableProjectsModel), (Lifetime)this.lifetime, arg_0 -> AspireHostConfigurationViewModel.reset$lambda$13(this, dotNetStartBrowserParameters, projectFilePath, launchProfileName, trackEnvs, envs, trackUrl, arg_0));
        }
    }

    private final List<LaunchProfile> getLaunchProfiles(RunnableProject runnableProject) {
        LaunchSettingsJson.LaunchSettings launchSettings = LaunchSettingsJsonService.INSTANCE.loadLaunchSettings(runnableProject);
        LaunchSettingsJson.LaunchSettings launchSettings2 = launchSettings;
        Map map = launchSettings2 != null ? launchSettings2.getProfiles() : null;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Sequence $this$sortedBy$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)map), AspireHostConfigurationViewModel::getLaunchProfiles$lambda$14), AspireHostConfigurationViewModel::getLaunchProfiles$lambda$15);
        boolean $i$f$sortedBy = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LaunchProfile it = (LaunchProfile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (LaunchProfile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        }));
    }

    private static final boolean _init_$lambda$0(RunnableProject p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return Intrinsics.areEqual((Object)p.getKind(), (Object)AspireRunnableProjectKinds.INSTANCE.getAspireHost());
    }

    private static final Unit _init_$lambda$1(AspireHostConfigurationViewModel this$0, LaunchProfile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleProfileSelection();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(AspireHostConfigurationViewModel this$0, Map it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleEnvValueChange();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(AspireHostConfigurationViewModel this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleUrlValueChange();
        return Unit.INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Unit reset$lambda$13(AspireHostConfigurationViewModel this$0, DotNetStartBrowserParameters $dotNetStartBrowserParameters, String $projectFilePath, String $launchProfileName, boolean $trackEnvs, Map $envs, boolean $trackUrl, List projectList) {
        block22: {
            Object v2;
            ViewableList it3;
            block18: {
                block21: {
                    Iterable $this$none$iv;
                    block20: {
                        boolean bl;
                        block16: {
                            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$dotNetStartBrowserParameters, (String)"$dotNetStartBrowserParameters");
                            Intrinsics.checkNotNullParameter((Object)$projectFilePath, (String)"$projectFilePath");
                            Intrinsics.checkNotNullParameter((Object)$launchProfileName, (String)"$launchProfileName");
                            Intrinsics.checkNotNullParameter($envs, (String)"$envs");
                            Intrinsics.checkNotNullParameter((Object)projectList, (String)"projectList");
                            this$0.dotNetBrowserSettingsEditor.getSettings().set((Object)new BrowserSettings($dotNetStartBrowserParameters.getStartAfterLaunch(), $dotNetStartBrowserParameters.getWithJavaScriptDebugger(), $dotNetStartBrowserParameters.getBrowser()));
                            if (((CharSequence)$projectFilePath).length() == 0) break block20;
                            $this$none$iv = projectList;
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (Iterator element$iv : $this$none$iv) {
                                    RunnableProject it2 = (RunnableProject)element$iv;
                                    boolean bl2 = false;
                                    if (!(Intrinsics.areEqual((Object)it2.getProjectFilePath(), (Object)$projectFilePath) && Intrinsics.areEqual((Object)it2.getKind(), (Object)AspireRunnableProjectKinds.INSTANCE.getAspireHost()))) continue;
                                    bl = false;
                                    break block16;
                                }
                                bl = true;
                            }
                        }
                        if (!bl) break block21;
                    }
                    if (((CharSequence)$projectFilePath).length() == 0) {
                        Object v1;
                        block17: {
                            Iterable $this$firstOrNull$iv = projectList;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                RunnableProject it3 = (RunnableProject)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it3.getKind(), (Object)AspireRunnableProjectKinds.INSTANCE.getAspireHost())) continue;
                                v1 = element$iv;
                                break block17;
                            }
                            v1 = null;
                        }
                        $this$none$iv = v1;
                        if ($this$none$iv != null) {
                            Iterable runnableProject = $this$none$iv;
                            boolean bl = false;
                            this$0.projectSelector.getProject().set((Object)runnableProject);
                            this$0.isLoaded = true;
                            this$0.handleProjectSelection((RunnableProject)runnableProject);
                        }
                        break block22;
                    } else {
                        ViewableList runnableProject;
                        String fakeProjectName = new File($projectFilePath).getName();
                        Intrinsics.checkNotNull((Object)fakeProjectName);
                        RunnableProject fakeProject = new RunnableProject(fakeProjectName, fakeProjectName, $projectFilePath, RunnableProjectKinds.INSTANCE.getUnloaded(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), null, CollectionsKt.emptyList());
                        ViewableList $this$reset_u24lambda_u2413_u24lambda_u248 = runnableProject = this$0.projectSelector.getProjectList();
                        boolean bl = false;
                        $this$reset_u24lambda_u2413_u24lambda_u248.clear();
                        $this$reset_u24lambda_u2413_u24lambda_u248.addAll((Collection)CollectionsKt.plus((Collection)projectList, (Object)fakeProject));
                        this$0.projectSelector.getProject().set((Object)fakeProject);
                    }
                    break block22;
                }
                Iterable $this$singleOrNull$iv = projectList;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                it3 = $this$singleOrNull$iv.iterator();
                while (it3.hasNext()) {
                    Object element$iv = it3.next();
                    RunnableProject it4 = (RunnableProject)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it4.getProjectFilePath(), (Object)$projectFilePath) && Intrinsics.areEqual((Object)it4.getKind(), (Object)AspireRunnableProjectKinds.INSTANCE.getAspireHost()))) continue;
                    if (found$iv) {
                        v2 = null;
                        break block18;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v2 = !found$iv ? null : single$iv;
            }
            RunnableProject runnableProject = v2;
            if (runnableProject != null) {
                Object v3;
                block19: {
                    RunnableProject runnableProject2 = runnableProject;
                    boolean bl = false;
                    this$0.projectSelector.getProject().set((Object)runnableProject2);
                    List<LaunchProfile> launchProfiles = this$0.getLaunchProfiles(runnableProject2);
                    ViewableList $this$reset_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410 = it3 = this$0.launchProfileSelector.getProfileList();
                    boolean bl3 = false;
                    $this$reset_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.clear();
                    $this$reset_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.addAll((Collection)launchProfiles);
                    Iterable $this$firstOrNull$iv = (Iterable)this$0.launchProfileSelector.getProfileList();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        LaunchProfile it5 = (LaunchProfile)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it5.getName(), (Object)$launchProfileName)) continue;
                        v3 = element$iv;
                        break block19;
                    }
                    v3 = null;
                }
                LaunchProfile launchProfile = v3;
                if (launchProfile != null) {
                    this$0.launchProfileSelector.getProfile().set((Object)launchProfile);
                } else {
                    LaunchProfile fakeLaunchProfile = new LaunchProfile($launchProfileName, LaunchSettingsJson.Profile.Companion.getUNKNOWN());
                    this$0.launchProfileSelector.getProfileList().add((Object)fakeLaunchProfile);
                    this$0.launchProfileSelector.getProfile().set((Object)fakeLaunchProfile);
                }
                this$0.isLoaded = true;
                if (launchProfile != null) {
                    Map<String, String> effectiveEnvs = $trackEnvs ? AspireLaunchProfileUtilsKt.getEnvironmentVariables(launchProfile.getName(), launchProfile.getContent()) : $envs;
                    this$0.environmentVariablesEditor.getEnvs().set(effectiveEnvs);
                    String effectiveUrl = $trackUrl ? AspireLaunchProfileUtilsKt.getApplicationUrl(launchProfile.getContent()) : $dotNetStartBrowserParameters.getUrl();
                    IProperty iProperty = this$0.urlEditor.getDefaultValue();
                    String string = effectiveUrl;
                    if (string == null) {
                        string = "";
                    }
                    iProperty.setValue((Object)string);
                    IProperty iProperty2 = this$0.urlEditor.getText();
                    String string2 = effectiveUrl;
                    if (string2 == null) {
                        string2 = "";
                    }
                    iProperty2.setValue((Object)string2);
                }
            }
        }
        this$0.isLoaded = true;
        return Unit.INSTANCE;
    }

    private static final boolean getLaunchProfiles$lambda$14(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.equals((String)((LaunchSettingsJson.Profile)it.getValue()).getCommandName(), (String)"Project", (boolean)true);
    }

    private static final LaunchProfile getLaunchProfiles$lambda$15(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String name = (String)entry.getKey();
        LaunchSettingsJson.Profile content = (LaunchSettingsJson.Profile)entry.getValue();
        return new LaunchProfile(name, content);
    }
}

