/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.database;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.converters.ConnectionStringToJdbcUrlConverter;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.DotnetDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.MySqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.NpgsqlDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.OracleClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.dataProviders.SqlClientDataProvider;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.factories.ConnectionStringsFactory;
import com.jetbrains.rider.plugins.appender.database.jdbcToConnectionString.shared.connectionStrings.ConnectionString;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import me.rafaelldi.aspire.database.DatabaseResource;
import me.rafaelldi.aspire.database.DatabaseResourceConnectionString;
import me.rafaelldi.aspire.database.DatabaseResourceType;
import me.rafaelldi.aspire.database.DatabaseService;
import me.rafaelldi.aspire.database.DummyMongoDataProvider;
import me.rafaelldi.aspire.database.DummyRedisDataProvider;
import me.rafaelldi.aspire.settings.AspireSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 -2\u00020\u0001:\u0006-./012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000fJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001fH\u0082@\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020#H\u0082@\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u001e\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000fH\u0082@\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020,H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "rawConnectionStringTypes", "", "Lme/rafaelldi/aspire/database/DatabaseResourceType;", "connectionStrings", "", "Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;", "databaseResources", "Lme/rafaelldi/aspire/database/DatabaseResource;", "createdConnections", "", "lock", "commands", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;", "addConnectionString", "", "connectionString", "addDatabaseResource", "resource", "handleCommand", "command", "(Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleAddConnectionStringCommand", "Lme/rafaelldi/aspire/database/DatabaseService$AddConnectionStringCommand;", "(Lme/rafaelldi/aspire/database/DatabaseService$AddConnectionStringCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findResourceByConnectionString", "handleAddDatabaseResourceCommand", "Lme/rafaelldi/aspire/database/DatabaseService$AddDatabaseResourceCommand;", "(Lme/rafaelldi/aspire/database/DatabaseService$AddDatabaseResourceCommand;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findConnectionStringByResource", "createDataSource", "(Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;Lme/rafaelldi/aspire/database/DatabaseResource;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertRedisConnectionString", "handleRemoveConnectionStringCommand", "Lme/rafaelldi/aspire/database/DatabaseService$RemoveConnectionStringCommand;", "handleRemoveDatabaseResourceCommand", "Lme/rafaelldi/aspire/database/DatabaseService$RemoveDatabaseResourceCommand;", "Companion", "DatabaseResourceCommand", "AddConnectionStringCommand", "RemoveConnectionStringCommand", "AddDatabaseResourceCommand", "RemoveDatabaseResourceCommand", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseService.kt\nme/rafaelldi/aspire/database/DatabaseService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n1#2:220\n*E\n"})
public final class DatabaseService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<DatabaseResourceType> rawConnectionStringTypes;
    @NotNull
    private final Set<DatabaseResourceConnectionString> connectionStrings;
    @NotNull
    private final Set<DatabaseResource> databaseResources;
    @NotNull
    private final Set<String> createdConnections;
    @NotNull
    private final Object lock;
    @NotNull
    private final MutableSharedFlow<DatabaseResourceCommand> commands;
    @NotNull
    private static final String REDIS_CONNECTION_STRING_PATTERN = "(?<host>\\w*):(?<port>\\d*)(,user=(?<user>\\w*))?(,password=(?<password>\\w*))?";
    @NotNull
    private static final Regex REDIS_REGEX = new Regex("(?<host>\\w*):(?<port>\\d*)(,user=(?<user>\\w*))?(,password=(?<password>\\w*))?");

    public DatabaseService(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        BufferOverflow bufferOverflow = new BufferOverflow[]{DatabaseResourceType.MSSQL, DatabaseResourceType.MONGO};
        this.rawConnectionStringTypes = CollectionsKt.listOf((Object[])bufferOverflow);
        this.connectionStrings = new LinkedHashSet();
        this.databaseResources = new LinkedHashSet();
        this.createdConnections = new LinkedHashSet();
        this.lock = new Object();
        bufferOverflow = BufferOverflow.DROP_OLDEST;
        this.commands = SharedFlowKt.MutableSharedFlow$default((int)0, (int)100, (BufferOverflow)bufferOverflow, (int)1, null);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DatabaseService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.commands.collect(new FlowCollector(){

                            public final Object emit(DatabaseResourceCommand it, Continuation<? super Unit> $completion) {
                                Object object = this$0.handleCommand(it, (Continuation<? super Unit>)$completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void addConnectionString(@NotNull DatabaseResourceConnectionString connectionString) {
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        if (!AspireSettings.Companion.getInstance().getConnectToDatabase()) {
            return;
        }
        connectionString.getLifetime().bracketIfAlive(() -> DatabaseService.addConnectionString$lambda$0(this, connectionString), () -> DatabaseService.addConnectionString$lambda$1(this, connectionString));
    }

    public final void addDatabaseResource(@NotNull DatabaseResource resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        if (!AspireSettings.Companion.getInstance().getConnectToDatabase()) {
            return;
        }
        resource.getLifetime().bracketIfAlive(() -> DatabaseService.addDatabaseResource$lambda$2(this, resource), () -> DatabaseService.addDatabaseResource$lambda$3(this, resource));
    }

    private final Object handleCommand(DatabaseResourceCommand command, Continuation<? super Unit> $completion) {
        DatabaseResourceCommand databaseResourceCommand = command;
        if (databaseResourceCommand instanceof AddConnectionStringCommand) {
            Object object = this.handleAddConnectionStringCommand((AddConnectionStringCommand)command, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (databaseResourceCommand instanceof RemoveConnectionStringCommand) {
            this.handleRemoveConnectionStringCommand((RemoveConnectionStringCommand)command);
        } else {
            if (databaseResourceCommand instanceof AddDatabaseResourceCommand) {
                Object object = this.handleAddDatabaseResourceCommand((AddDatabaseResourceCommand)command, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            if (databaseResourceCommand instanceof RemoveDatabaseResourceCommand) {
                this.handleRemoveDatabaseResourceCommand((RemoveDatabaseResourceCommand)command);
            }
        }
        return Unit.INSTANCE;
    }

    private final Object handleAddConnectionStringCommand(AddConnectionStringCommand command, Continuation<? super Unit> $completion) {
        DatabaseResource resource = this.findResourceByConnectionString(command.getConnectionString());
        if (resource != null) {
            Object object = this.createDataSource(command.getConnectionString(), resource, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        this.connectionStrings.add(command.getConnectionString());
        return Unit.INSTANCE;
    }

    private final DatabaseResource findResourceByConnectionString(DatabaseResourceConnectionString connectionString) {
        for (DatabaseResource resource : this.databaseResources) {
            for (String port : resource.getPorts()) {
                if (!StringsKt.contains$default((CharSequence)connectionString.getConnectionString(), (CharSequence)port, (boolean)false, (int)2, null)) continue;
                return resource;
            }
        }
        return null;
    }

    private final Object handleAddDatabaseResourceCommand(AddDatabaseResourceCommand command, Continuation<? super Unit> $completion) {
        DatabaseResourceConnectionString connectionString = this.findConnectionStringByResource(command.getResource());
        if (connectionString != null) {
            Object object = this.createDataSource(connectionString, command.getResource(), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        this.databaseResources.add(command.getResource());
        return Unit.INSTANCE;
    }

    private final DatabaseResourceConnectionString findConnectionStringByResource(DatabaseResource resource) {
        for (DatabaseResourceConnectionString connectionString : this.connectionStrings) {
            for (String port : resource.getPorts()) {
                if (!StringsKt.contains$default((CharSequence)connectionString.getConnectionString(), (CharSequence)port, (boolean)false, (int)2, null)) continue;
                return connectionString;
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object createDataSource(DatabaseResourceConnectionString var1_1, DatabaseResource var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof createDataSource.1)) ** GOTO lbl-1000
        var13_4 = $completion;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DatabaseService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DatabaseService.access$createDataSource(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.createdConnections.contains(connectionString.getConnectionString())) {
                    return Unit.INSTANCE;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[resource.getType().ordinal()]) {
                    case 1: {
                        v0 = (DotnetDataProvider)NpgsqlDataProvider.Companion.getInstance(this.project);
                        break;
                    }
                    case 2: {
                        v0 = (DotnetDataProvider)MySqlClientDataProvider.Companion.getInstance(this.project);
                        break;
                    }
                    case 3: {
                        v0 = (DotnetDataProvider)SqlClientDataProvider.Companion.getInstance(this.project);
                        break;
                    }
                    case 4: {
                        v0 = (DotnetDataProvider)OracleClientDataProvider.Companion.getInstance(this.project);
                        break;
                    }
                    case 5: {
                        v0 = DummyMongoDataProvider.Companion.getInstance(this.project);
                        break;
                    }
                    case 6: {
                        v0 = DummyRedisDataProvider.Companion.getInstance(this.project);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                dataProvider = v0;
                v1 = DbImplUtil.guessDatabaseDriver((Dbms)((Dbms)CollectionsKt.first((Iterable)dataProvider.getDbms())));
                if (v1 == null) {
                    return Unit.INSTANCE;
                }
                driver = v1;
                if (resource.getType() != DatabaseResourceType.REDIS) ** GOTO lbl45
                v2 = this.convertRedisConnectionString(connectionString.getConnectionString());
                if (v2 == null) {
                    return Unit.INSTANCE;
                }
                ** GOTO lbl94
lbl45:
                // 1 sources

                if (!this.rawConnectionStringTypes.contains((Object)resource.getType())) ** GOTO lbl48
                v2 = connectionString.getConnectionString();
                ** GOTO lbl94
lbl48:
                // 1 sources

                v3 = ConnectionStringsFactory.Companion.get(dataProvider, this.project);
                if (v3 == null) {
                    return Unit.INSTANCE;
                }
                factory = v3;
                $continuation.L$0 = this;
                $continuation.L$1 = connectionString;
                $continuation.L$2 = resource;
                $continuation.L$3 = driver;
                $continuation.label = 1;
                v4 = factory.create-0E7RQCE(connectionString.getConnectionString(), dataProvider, (Continuation)$continuation);
                if (v4 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl68
            }
            case 1: {
                driver = (DatabaseDriver)$continuation.L$3;
                resource = (DatabaseResource)$continuation.L$2;
                connectionString = (DatabaseResourceConnectionString)$continuation.L$1;
                this = (DatabaseService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = ((Result)$result).unbox-impl();
lbl68:
                // 2 sources

                v5 = (ConnectionString)(Result.isFailure-impl((Object)(var10_10 = v4)) != false ? null : var10_10);
                if (v5 == null) {
                    return Unit.INSTANCE;
                }
                parsedConnectionString = v5;
                var9_12 = ConnectionStringToJdbcUrlConverter.Companion.convert(parsedConnectionString, driver, this.project);
                if (var9_12 == null) ** GOTO lbl-1000
                $continuation.L$0 = this;
                $continuation.L$1 = connectionString;
                $continuation.L$2 = resource;
                $continuation.L$3 = driver;
                $continuation.label = 2;
                v6 = var9_12.build-IoAF18A((Continuation)$continuation);
                if (v6 == var14_6) {
                    return var14_6;
                }
                ** GOTO lbl90
            }
            case 2: {
                driver = (DatabaseDriver)$continuation.L$3;
                resource = (DatabaseResource)$continuation.L$2;
                connectionString = (DatabaseResourceConnectionString)$continuation.L$1;
                this = (DatabaseService)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = ((Result)$result).unbox-impl();
lbl90:
                // 2 sources

                if ((var11_13 = (String)(Result.isFailure-impl((Object)(var10_10 = v6)) != false ? null : var10_10)) != null) {
                    v2 = var11_13;
                } else lbl-1000:
                // 2 sources

                {
                    return Unit.INSTANCE;
                }
lbl94:
                // 3 sources

                url = v2;
                $this$createDataSource_u24lambda_u244 = var9_12 = LocalDataSource.fromDriver((DatabaseDriver)driver, (String)url, (boolean)true);
                $i$a$-apply-DatabaseService$createDataSource$dataSource$1 = false;
                $this$createDataSource_u24lambda_u244.setName(connectionString.getName());
                v7 = var9_12;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"apply(...)");
                dataSource = v7;
                v8 = LocalDataSourceManager.getInstance((Project)this.project);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getInstance(...)");
                dataSourceManager = v8;
                resource.getLifetime().bracketIfAlive((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createDataSource$lambda$7(me.rafaelldi.aspire.database.DatabaseService me.rafaelldi.aspire.database.DatabaseResourceConnectionString com.intellij.database.dataSource.LocalDataSourceManager com.intellij.database.dataSource.LocalDataSource ), ()Lkotlin/Unit;)((DatabaseService)this, (DatabaseResourceConnectionString)connectionString, (LocalDataSourceManager)dataSourceManager, (LocalDataSource)dataSource), (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, createDataSource$lambda$10(me.rafaelldi.aspire.database.DatabaseService me.rafaelldi.aspire.database.DatabaseResourceConnectionString com.intellij.database.dataSource.LocalDataSourceManager com.intellij.database.dataSource.LocalDataSource ), ()Lkotlin/Unit;)((DatabaseService)this, (DatabaseResourceConnectionString)connectionString, (LocalDataSourceManager)dataSourceManager, (LocalDataSource)dataSource));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String convertRedisConnectionString(String connectionString) {
        StringBuilder sb;
        block4: {
            String it;
            MatchResult matchResult = REDIS_REGEX.matchEntire((CharSequence)connectionString);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"host");
            String host = matchGroup != null ? matchGroup.getValue() : null;
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"port");
            String port = matchGroup2 != null ? matchGroup2.getValue() : null;
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"user");
            String user = matchGroup3 != null ? matchGroup3.getValue() : null;
            MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult2.getGroups(), (String)"password");
            String password = matchGroup4 != null ? matchGroup4.getValue() : null;
            sb = new StringBuilder("jdbc:redis://");
            String string = user;
            if (string != null) {
                it = string;
                boolean bl = false;
                sb.append(it).append(":");
            }
            String string2 = password;
            if (string2 != null) {
                it = string2;
                boolean bl = false;
                sb.append(it).append("@");
            }
            String string3 = host;
            if (string3 != null) {
                it = string3;
                boolean bl = false;
                sb.append(it);
            }
            String string4 = port;
            if (string4 == null) break block4;
            it = string4;
            boolean bl = false;
            sb.append(":").append(it);
        }
        return sb.toString();
    }

    private final void handleRemoveConnectionStringCommand(RemoveConnectionStringCommand command) {
        this.connectionStrings.remove(command.getConnectionString());
    }

    private final void handleRemoveDatabaseResourceCommand(RemoveDatabaseResourceCommand command) {
        this.databaseResources.remove(command.getResource());
    }

    private static final boolean addConnectionString$lambda$0(DatabaseService this$0, DatabaseResourceConnectionString $connectionString) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$connectionString, (String)"$connectionString");
        return this$0.commands.tryEmit((Object)new AddConnectionStringCommand($connectionString));
    }

    private static final Unit addConnectionString$lambda$1(DatabaseService this$0, DatabaseResourceConnectionString $connectionString) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$connectionString, (String)"$connectionString");
        this$0.commands.tryEmit((Object)new RemoveConnectionStringCommand($connectionString));
        return Unit.INSTANCE;
    }

    private static final boolean addDatabaseResource$lambda$2(DatabaseService this$0, DatabaseResource $resource) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resource, (String)"$resource");
        return this$0.commands.tryEmit((Object)new AddDatabaseResourceCommand($resource));
    }

    private static final Unit addDatabaseResource$lambda$3(DatabaseService this$0, DatabaseResource $resource) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resource, (String)"$resource");
        this$0.commands.tryEmit((Object)new RemoveDatabaseResourceCommand($resource));
        return Unit.INSTANCE;
    }

    private static final void createDataSource$lambda$7$lambda$6(LocalDataSourceManager $dataSourceManager, LocalDataSource $dataSource) {
        Intrinsics.checkNotNullParameter((Object)$dataSourceManager, (String)"$dataSourceManager");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        $dataSourceManager.addDataSource($dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit createDataSource$lambda$7(DatabaseService this$0, DatabaseResourceConnectionString $connectionString, LocalDataSourceManager $dataSourceManager, LocalDataSource $dataSource) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$connectionString, (String)"$connectionString");
        Intrinsics.checkNotNullParameter((Object)$dataSourceManager, (String)"$dataSourceManager");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this$0.createdConnections.add($connectionString.getConnectionString());
        }
        ApplicationKt.getApplication().invokeLater(() -> DatabaseService.createDataSource$lambda$7$lambda$6($dataSourceManager, $dataSource));
        return Unit.INSTANCE;
    }

    private static final void createDataSource$lambda$10$lambda$9(LocalDataSourceManager $dataSourceManager, LocalDataSource $dataSource) {
        Intrinsics.checkNotNullParameter((Object)$dataSourceManager, (String)"$dataSourceManager");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        $dataSourceManager.removeDataSource($dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit createDataSource$lambda$10(DatabaseService this$0, DatabaseResourceConnectionString $connectionString, LocalDataSourceManager $dataSourceManager, LocalDataSource $dataSource) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$connectionString, (String)"$connectionString");
        Intrinsics.checkNotNullParameter((Object)$dataSourceManager, (String)"$dataSourceManager");
        Intrinsics.checkNotNullParameter((Object)$dataSource, (String)"$dataSource");
        Object object = this$0.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this$0.createdConnections.remove($connectionString.getConnectionString());
        }
        ApplicationKt.getApplication().invokeLater(() -> DatabaseService.createDataSource$lambda$10$lambda$9($dataSourceManager, $dataSource));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$handleAddConnectionStringCommand(DatabaseService $this, AddConnectionStringCommand command, Continuation $completion) {
        return $this.handleAddConnectionStringCommand(command, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleAddDatabaseResourceCommand(DatabaseService $this, AddDatabaseResourceCommand command, Continuation $completion) {
        return $this.handleAddDatabaseResourceCommand(command, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$createDataSource(DatabaseService $this, DatabaseResourceConnectionString connectionString, DatabaseResource resource, Continuation $completion) {
        return $this.createDataSource(connectionString, resource, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService$AddConnectionStringCommand;", "Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;", "connectionString", "Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;", "<init>", "(Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;)V", "getConnectionString", "()Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aspire-plugin"})
    private static final class AddConnectionStringCommand
    implements DatabaseResourceCommand {
        @NotNull
        private final DatabaseResourceConnectionString connectionString;

        public AddConnectionStringCommand(@NotNull DatabaseResourceConnectionString connectionString) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            this.connectionString = connectionString;
        }

        @NotNull
        public final DatabaseResourceConnectionString getConnectionString() {
            return this.connectionString;
        }

        @NotNull
        public final DatabaseResourceConnectionString component1() {
            return this.connectionString;
        }

        @NotNull
        public final AddConnectionStringCommand copy(@NotNull DatabaseResourceConnectionString connectionString) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            return new AddConnectionStringCommand(connectionString);
        }

        public static /* synthetic */ AddConnectionStringCommand copy$default(AddConnectionStringCommand addConnectionStringCommand, DatabaseResourceConnectionString databaseResourceConnectionString, int n, Object object) {
            if ((n & 1) != 0) {
                databaseResourceConnectionString = addConnectionStringCommand.connectionString;
            }
            return addConnectionStringCommand.copy(databaseResourceConnectionString);
        }

        @NotNull
        public String toString() {
            return "AddConnectionStringCommand(connectionString=" + this.connectionString + ")";
        }

        public int hashCode() {
            return this.connectionString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddConnectionStringCommand)) {
                return false;
            }
            AddConnectionStringCommand addConnectionStringCommand = (AddConnectionStringCommand)other;
            return Intrinsics.areEqual((Object)this.connectionString, (Object)addConnectionStringCommand.connectionString);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService$AddDatabaseResourceCommand;", "Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;", "resource", "Lme/rafaelldi/aspire/database/DatabaseResource;", "<init>", "(Lme/rafaelldi/aspire/database/DatabaseResource;)V", "getResource", "()Lme/rafaelldi/aspire/database/DatabaseResource;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aspire-plugin"})
    private static final class AddDatabaseResourceCommand
    implements DatabaseResourceCommand {
        @NotNull
        private final DatabaseResource resource;

        public AddDatabaseResourceCommand(@NotNull DatabaseResource resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            this.resource = resource;
        }

        @NotNull
        public final DatabaseResource getResource() {
            return this.resource;
        }

        @NotNull
        public final DatabaseResource component1() {
            return this.resource;
        }

        @NotNull
        public final AddDatabaseResourceCommand copy(@NotNull DatabaseResource resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            return new AddDatabaseResourceCommand(resource);
        }

        public static /* synthetic */ AddDatabaseResourceCommand copy$default(AddDatabaseResourceCommand addDatabaseResourceCommand, DatabaseResource databaseResource, int n, Object object) {
            if ((n & 1) != 0) {
                databaseResource = addDatabaseResourceCommand.resource;
            }
            return addDatabaseResourceCommand.copy(databaseResource);
        }

        @NotNull
        public String toString() {
            return "AddDatabaseResourceCommand(resource=" + this.resource + ")";
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AddDatabaseResourceCommand)) {
                return false;
            }
            AddDatabaseResourceCommand addDatabaseResourceCommand = (AddDatabaseResourceCommand)other;
            return Intrinsics.areEqual((Object)this.resource, (Object)addDatabaseResourceCommand.resource);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService$Companion;", "", "<init>", "()V", "getInstance", "Lme/rafaelldi/aspire/database/DatabaseService;", "project", "Lcom/intellij/openapi/project/Project;", "REDIS_CONNECTION_STRING_PATTERN", "", "REDIS_REGEX", "Lkotlin/text/Regex;", "aspire-plugin"})
    @SourceDebugExtension(value={"SMAP\nDatabaseService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseService.kt\nme/rafaelldi/aspire/database/DatabaseService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,219:1\n31#2,2:220\n*S KotlinDebug\n*F\n+ 1 DatabaseService.kt\nme/rafaelldi/aspire/database/DatabaseService$Companion\n*L\n25#1:220,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DatabaseService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DatabaseService> serviceClass$iv = DatabaseService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DatabaseService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bb\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;", "", "aspire-plugin"})
    private static interface DatabaseResourceCommand {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService$RemoveConnectionStringCommand;", "Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;", "connectionString", "Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;", "<init>", "(Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;)V", "getConnectionString", "()Lme/rafaelldi/aspire/database/DatabaseResourceConnectionString;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aspire-plugin"})
    private static final class RemoveConnectionStringCommand
    implements DatabaseResourceCommand {
        @NotNull
        private final DatabaseResourceConnectionString connectionString;

        public RemoveConnectionStringCommand(@NotNull DatabaseResourceConnectionString connectionString) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            this.connectionString = connectionString;
        }

        @NotNull
        public final DatabaseResourceConnectionString getConnectionString() {
            return this.connectionString;
        }

        @NotNull
        public final DatabaseResourceConnectionString component1() {
            return this.connectionString;
        }

        @NotNull
        public final RemoveConnectionStringCommand copy(@NotNull DatabaseResourceConnectionString connectionString) {
            Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
            return new RemoveConnectionStringCommand(connectionString);
        }

        public static /* synthetic */ RemoveConnectionStringCommand copy$default(RemoveConnectionStringCommand removeConnectionStringCommand, DatabaseResourceConnectionString databaseResourceConnectionString, int n, Object object) {
            if ((n & 1) != 0) {
                databaseResourceConnectionString = removeConnectionStringCommand.connectionString;
            }
            return removeConnectionStringCommand.copy(databaseResourceConnectionString);
        }

        @NotNull
        public String toString() {
            return "RemoveConnectionStringCommand(connectionString=" + this.connectionString + ")";
        }

        public int hashCode() {
            return this.connectionString.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoveConnectionStringCommand)) {
                return false;
            }
            RemoveConnectionStringCommand removeConnectionStringCommand = (RemoveConnectionStringCommand)other;
            return Intrinsics.areEqual((Object)this.connectionString, (Object)removeConnectionStringCommand.connectionString);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lme/rafaelldi/aspire/database/DatabaseService$RemoveDatabaseResourceCommand;", "Lme/rafaelldi/aspire/database/DatabaseService$DatabaseResourceCommand;", "resource", "Lme/rafaelldi/aspire/database/DatabaseResource;", "<init>", "(Lme/rafaelldi/aspire/database/DatabaseResource;)V", "getResource", "()Lme/rafaelldi/aspire/database/DatabaseResource;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "aspire-plugin"})
    private static final class RemoveDatabaseResourceCommand
    implements DatabaseResourceCommand {
        @NotNull
        private final DatabaseResource resource;

        public RemoveDatabaseResourceCommand(@NotNull DatabaseResource resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            this.resource = resource;
        }

        @NotNull
        public final DatabaseResource getResource() {
            return this.resource;
        }

        @NotNull
        public final DatabaseResource component1() {
            return this.resource;
        }

        @NotNull
        public final RemoveDatabaseResourceCommand copy(@NotNull DatabaseResource resource) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            return new RemoveDatabaseResourceCommand(resource);
        }

        public static /* synthetic */ RemoveDatabaseResourceCommand copy$default(RemoveDatabaseResourceCommand removeDatabaseResourceCommand, DatabaseResource databaseResource, int n, Object object) {
            if ((n & 1) != 0) {
                databaseResource = removeDatabaseResourceCommand.resource;
            }
            return removeDatabaseResourceCommand.copy(databaseResource);
        }

        @NotNull
        public String toString() {
            return "RemoveDatabaseResourceCommand(resource=" + this.resource + ")";
        }

        public int hashCode() {
            return this.resource.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RemoveDatabaseResourceCommand)) {
                return false;
            }
            RemoveDatabaseResourceCommand removeDatabaseResourceCommand = (RemoveDatabaseResourceCommand)other;
            return Intrinsics.areEqual((Object)this.resource, (Object)removeDatabaseResourceCommand.resource);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseResourceType.values().length];
            try {
                nArray[DatabaseResourceType.POSTGRES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseResourceType.MYSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseResourceType.MSSQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseResourceType.ORACLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseResourceType.MONGO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseResourceType.REDIS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

