/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.database;

import com.intellij.openapi.project.Project;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import me.rafaelldi.aspire.database.DatabaseResource;
import me.rafaelldi.aspire.database.DatabaseResourceConnectionString;
import me.rafaelldi.aspire.database.DatabaseResourceType;
import me.rafaelldi.aspire.database.DatabaseService;
import me.rafaelldi.aspire.generated.ResourceEnvironmentVariable;
import me.rafaelldi.aspire.generated.ResourceType;
import me.rafaelldi.aspire.generated.ResourceUrl;
import me.rafaelldi.aspire.services.AspireResourceService;
import me.rafaelldi.aspire.services.ResourceListener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lme/rafaelldi/aspire/database/DatabaseResourceListener;", "Lme/rafaelldi/aspire/services/ResourceListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resourceCreated", "", "resource", "Lme/rafaelldi/aspire/services/AspireResourceService;", "resourceUpdated", "applyChanges", "getType", "Lme/rafaelldi/aspire/database/DatabaseResourceType;", "image", "", "Companion", "aspire-plugin"})
@SourceDebugExtension(value={"SMAP\nDatabaseResourceListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseResourceListener.kt\nme/rafaelldi/aspire/database/DatabaseResourceListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n3792#2:82\n4307#2,2:83\n1855#3,2:85\n*S KotlinDebug\n*F\n+ 1 DatabaseResourceListener.kt\nme/rafaelldi/aspire/database/DatabaseResourceListener\n*L\n33#1:82\n33#1:83,2\n34#1:85,2\n*E\n"})
public final class DatabaseResourceListener
implements ResourceListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String CONNECTION_STRINGS = "ConnectionStrings";
    @NotNull
    private static final String CONNECTION_STRING_PREFIX = "ConnectionStrings__";
    @NotNull
    private static final String POSTGRES = "postgres";
    @NotNull
    private static final String MYSQL = "mysql";
    @NotNull
    private static final String MSSQL = "mssql";
    @NotNull
    private static final String ORACLE = "oracle";
    @NotNull
    private static final String MONGO = "mongo";
    @NotNull
    private static final String REDIS = "redis";

    public DatabaseResourceListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public void resourceCreated(@NotNull AspireResourceService resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.applyChanges(resource);
    }

    @Override
    public void resourceUpdated(@NotNull AspireResourceService resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.applyChanges(resource);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyChanges(AspireResourceService resource) {
        DatabaseService service = DatabaseService.Companion.getInstance(this.project);
        if (resource.getType() == ResourceType.Project) {
            Iterator $this$filterTo$iv$iv;
            ResourceEnvironmentVariable[] $this$filter$iv = resource.getEnvironment();
            boolean $i$f$filter = false;
            ResourceEnvironmentVariable[] resourceEnvironmentVariableArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!(StringsKt.startsWith$default((String)it.getKey(), (String)CONNECTION_STRINGS, (boolean)false, (int)2, null) && it.getValue() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResourceEnvironmentVariable it = (ResourceEnvironmentVariable)element$iv;
                boolean bl = false;
                CharSequence charSequence = it.getValue();
                if (charSequence == null || charSequence.length() == 0) continue;
                String connectionName = StringsKt.substringAfter$default((String)it.getKey(), (String)CONNECTION_STRING_PREFIX, null, (int)2, null);
                DatabaseResourceConnectionString connectionString = new DatabaseResourceConnectionString(connectionName, it.getValue(), resource.getLifetime());
                service.addConnectionString(connectionString);
            }
        } else if (resource.getType() == ResourceType.Container) {
            if (resource.getUrls().length == 0) {
                return;
            }
            DatabaseResourceType databaseResourceType = this.getType(resource.getContainerImage());
            if (databaseResourceType == null) {
                return;
            }
            DatabaseResourceType resourceType = databaseResourceType;
            List ports = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])resource.getUrls()), DatabaseResourceListener::applyChanges$lambda$2));
            DatabaseResource databaseResource = new DatabaseResource(resource.getName(), resourceType, ports, resource.getLifetime());
            service.addDatabaseResource(databaseResource);
        }
    }

    private final DatabaseResourceType getType(String image) {
        if (image == null) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)POSTGRES, (boolean)false, (int)2, null)) {
            return DatabaseResourceType.POSTGRES;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)MYSQL, (boolean)false, (int)2, null)) {
            return DatabaseResourceType.MYSQL;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)MSSQL, (boolean)false, (int)2, null)) {
            return DatabaseResourceType.MSSQL;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)ORACLE, (boolean)false, (int)2, null)) {
            return DatabaseResourceType.ORACLE;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)MONGO, (boolean)false, (int)2, null)) {
            return DatabaseResourceType.MONGO;
        }
        if (StringsKt.contains$default((CharSequence)image, (CharSequence)REDIS, (boolean)false, (int)2, null)) {
            return DatabaseResourceType.REDIS;
        }
        return null;
    }

    private static final String applyChanges$lambda$2(ResourceUrl it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        try {
            URI url = new URI(it.getFullUrl());
            string = String.valueOf(url.getPort());
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lme/rafaelldi/aspire/database/DatabaseResourceListener$Companion;", "", "<init>", "()V", "CONNECTION_STRINGS", "", "CONNECTION_STRING_PREFIX", "POSTGRES", "MYSQL", "MSSQL", "ORACLE", "MONGO", "REDIS", "aspire-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

