/*
 * Decompiled with CFR 0.152.
 */
package me.rafaelldi.aspire.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.rafaelldi.aspire.manifest.ManifestService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lme/rafaelldi/aspire/actions/ManifestGenerationAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "aspire-plugin"})
public final class ManifestGenerationAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        String isAspireHost;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.getProjectModelEntity$default((DataContext)dataContext, (boolean)false, (int)1, null);
        if (projectModelEntity == null) {
            return;
        }
        ProjectModelEntity entity = projectModelEntity;
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
        RdProjectDescriptor rdProjectDescriptor = rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? (RdProjectDescriptor)rdProjectModelItemDescriptor : null;
        if (rdProjectDescriptor == null) {
            return;
        }
        RdProjectDescriptor descriptor = rdProjectDescriptor;
        if (!descriptor.isDotNetCore()) {
            return;
        }
        String string = isAspireHost = ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((RdProjectModelItemDescriptor)descriptor), (String)"IsAspireHost");
        if (!(string != null ? StringsKt.equals((String)string, (String)"true", (boolean)true) : false)) {
            return;
        }
        VirtualFileUrl virtualFileUrl = entity.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return;
        }
        VirtualFileUrl file = virtualFileUrl;
        ManifestService manifestService = ManifestService.Companion.getInstance(project2);
        Path path = file.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        manifestService.generateManifest(path);
    }

    public void update(@NotNull AnActionEvent event) {
        String isAspireHost;
        RdProjectModelItemDescriptor descriptor;
        ProjectModelEntity entity;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DotNetCoreRuntime runtime = (DotNetCoreRuntime)RiderDotNetActiveRuntimeHost.Companion.getInstance(project).getDotNetCoreRuntime().getValue();
        if (runtime == null) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        ProjectModelEntity projectModelEntity = entity = ProjectModelEntityExtensionsKt.getProjectModelEntity$default((DataContext)dataContext, (boolean)false, (int)1, null);
        Object object = descriptor = projectModelEntity != null ? projectModelEntity.getDescriptor() : null;
        if (descriptor == null || !(descriptor instanceof RdProjectDescriptor) || !((RdProjectDescriptor)descriptor).isDotNetCore()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String string = isAspireHost = ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)descriptor, (String)"IsAspireHost");
        if (!(string != null ? StringsKt.equals((String)string, (String)"true", (boolean)true) : false)) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        event.getPresentation().setEnabledAndVisible(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

