/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.builder.FigureBuildInfo;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssembler;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.CompositeFigureLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.composite.CompositeFigureGridLayoutBase;
import org.jetbrains.letsPlot.core.spec.FigKind;
import org.jetbrains.letsPlot.core.spec.back.SpecTransformBackendUtil;
import org.jetbrains.letsPlot.core.spec.config.BunchConfig;
import org.jetbrains.letsPlot.core.spec.config.CompositeFigureConfig;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;
import org.jetbrains.letsPlot.core.spec.config.PlotConfig;
import org.jetbrains.letsPlot.core.spec.front.PlotConfigFrontend;
import org.jetbrains.letsPlot.core.spec.front.PlotConfigFrontendUtil;
import org.jetbrains.letsPlot.core.util.CompositeFigureBuildInfo;
import org.jetbrains.letsPlot.core.util.FigureGridScaleShareUtil;
import org.jetbrains.letsPlot.core.util.FigureToPlainSvg;
import org.jetbrains.letsPlot.core.util.PlotFigureBuildInfo;
import org.jetbrains.letsPlot.core.util.PlotSizeHelper;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;
import org.jetbrains.letsPlot.datamodel.svg.util.SvgToString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J?\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J5\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u001aJA\u0010\u001b\u001a\u00020\u00152\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u001cJU\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u001f2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0#H\u0002\u00a2\u0006\u0002\u0010$J?\u0010%\u001a\u00020\u001e2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010&JL\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0#2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010(\u001a\u00020)2\u0018\u0010*\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0#\u0012\u0004\u0012\u00020,0+J.\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010\u00172\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020,H\u0002\u00a8\u00062"}, d2={"Lorg/jetbrains/letsPlot/core/util/MonolithicCommon;", "", "()V", "buildCompositeFigure", "Lorg/jetbrains/letsPlot/core/util/CompositeFigureBuildInfo;", "config", "Lorg/jetbrains/letsPlot/core/spec/config/CompositeFigureConfig;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "computationMessages", "", "", "buildCompositeFigureFromProcessedSpecs", "plotSpec", "", "plotSize", "plotMaxWidth", "", "plotPreferredWidth", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/util/CompositeFigureBuildInfo;", "buildGGBunchFromProcessedSpecs", "Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult;", "bunchSpec", "", "maxWidth", "preferredWidth", "(Ljava/util/Map;Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult;", "buildPlotsFromProcessedSpecs", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult;", "buildSinglePlot", "Lorg/jetbrains/letsPlot/core/util/PlotFigureBuildInfo;", "Lorg/jetbrains/letsPlot/core/spec/front/PlotConfigFrontend;", "sharedContinuousDomainX", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "sharedContinuousDomainY", "", "(Lorg/jetbrains/letsPlot/core/spec/front/PlotConfigFrontend;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Ljava/util/List;)Lorg/jetbrains/letsPlot/core/util/PlotFigureBuildInfo;", "buildSinglePlotFromProcessedSpecs", "(Ljava/util/Map;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Ljava/lang/Double;Ljava/lang/Double;)Lorg/jetbrains/letsPlot/core/util/PlotFigureBuildInfo;", "buildSvgImagesFromRawSpecs", "svgToString", "Lorg/jetbrains/letsPlot/datamodel/svg/util/SvgToString;", "computationMessagesHandler", "Lkotlin/Function1;", "", "processRawSpecs", "frontendOnly", "", "throwTestingErrors", "PlotsBuildResult", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nMonolithicCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonolithicCommon.kt\norg/jetbrains/letsPlot/core/util/MonolithicCommon\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1360#2:348\n1446#2,5:349\n1549#2:354\n1620#2,3:355\n1549#2:358\n1620#2,3:359\n1559#2:362\n1590#2,4:363\n*S KotlinDebug\n*F\n+ 1 MonolithicCommon.kt\norg/jetbrains/letsPlot/core/util/MonolithicCommon\n*L\n45#1:348\n45#1:349,5\n50#1:354\n50#1:355,3\n52#1:358\n52#1:359,3\n262#1:362\n262#1:363,4\n*E\n"})
public final class MonolithicCommon {
    @NotNull
    public static final MonolithicCommon INSTANCE = new MonolithicCommon();

    private MonolithicCommon() {
    }

    @NotNull
    public final List<String> buildSvgImagesFromRawSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @NotNull SvgToString svgToString, @NotNull Function1<? super List<String>, Unit> computationMessagesHandler) {
        SvgSvgElement buildInfo;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object list$iv$iv;
        FigureBuildInfo it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Intrinsics.checkNotNullParameter((Object)svgToString, (String)"svgToString");
        Intrinsics.checkNotNullParameter(computationMessagesHandler, (String)"computationMessagesHandler");
        Map<String, Object> plotSpec2 = this.processRawSpecs(plotSpec, false);
        PlotsBuildResult buildResult = MonolithicCommon.buildPlotsFromProcessedSpecs$default(this, plotSpec2, plotSize2, null, null, 12, null);
        if (buildResult.isError()) {
            Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.util.MonolithicCommon.PlotsBuildResult.Error");
            String errorMessage = ((PlotsBuildResult.Error)buildResult).getError();
            throw new RuntimeException(errorMessage);
        }
        Intrinsics.checkNotNull((Object)buildResult, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.util.MonolithicCommon.PlotsBuildResult.Success");
        PlotsBuildResult.Success success2 = (PlotsBuildResult.Success)buildResult;
        Iterable $this$flatMap$iv = success2.getBuildInfos();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FigureBuildInfo)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getComputationMessages();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List computationMessages = (List)destination$iv$iv;
        if (!((Collection)computationMessages).isEmpty()) {
            computationMessagesHandler.invoke((Object)computationMessages);
        }
        Iterable $this$map$iv = success2.getBuildInfos();
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (FigureBuildInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FigureToPlainSvg((FigureBuildInfo)((Object)buildInfo)).eval());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            buildInfo = (SvgSvgElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(svgToString.render((SvgSvgElement)((Object)it)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PlotsBuildResult buildPlotsFromProcessedSpecs(@NotNull Map<String, Object> plotSpec, @Nullable DoubleVector plotSize2, @Nullable Double plotMaxWidth, @Nullable Double plotPreferredWidth) {
        PlotsBuildResult plotsBuildResult;
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        this.throwTestingErrors();
        DoubleVector doubleVector2 = plotSize2;
        if (doubleVector2 != null) {
            DoubleVector it = doubleVector2;
            boolean bl = false;
            doubleVector = new DoubleVector(Math.max(0.0, it.getX()), Math.max(0.0, it.getY()));
        } else {
            doubleVector = null;
        }
        DoubleVector plotSize3 = doubleVector;
        PlotConfig.Companion.assertFigSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            String errorMessage = PlotConfig.Companion.getErrorMessage(plotSpec);
            return new PlotsBuildResult.Error(errorMessage);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind(plotSpec).ordinal()]) {
            case 1: {
                plotsBuildResult = new PlotsBuildResult.Success(CollectionsKt.listOf((Object)this.buildSinglePlotFromProcessedSpecs(plotSpec, plotSize3, plotMaxWidth, plotPreferredWidth)));
                break;
            }
            case 2: {
                plotsBuildResult = new PlotsBuildResult.Success(CollectionsKt.listOf((Object)this.buildCompositeFigureFromProcessedSpecs(plotSpec, plotSize3, plotMaxWidth, plotPreferredWidth)));
                break;
            }
            case 3: {
                plotsBuildResult = this.buildGGBunchFromProcessedSpecs(plotSpec, plotMaxWidth, plotPreferredWidth);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return plotsBuildResult;
    }

    public static /* synthetic */ PlotsBuildResult buildPlotsFromProcessedSpecs$default(MonolithicCommon monolithicCommon, Map map2, DoubleVector doubleVector, Double d, Double d2, int n, Object object) {
        if ((n & 4) != 0) {
            d = null;
        }
        if ((n & 8) != 0) {
            d2 = null;
        }
        return monolithicCommon.buildPlotsFromProcessedSpecs(map2, doubleVector, d, d2);
    }

    private final PlotsBuildResult buildGGBunchFromProcessedSpecs(Map<String, Object> bunchSpec, Double maxWidth, Double preferredWidth) {
        Object object;
        Object scaledSize;
        DoubleVector naturalSize;
        block8: {
            Object object2;
            block7: {
                naturalSize = PlotSizeHelper.INSTANCE.plotBunchSize(bunchSpec);
                object2 = preferredWidth;
                if (object2 == null) break block7;
                double w = ((Number)object2).doubleValue();
                boolean bl = false;
                DoubleVector doubleVector = naturalSize.mul(Math.max(50.0, w) / naturalSize.getX());
                object2 = doubleVector;
                if (doubleVector != null) break block8;
            }
            object2 = scaledSize = naturalSize;
        }
        if (maxWidth != null && maxWidth < ((DoubleVector)scaledSize).getX()) {
            double d = maxWidth;
            object = ((DoubleVector)scaledSize).mul(Math.max(50.0, d) / ((DoubleVector)scaledSize).getX());
        } else {
            object = scaledSize;
        }
        Object neededSize = object;
        double scalingCoef = ((DoubleVector)neededSize).getX() / naturalSize.getX();
        BunchConfig bunchConfig = new BunchConfig(bunchSpec);
        if (bunchConfig.getBunchItems().isEmpty()) {
            return new PlotsBuildResult.Error("No plots in the bunch");
        }
        ArrayList<PlotFigureBuildInfo> buildInfos = new ArrayList<PlotFigureBuildInfo>();
        for (BunchConfig.BunchItem bunchItem : bunchConfig.getBunchItems()) {
            Map<String, Object> map2 = bunchItem.getFeatureSpec();
            Intrinsics.checkNotNull(map2, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            Map plotSpec = TypeIntrinsics.asMutableMap(map2);
            DoubleVector itemSize = PlotSizeHelper.INSTANCE.bunchItemSize$plot_stem(bunchItem);
            DoubleRectangle itemBounds = new DoubleRectangle(new DoubleVector(bunchItem.getX(), bunchItem.getY()).mul(scalingCoef), itemSize.mul(scalingCoef));
            PlotFigureBuildInfo plotFigureBuildInfo = this.buildSinglePlotFromProcessedSpecs(plotSpec, itemSize, null, null).withBounds(itemBounds);
            buildInfos.add(plotFigureBuildInfo);
        }
        return new PlotsBuildResult.Success((List<? extends FigureBuildInfo>)buildInfos);
    }

    private final PlotFigureBuildInfo buildSinglePlotFromProcessedSpecs(Map<String, ? extends Object> plotSpec, DoubleVector plotSize2, Double plotMaxWidth, Double plotPreferredWidth) {
        ArrayList<String> computationMessages = new ArrayList<String>();
        PlotConfigFrontend config2 = PlotConfigFrontend.Companion.create(plotSpec, null, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(computationMessages){
            final /* synthetic */ ArrayList<String> $computationMessages;
            {
                this.$computationMessages = $computationMessages;
                super(1);
            }

            public final void invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$computationMessages.addAll((Collection<String>)it);
            }
        }));
        return this.buildSinglePlot(config2, plotSize2, plotMaxWidth, plotPreferredWidth, null, null, (List<String>)computationMessages);
    }

    private final PlotFigureBuildInfo buildSinglePlot(PlotConfigFrontend config2, DoubleVector plotSize2, Double plotMaxWidth, Double plotPreferredWidth, DoubleSpan sharedContinuousDomainX, DoubleSpan sharedContinuousDomainY, List<String> computationMessages) {
        DoubleVector preferredSize = PlotSizeHelper.INSTANCE.singlePlotSize(config2.toMap(), plotSize2, plotMaxWidth, plotPreferredWidth, config2.getFacets(), config2.getContainsLiveMap());
        PlotAssembler assembler = PlotConfigFrontendUtil.INSTANCE.createPlotAssembler(config2, sharedContinuousDomainX, sharedContinuousDomainY);
        return new PlotFigureBuildInfo(assembler, config2.toMap(), new DoubleRectangle(DoubleVector.Companion.getZERO(), preferredSize), computationMessages);
    }

    private final CompositeFigureBuildInfo buildCompositeFigureFromProcessedSpecs(Map<String, ? extends Object> plotSpec, DoubleVector plotSize2, Double plotMaxWidth, Double plotPreferredWidth) {
        ArrayList<String> computationMessages = new ArrayList<String>();
        CompositeFigureConfig compositeFigureConfig2 = new CompositeFigureConfig(plotSpec, null, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(computationMessages){
            final /* synthetic */ ArrayList<String> $computationMessages;
            {
                this.$computationMessages = $computationMessages;
                super(1);
            }

            public final void invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$computationMessages.addAll((Collection<String>)it);
            }
        }));
        DoubleVector preferredSize = PlotSizeHelper.INSTANCE.compositeFigureSize(compositeFigureConfig2, plotSize2, plotMaxWidth, plotPreferredWidth);
        return this.buildCompositeFigure(compositeFigureConfig2, preferredSize, (List<String>)computationMessages);
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeFigureBuildInfo buildCompositeFigure(CompositeFigureConfig config2, DoubleVector preferredSize, List<String> computationMessages) {
        void $this$mapIndexedTo$iv$iv;
        CompositeFigureLayout compositeFigureLayout = config2.createLayout();
        List sharedXDomains = null;
        List sharedYDomains = null;
        if (compositeFigureLayout instanceof CompositeFigureGridLayoutBase && ((CompositeFigureGridLayoutBase)((Object)compositeFigureLayout)).hasSharedAxis()) {
            Pair<List<DoubleSpan>, List<DoubleSpan>> sharedDomainsXY = FigureGridScaleShareUtil.INSTANCE.getSharedDomains(config2.getElementConfigs(), (CompositeFigureGridLayoutBase)((Object)compositeFigureLayout));
            sharedXDomains = (List)sharedDomainsXY.getFirst();
            sharedYDomains = (List)sharedDomainsXY.getSecond();
        } else {
            sharedXDomains = null;
            sharedYDomains = null;
        }
        Iterable $this$mapIndexed$iv = config2.getElementConfigs();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            FigureBuildInfo figureBuildInfo;
            void element;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OptionsAccessor optionsAccessor = (OptionsAccessor)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (element != null) {
                void it;
                boolean bl2 = false;
                switch (WhenMappings.$EnumSwitchMapping$0[PlotConfig.Companion.figSpecKind((OptionsAccessor)it).ordinal()]) {
                    case 1: {
                        void index;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.spec.front.PlotConfigFrontend");
                        List list2 = sharedXDomains;
                        List list3 = sharedYDomains;
                        figureBuildInfo = INSTANCE.buildSinglePlot((PlotConfigFrontend)it, null, null, null, list2 != null ? (DoubleSpan)list2.get((int)index) : null, list3 != null ? (DoubleSpan)list3.get((int)index) : null, CollectionsKt.emptyList());
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.spec.config.CompositeFigureConfig");
                        figureBuildInfo = INSTANCE.buildCompositeFigure((CompositeFigureConfig)it, DoubleVector.Companion.getZERO(), computationMessages);
                        break;
                    }
                    case 3: {
                        throw new IllegalArgumentException("SubPlots can't contain GGBunch.");
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            } else {
                figureBuildInfo = null;
            }
            collection.add(figureBuildInfo);
        }
        List elements = (List)destination$iv$iv;
        return new CompositeFigureBuildInfo(elements, compositeFigureLayout, new DoubleRectangle(DoubleVector.Companion.getZERO(), preferredSize), config2.getTheme$plot_stem(), computationMessages);
    }

    private final void throwTestingErrors() {
    }

    @NotNull
    public final Map<String, Object> processRawSpecs(@NotNull Map<String, Object> plotSpec, boolean frontendOnly) {
        Map<String, Object> plotSpec2;
        Intrinsics.checkNotNullParameter(plotSpec, (String)"plotSpec");
        Object object = plotSpec.get("kind");
        if (Intrinsics.areEqual((Object)(object != null ? object.toString() : null), (Object)"error_gen")) {
            return SpecTransformBackendUtil.INSTANCE.processTransform$plot_stem(plotSpec, true);
        }
        PlotConfig.Companion.assertFigSpecOrErrorMessage(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec)) {
            return plotSpec;
        }
        Map<String, Object> map2 = plotSpec2 = frontendOnly ? plotSpec : SpecTransformBackendUtil.INSTANCE.processTransform(plotSpec);
        if (PlotConfig.Companion.isFailure(plotSpec2)) {
            return plotSpec2;
        }
        return PlotConfigFrontend.Companion.processTransform(plotSpec2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult;", "", "()V", "isError", "", "()Z", "Error", "Success", "Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult$Error;", "Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult$Success;", "plot-stem"})
    public static abstract class PlotsBuildResult {
        private final boolean isError = this instanceof Error;

        private PlotsBuildResult() {
        }

        public final boolean isError() {
            return this.isError;
        }

        public /* synthetic */ PlotsBuildResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult$Error;", "Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult;", "error", "", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "plot-stem"})
        public static final class Error
        extends PlotsBuildResult {
            @NotNull
            private final String error;

            public Error(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                super(null);
                this.error = error;
            }

            @NotNull
            public final String getError() {
                return this.error;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult$Success;", "Lorg/jetbrains/letsPlot/core/util/MonolithicCommon$PlotsBuildResult;", "buildInfos", "", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;", "(Ljava/util/List;)V", "getBuildInfos", "()Ljava/util/List;", "plot-stem"})
        public static final class Success
        extends PlotsBuildResult {
            @NotNull
            private final List<FigureBuildInfo> buildInfos;

            public Success(@NotNull List<? extends FigureBuildInfo> buildInfos) {
                Intrinsics.checkNotNullParameter(buildInfos, (String)"buildInfos");
                super(null);
                this.buildInfos = buildInfos;
            }

            @NotNull
            public final List<FigureBuildInfo> getBuildInfos() {
                return this.buildInfos;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FigKind.values().length];
            try {
                nArray[FigKind.PLOT_SPEC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.SUBPLOTS_SPEC.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FigKind.GG_BUNCH_SPEC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

