/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.interact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Registration;
import org.jetbrains.letsPlot.core.interact.DrawRectFeedback;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.PanGeomFeedback;
import org.jetbrains.letsPlot.core.interact.ToolFeedback;
import org.jetbrains.letsPlot.core.interact.WheelZoomFeedback;
import org.jetbrains.letsPlot.core.interact.event.ToolEventDispatcher;
import org.jetbrains.letsPlot.core.plot.builder.PlotInteractor;
import org.jetbrains.letsPlot.core.plot.builder.interact.PlotToolEventDispatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u00072\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bH\u0016J$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\"\u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher;", "Lorg/jetbrains/letsPlot/core/interact/event/ToolEventDispatcher;", "plotInteractor", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;", "(Lorg/jetbrains/letsPlot/core/plot/builder/PlotInteractor;)V", "activeInteractionsByOrigin", "", "", "Lorg/jetbrains/letsPlot/commons/registration/Registration;", "activateInteraction", "", "", "", "origin", "interactionSpec", "deactivateInteraction", "interactionName", "deactivateOverlappingInteractions", "activatedInteractionName", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPlotToolEventDispatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotToolEventDispatcher.kt\norg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n372#2,7:94\n76#3:101\n96#3,2:102\n125#3:104\n152#3,3:105\n98#3,3:108\n1549#4:111\n1620#4,3:112\n*S KotlinDebug\n*F\n+ 1 PlotToolEventDispatcher.kt\norg/jetbrains/letsPlot/core/plot/builder/interact/PlotToolEventDispatcher\n*L\n62#1:94,7\n85#1:101\n85#1:102,2\n86#1:104\n86#1:105,3\n85#1:108,3\n89#1:111\n89#1:112,3\n*E\n"})
public final class PlotToolEventDispatcher
implements ToolEventDispatcher {
    @NotNull
    private final PlotInteractor plotInteractor;
    @NotNull
    private final Map<String, Map<String, Registration>> activeInteractionsByOrigin;

    public PlotToolEventDispatcher(@NotNull PlotInteractor plotInteractor) {
        Intrinsics.checkNotNullParameter((Object)plotInteractor, (String)"plotInteractor");
        this.plotInteractor = plotInteractor;
        this.activeInteractionsByOrigin = new HashMap();
    }

    @Override
    @NotNull
    public List<Map<String, Object>> activateInteraction(@NotNull String origin, @NotNull Map<String, ? extends Object> interactionSpec) {
        Map map2;
        ToolFeedback toolFeedback;
        String interactionName;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter(interactionSpec, (String)"interactionSpec");
        ArrayList<Map> responseEvents = new ArrayList<Map>();
        Object object = MapsKt.getValue(interactionSpec, (Object)"name");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        switch (interactionName = (String)object) {
            case "drag-pan": {
                toolFeedback = new PanGeomFeedback((Function2<? super DoubleVector, ? super InteractionTarget, Unit>)((Function2)activateInteraction.feedback.1.INSTANCE));
                break;
            }
            case "box-zoom": {
                toolFeedback = new DrawRectFeedback((Function1<? super Pair<DoubleRectangle, ? extends InteractionTarget>, Unit>)((Function1)activateInteraction.feedback.2.INSTANCE));
                break;
            }
            case "wheel-zoom": {
                toolFeedback = new WheelZoomFeedback((Function2<? super DoubleRectangle, ? super InteractionTarget, Unit>)((Function2)activateInteraction.feedback.3.INSTANCE));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported interaction: " + interactionName);
            }
        }
        ToolFeedback feedback2 = toolFeedback;
        Registration feedbackRegistration = this.plotInteractor.startToolFeedback(feedback2);
        Map<String, Map<String, Registration>> $this$getOrPut$iv = this.activeInteractionsByOrigin;
        boolean $i$f$getOrPut = false;
        Map value$iv = $this$getOrPut$iv.get(origin);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new HashMap();
            $this$getOrPut$iv.put(origin, answer$iv);
            map2 = answer$iv;
        } else {
            map2 = value$iv;
        }
        map2.put((String)interactionName, (Registration)feedbackRegistration);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"interaction_activated"), TuplesKt.to((Object)"origin", (Object)origin), TuplesKt.to((Object)"interaction", (Object)interactionName)};
        responseEvents.add(MapsKt.mapOf((Pair[])pairArray));
        return responseEvents;
    }

    @Override
    @NotNull
    public Map<String, Object> deactivateInteraction(@NotNull String origin, @NotNull String interactionName) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)interactionName, (String)"interactionName");
        Map<String, Registration> map2 = this.activeInteractionsByOrigin.get(origin);
        if (map2 != null && (map2 = map2.remove(interactionName)) != null) {
            ((Registration)((Object)map2)).dispose();
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"interaction_deactivated"), TuplesKt.to((Object)"origin", (Object)origin), TuplesKt.to((Object)"interaction", (Object)interactionName)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, Object>> deactivateOverlappingInteractions(String activatedInteractionName) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Map<String, Map<String, Registration>> $this$flatMap$iv = this.activeInteractionsByOrigin;
        boolean $i$f$flatMap = false;
        Map<String, Map<String, Registration>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map list2;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            String origin = (String)entry.getKey();
            Map $this$map$iv = list2 = (Map)entry.getValue();
            boolean $i$f$map = false;
            Map map3 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator3.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String interaction = (String)entry2.getKey();
                collection.add(new Pair((Object)origin, (Object)interaction));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List originAndIntInteractionList = (List)destination$iv$iv;
        Iterable $this$map$iv = originAndIntInteractionList;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            list$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.deactivateInteraction((String)it.getFirst(), (String)it.getSecond()));
        }
        return (List)destination$iv$iv;
    }
}

