/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.render.linetype.LineType;
import org.jetbrains.letsPlot.core.plot.base.render.svg.PathUtilKt;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.core.plot.base.render.svg.SvgComponent;
import org.jetbrains.letsPlot.core.plot.base.theme.PanelGridTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColors;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BM\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0018H\u0014J4\u0010\u0019\u001a\u00020\u00182\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00032\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J.\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/GridComponent;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/SvgComponent;", "majorGrid", "", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "minorGrid", "axisInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;", "gridTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;", "isOrthogonal", "", "geomContentBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutInfo;Lorg/jetbrains/letsPlot/core/plot/base/theme/PanelGridTheme;ZLorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "container", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "end", "", "geomContentLocalBounds", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "start", "buildComponent", "", "buildGrid", "grid", "lineWidth", "lineColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "lineType", "Lorg/jetbrains/letsPlot/core/plot/base/render/linetype/LineType;", "buildGridLine", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "lineString", "width", "color", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nGridComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/GridComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1549#2:101\n1620#2,3:102\n766#2:105\n857#2:106\n1747#2,3:107\n858#2:110\n1549#2:111\n1620#2,3:112\n*S KotlinDebug\n*F\n+ 1 GridComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/GridComponent\n*L\n65#1:101\n65#1:102,3\n71#1:105\n71#1:106\n71#1:107,3\n71#1:110\n77#1:111\n77#1:112,3\n*E\n"})
public final class GridComponent
extends SvgComponent {
    @NotNull
    private final List<List<DoubleVector>> majorGrid;
    @NotNull
    private final List<List<DoubleVector>> minorGrid;
    @NotNull
    private final PanelGridTheme gridTheme;
    private final boolean isOrthogonal;
    @NotNull
    private final DoubleRectangle geomContentBounds;
    @NotNull
    private final SvgGElement container;
    @NotNull
    private final Orientation orientation;
    private final double start;
    private final double end;
    @NotNull
    private final DoubleRectangle geomContentLocalBounds;

    public GridComponent(@NotNull List<? extends List<DoubleVector>> majorGrid, @NotNull List<? extends List<DoubleVector>> minorGrid, @NotNull AxisLayoutInfo axisInfo, @NotNull PanelGridTheme gridTheme, boolean isOrthogonal, @NotNull DoubleRectangle geomContentBounds) {
        Intrinsics.checkNotNullParameter(majorGrid, (String)"majorGrid");
        Intrinsics.checkNotNullParameter(minorGrid, (String)"minorGrid");
        Intrinsics.checkNotNullParameter((Object)axisInfo, (String)"axisInfo");
        Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
        Intrinsics.checkNotNullParameter((Object)geomContentBounds, (String)"geomContentBounds");
        this.majorGrid = majorGrid;
        this.minorGrid = minorGrid;
        this.gridTheme = gridTheme;
        this.isOrthogonal = isOrthogonal;
        this.geomContentBounds = geomContentBounds;
        this.container = new SvgGElement();
        this.orientation = axisInfo.getOrientation();
        this.end = this.orientation.isHorizontal() ? this.geomContentBounds.getHeight() : this.geomContentBounds.getWidth();
        this.geomContentLocalBounds = this.geomContentBounds.subtract(this.geomContentBounds.getOrigin());
    }

    @Override
    protected void buildComponent() {
        this.getRootGroup().children().add(this.container);
        if (this.gridTheme.showMinor()) {
            this.buildGrid(this.minorGrid, this.gridTheme.minorLineWidth(), this.gridTheme.minorLineColor(), this.gridTheme.minorLineType());
        }
        if (this.gridTheme.showMajor()) {
            this.buildGrid(this.majorGrid, this.gridTheme.majorLineWidth(), this.gridTheme.majorLineColor(), this.gridTheme.majorLineType());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildGrid(List<? extends List<DoubleVector>> grid2, double lineWidth, Color lineColor, LineType lineType2) {
        void $this$mapTo$iv$iv;
        List list2;
        Iterable iterable;
        Iterable destination$iv$iv;
        if (this.isOrthogonal) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            Iterable iterable2 = grid2;
            boolean $i$f$map = false;
            void var9_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                List list3;
                Object object;
                List list4 = (List)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl = false;
                DoubleVector p = (DoubleVector)list4.get(0);
                boolean bl2 = this.orientation.isHorizontal();
                if (bl2) {
                    object = new DoubleVector[]{new DoubleVector(p.getX(), this.start), new DoubleVector(p.getX(), this.end)};
                    list3 = CollectionsKt.listOf((Object[])object);
                } else if (!bl2) {
                    object = new DoubleVector[]{new DoubleVector(this.start, p.getY()), new DoubleVector(this.end, p.getY())};
                    list3 = CollectionsKt.listOf((Object[])object);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                iterable.add(list3);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block12: {
                    List line2 = (List)element$iv$iv;
                    boolean bl3 = false;
                    Iterable $this$any$iv = line2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DoubleVector p = (DoubleVector)element$iv;
                            boolean bl4 = false;
                            if (!this.geomContentLocalBounds.contains(p)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = grid2;
        }
        List visibleGridLines = list2;
        Iterable $this$map$iv = visibleGridLines;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List bl3 = (List)item$iv$iv;
            iterable = destination$iv$iv2;
            boolean bl = false;
            iterable.add(this.buildGridLine((List<DoubleVector>)it, lineWidth, lineColor, lineType2));
        }
        List elems = (List)destination$iv$iv2;
        this.container.children().addAll(elems);
    }

    private final SvgNode buildGridLine(List<DoubleVector> lineString, double width2, Color color, LineType lineType2) {
        SvgShape shapeElem = lineString.size() == 2 ? (SvgShape)new SvgLineElement(lineString.get(0).getX(), lineString.get(0).getY(), lineString.get(1).getX(), lineString.get(1).getY()) : (lineString.size() > 2 ? (SvgShape)new SvgPathElement(PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), lineString).build()) : (SvgShape)new SvgPathElement());
        shapeElem.strokeColor().set(color);
        shapeElem.strokeWidth().set(width2);
        StrokeDashArraySupport.INSTANCE.apply(shapeElem, width2, lineType2);
        shapeElem.fill().set(SvgColors.NONE);
        return (SvgNode)((Object)shapeElem);
    }
}

