/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapper;
import org.jetbrains.letsPlot.core.plot.base.coord.Coords;
import org.jetbrains.letsPlot.core.plot.base.scale.Mappers;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;
import org.jetbrains.letsPlot.core.plot.builder.coord.PolarCoordinateSystem;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B_\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0017H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0015H\u0016J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bJ@\u0010%\u001a\u00020&2\u0016\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "xLim", "Lkotlin/Pair;", "", "yLim", "flipped", "", "start", "clockwise", "transformBkgr", "isHScaleContinuous", "(Lkotlin/Pair;Lkotlin/Pair;ZDZZZ)V", "getClockwise", "()Z", "isLinear", "isPolar", "getStart", "()D", "getTransformBkgr", "adjustGeomSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "hDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "vDomain", "geomSize", "adjustXYDomains", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "xRange", "yRange", "createCoordinateMapper", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "clientSize", "createCoordinateSystem", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "gridDomain", "with", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "withHScaleContinuous", "b", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nPolarCoordProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarCoordProvider.kt\norg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class PolarCoordProvider
extends CoordProviderBase {
    private final double start;
    private final boolean clockwise;
    private final boolean transformBkgr;
    private final boolean isHScaleContinuous;
    private final boolean isLinear;
    private final boolean isPolar;

    public PolarCoordProvider(@NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean flipped, double start2, boolean clockwise, boolean transformBkgr, boolean isHScaleContinuous) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        super(xLim, yLim, flipped, null, 8, null);
        this.start = start2;
        this.clockwise = clockwise;
        this.transformBkgr = transformBkgr;
        this.isHScaleContinuous = isHScaleContinuous;
        this.isPolar = true;
    }

    public /* synthetic */ PolarCoordProvider(Pair pair2, Pair pair3, boolean bl, double d, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl4 = true;
        }
        this((Pair<Double, Double>)pair2, (Pair<Double, Double>)pair3, bl, d, bl2, bl3, bl4);
    }

    public final double getStart() {
        return this.start;
    }

    public final boolean getClockwise() {
        return this.clockwise;
    }

    public final boolean getTransformBkgr() {
        return this.transformBkgr;
    }

    public final boolean isHScaleContinuous() {
        return this.isHScaleContinuous;
    }

    @Override
    public boolean isLinear() {
        return this.isLinear;
    }

    @Override
    public boolean isPolar() {
        return this.isPolar;
    }

    @Override
    @NotNull
    public CoordProvider with(@NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean flipped) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        return new PolarCoordProvider(xLim, yLim, flipped, this.start, this.clockwise, this.transformBkgr, false, 64, null);
    }

    @NotNull
    public final PolarCoordProvider withHScaleContinuous(boolean b2) {
        return new PolarCoordProvider(this.getXLim(), this.getYLim(), this.getFlipped(), this.start, this.clockwise, this.transformBkgr, b2);
    }

    @Override
    @NotNull
    protected DoubleRectangle adjustXYDomains(@NotNull DoubleSpan xRange, @NotNull DoubleSpan yRange) {
        Intrinsics.checkNotNullParameter((Object)xRange, (String)"xRange");
        Intrinsics.checkNotNullParameter((Object)yRange, (String)"yRange");
        DoubleRectangle domain = new DoubleRectangle(xRange, yRange);
        DoubleRectangle realDomain = domain.flipIf(this.getFlipped());
        DoubleSpan it = realDomain.xRange();
        boolean bl = false;
        double upperExpand = this.isHScaleContinuous ? 0.0 : 1.0;
        DoubleSpan adjustedXRange = DoubleSpan.Companion.withLowerEnd(it.getLowerEnd(), it.getLength() + upperExpand);
        DoubleSpan it2 = realDomain.yRange();
        boolean bl2 = false;
        DoubleSpan adjustedYRange = DoubleSpan.Companion.withLowerEnd(it2.getLowerEnd(), it2.getLength() * 1.21);
        return new DoubleRectangle(adjustedXRange, adjustedYRange);
    }

    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        double it = Math.min(geomSize.getX(), geomSize.getY());
        boolean bl = false;
        return new DoubleVector(it, it);
    }

    @Override
    @NotNull
    public CoordinatesMapper createCoordinateMapper(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        DoubleVector normOffset = DoubleVector.Companion.getZERO().subtract(adjustedDomain.getOrigin());
        DoubleRectangle normDomain = new DoubleRectangle(DoubleVector.Companion.getZERO(), adjustedDomain.getDimension());
        ScaleMapper<Double> thetaScaleMapper = Mappers.INSTANCE.mul(normDomain.xRange(), Math.PI * 2);
        ScaleMapper<Double> rScaleMapper = Mappers.INSTANCE.mul(normDomain.yRange(), Math.min(clientSize.getX(), clientSize.getY()) / 2.0);
        double sign = this.clockwise ? -1.0 : 1.0;
        double startAngle = 1.5707963267948966 + sign * this.start;
        DoubleVector center = clientSize.mul(0.5);
        Projection polarProjection2 = new Projection(this, normOffset, thetaScaleMapper, rScaleMapper, sign, startAngle, center){
            private final boolean nonlinear;
            final /* synthetic */ PolarCoordProvider this$0;
            final /* synthetic */ DoubleVector $normOffset;
            final /* synthetic */ ScaleMapper<Double> $thetaScaleMapper;
            final /* synthetic */ ScaleMapper<Double> $rScaleMapper;
            final /* synthetic */ double $sign;
            final /* synthetic */ double $startAngle;
            final /* synthetic */ DoubleVector $center;
            {
                this.this$0 = $receiver;
                this.$normOffset = $normOffset;
                this.$thetaScaleMapper = $thetaScaleMapper;
                this.$rScaleMapper = $rScaleMapper;
                this.$sign = $sign;
                this.$startAngle = $startAngle;
                this.$center = $center;
                this.nonlinear = true;
            }

            public boolean getNonlinear() {
                return this.nonlinear;
            }

            @NotNull
            public DoubleVector project(@NotNull DoubleVector v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                DoubleVector normV = v.flipIf(this.this$0.getFlipped()).add(this.$normOffset);
                Double d = this.$thetaScaleMapper.invoke(normV.getX());
                if (d == null) {
                    throw new IllegalStateException("Unexpected: theta is null".toString());
                }
                double theta = d;
                Double d2 = this.$rScaleMapper.invoke(normV.getY());
                if (d2 == null) {
                    throw new IllegalStateException("Unexpected: r is null".toString());
                }
                double r = d2;
                double x2 = r * Math.cos(this.$sign * theta + this.$startAngle);
                double y2 = r * Math.sin(this.$sign * theta + this.$startAngle);
                return this.$center.add(new DoubleVector(x2, y2));
            }

            @NotNull
            public DoubleVector invert(@NotNull DoubleVector v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            @NotNull
            public DoubleRectangle validDomain() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public boolean getCylindrical() {
                return Projection.DefaultImpls.getCylindrical(this);
            }
        };
        DoubleRectangle clientBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), clientSize);
        return new CoordinatesMapper(Mappers.INSTANCE.getIDENTITY(), Mappers.INSTANCE.getIDENTITY(), Mappers.INSTANCE.getIDENTITY(), Mappers.INSTANCE.getIDENTITY(), clientBounds, polarProjection2, false);
    }

    @Override
    @NotNull
    public PolarCoordinateSystem createCoordinateSystem(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        double sign = this.clockwise ? -1.0 : 1.0;
        CoordinatesMapper coordMapper = this.createCoordinateMapper(adjustedDomain, clientSize);
        return new PolarCoordinateSystem(Coords.INSTANCE.create(coordMapper), this.start, sign, this.transformBkgr);
    }

    @NotNull
    public final DoubleRectangle gridDomain(@NotNull DoubleRectangle adjustedDomain) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        DoubleSpan xRange = adjustedDomain.xRange();
        DoubleSpan it = adjustedDomain.yRange();
        boolean bl = false;
        DoubleSpan yRange = DoubleSpan.Companion.withLowerEnd(it.getLowerEnd(), it.getLength() / 1.15);
        return new DoubleRectangle(xRange, yRange);
    }
}

