/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.formatting.number.NumberFormat;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0001R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/NumericBreakFormatter;", "", "value", "", "step", "allowMetricPrefix", "", "superscriptExponent", "(DDZZ)V", "formatter", "Lorg/jetbrains/letsPlot/commons/formatting/number/NumberFormat;", "apply", "", "plot-base"})
public final class NumericBreakFormatter {
    @NotNull
    private NumberFormat formatter;

    public NumericBreakFormatter(double value, double step2, boolean allowMetricPrefix, boolean superscriptExponent) {
        double value2 = value == 0.0 ? 4.9E-323 : Math.abs(value);
        double step3 = step2 == 0.0 ? value2 / (double)10 : Math.abs(step2);
        String type = "f";
        String delimiter = "";
        double domain10Power = Math.log10(Math.abs(value2));
        double step10Power = Math.log10(step3);
        double precision = -step10Power;
        boolean scientificNotation = false;
        if (domain10Power < 0.0 && step10Power < -4.0) {
            scientificNotation = true;
            type = "e";
            precision = domain10Power - step10Power;
        } else if (domain10Power > 7.0 && step10Power > 2.0) {
            scientificNotation = true;
            precision = domain10Power - step10Power;
        }
        if (precision < 0.0) {
            precision = 0.0;
            type = "d";
        }
        precision = Math.ceil(precision - 0.001);
        if (scientificNotation) {
            type = domain10Power > 0.0 && allowMetricPrefix && !superscriptExponent ? "s" : "e";
        } else {
            delimiter = ",";
        }
        String richOutput = Intrinsics.areEqual((Object)type, (Object)"e") && superscriptExponent ? "&" : "";
        String trim = Intrinsics.areEqual((Object)type, (Object)"e") && superscriptExponent ? "~" : "";
        this.formatter = new NumberFormat(delimiter + '.' + (int)precision + trim + type + richOutput);
    }

    @NotNull
    public final String apply(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.formatter.apply((Number)value);
    }
}

