/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.MouseWheelInteraction;
import org.jetbrains.letsPlot.core.interact.ToolFeedback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/interact/WheelZoomFeedback;", "Lorg/jetbrains/letsPlot/core/interact/ToolFeedback;", "onZoomed", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "", "(Lkotlin/jvm/functions/Function2;)V", "scaleRect", "rect", "factor", "", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "start", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "plot-base"})
public final class WheelZoomFeedback
implements ToolFeedback {
    @NotNull
    private final Function2<DoubleRectangle, InteractionTarget, Unit> onZoomed;

    public WheelZoomFeedback(@NotNull Function2<? super DoubleRectangle, ? super InteractionTarget, Unit> onZoomed) {
        Intrinsics.checkNotNullParameter(onZoomed, (String)"onZoomed");
        this.onZoomed = onZoomed;
    }

    @NotNull
    public final Disposable start(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        MouseWheelInteraction interaction = new MouseWheelInteraction(ctx2);
        interaction.loop((Function1<? super MouseWheelInteraction, Unit>)((Function1)new Function1<MouseWheelInteraction, Unit>(this){
            final /* synthetic */ WheelZoomFeedback this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseWheelInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                double zoomStep = 1.05;
                double factor = Math.signum(it.getZoomDelta()) == -1.0 ? 1.0 / zoomStep : zoomStep;
                DoubleRectangle viewport = WheelZoomFeedback.access$scaleRect(this.this$0, it.getTarget().getGeomBounds(), factor, it.getZoomOrigin());
                it.getTarget().zoom(viewport);
                WheelZoomFeedback.access$getOnZoomed$p(this.this$0).invoke((Object)viewport, (Object)it.getTarget());
            }
        }));
        return new Disposable(interaction){
            final /* synthetic */ MouseWheelInteraction $interaction;
            {
                this.$interaction = $interaction;
            }

            public void dispose() {
                System.out.println((Object)"WheelZoomFeedback dispose.");
                this.$interaction.dispose();
            }
        };
    }

    private final DoubleRectangle scaleRect(DoubleRectangle rect2, double factor, DoubleVector origin) {
        DoubleVector newDim = rect2.getDimension().mul(factor);
        DoubleVector originOffset = origin.subtract(rect2.getOrigin());
        DoubleVector newOrigin = rect2.getOrigin().add(originOffset.mul(1.0 - factor));
        return new DoubleRectangle(newOrigin, newDim);
    }

    public static final /* synthetic */ DoubleRectangle access$scaleRect(WheelZoomFeedback $this, DoubleRectangle rect2, double factor, DoubleVector origin) {
        return $this.scaleRect(rect2, factor, origin);
    }

    public static final /* synthetic */ Function2 access$getOnZoomed$p(WheelZoomFeedback $this) {
        return $this.onZoomed;
    }
}

