/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.registration.Disposable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.interact.DragFeedback;
import org.jetbrains.letsPlot.core.interact.InteractionContext;
import org.jetbrains.letsPlot.core.interact.InteractionTarget;
import org.jetbrains.letsPlot.core.interact.MouseDragInteraction;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0002\u0010\bJ \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R&\u0010\u0002\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback;", "Lorg/jetbrains/letsPlot/core/interact/DragFeedback;", "onCompleted", "Lkotlin/Function1;", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Lorg/jetbrains/letsPlot/core/interact/InteractionTarget;", "", "(Lkotlin/jvm/functions/Function1;)V", "rect", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgRectElement;", "viewportSvg", "drawRects", "dragFrom", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "dragTo", "geomBounds", "r", "start", "Lorg/jetbrains/letsPlot/commons/registration/Disposable;", "ctx", "Lorg/jetbrains/letsPlot/core/interact/InteractionContext;", "Companion", "plot-base"})
public final class DrawRectFeedback
implements DragFeedback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Pair<DoubleRectangle, ? extends InteractionTarget>, Unit> onCompleted;
    @NotNull
    private final SvgRectElement rect;
    @NotNull
    private final SvgRectElement viewportSvg;

    /*
     * WARNING - void declaration
     */
    public DrawRectFeedback(@NotNull Function1<? super Pair<DoubleRectangle, ? extends InteractionTarget>, Unit> onCompleted) {
        void $this$viewportSvg_u24lambda_u241;
        SvgRectElement $this$rect_u24lambda_u240;
        SvgRectElement svgRectElement;
        Intrinsics.checkNotNullParameter(onCompleted, (String)"onCompleted");
        this.onCompleted = onCompleted;
        SvgRectElement svgRectElement2 = svgRectElement = new SvgRectElement();
        DrawRectFeedback drawRectFeedback = this;
        boolean bl = false;
        $this$rect_u24lambda_u240.strokeColor().set(Color.Companion.getGRAY());
        $this$rect_u24lambda_u240.fillColor().set(Color.Companion.getTRANSPARENT());
        $this$rect_u24lambda_u240.strokeWidth().set(2.0);
        $this$rect_u24lambda_u240.x().set(0.0);
        $this$rect_u24lambda_u240.y().set(0.0);
        $this$rect_u24lambda_u240.width().set(0.0);
        $this$rect_u24lambda_u240.height().set(0.0);
        drawRectFeedback.rect = svgRectElement;
        $this$rect_u24lambda_u240 = svgRectElement = new SvgRectElement();
        drawRectFeedback = this;
        boolean bl2 = false;
        $this$viewportSvg_u24lambda_u241.strokeColor().set(Color.Companion.getBLACK());
        $this$viewportSvg_u24lambda_u241.fillColor().set(Color.Companion.getLIGHT_BLUE());
        $this$viewportSvg_u24lambda_u241.strokeWidth().set(0.0);
        $this$viewportSvg_u24lambda_u241.opacity().set(0.5);
        $this$viewportSvg_u24lambda_u241.x().set(0.0);
        $this$viewportSvg_u24lambda_u241.y().set(0.0);
        $this$viewportSvg_u24lambda_u241.width().set(0.0);
        $this$viewportSvg_u24lambda_u241.height().set(0.0);
        drawRectFeedback.viewportSvg = svgRectElement;
    }

    private final void drawRects(SvgRectElement r, DoubleRectangle rect2) {
        r.x().set(rect2.getLeft());
        r.y().set(rect2.getTop());
        r.width().set(rect2.getWidth());
        r.height().set(rect2.getHeight());
    }

    @Override
    @NotNull
    public Disposable start(@NotNull InteractionContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        SvgNode decorationsLayer = ctx2.getDecorationsLayer();
        MouseDragInteraction interaction = new MouseDragInteraction(ctx2);
        interaction.loop((Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(this, decorationsLayer){
            final /* synthetic */ DrawRectFeedback this$0;
            final /* synthetic */ SvgNode $decorationsLayer;
            {
                this.this$0 = $receiver;
                this.$decorationsLayer = $decorationsLayer;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                System.out.println((Object)"DrawRectFeedback start.");
                DrawRectFeedback.access$drawRects(this.this$0, it.getDragFrom(), it.getDragTo(), it.getTarget().getGeomBounds());
                this.$decorationsLayer.children().add(DrawRectFeedback.access$getRect$p(this.this$0));
                this.$decorationsLayer.children().add(DrawRectFeedback.access$getViewportSvg$p(this.this$0));
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(this){
            final /* synthetic */ DrawRectFeedback this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                System.out.println((Object)"DrawRectFeedback drag.");
                DrawRectFeedback.access$drawRects(this.this$0, it.getDragFrom(), it.getDragTo(), it.getTarget().getGeomBounds());
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(decorationsLayer, this){
            final /* synthetic */ SvgNode $decorationsLayer;
            final /* synthetic */ DrawRectFeedback this$0;
            {
                this.$decorationsLayer = $decorationsLayer;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                System.out.println((Object)"DrawRectFeedback complete.");
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getRect$p(this.this$0));
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getViewportSvg$p(this.this$0));
                DoubleRectangle r = org.jetbrains.letsPlot.core.interact.DrawRectFeedback$Companion.access$calcUserRect(DrawRectFeedback.Companion, it.getDragFrom(), it.getDragTo(), it.getTarget().getGeomBounds());
                InteractionTarget target = it.getTarget();
                it.reset();
                DrawRectFeedback.access$getOnCompleted$p(this.this$0).invoke((Object)TuplesKt.to((Object)r, (Object)target));
            }
        }), (Function1<? super MouseDragInteraction, Unit>)((Function1)new Function1<MouseDragInteraction, Unit>(decorationsLayer, this){
            final /* synthetic */ SvgNode $decorationsLayer;
            final /* synthetic */ DrawRectFeedback this$0;
            {
                this.$decorationsLayer = $decorationsLayer;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MouseDragInteraction it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                System.out.println((Object)"DrawRectFeedback abort.");
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getRect$p(this.this$0));
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getViewportSvg$p(this.this$0));
                it.reset();
            }
        }));
        return new Disposable(decorationsLayer, this, interaction){
            final /* synthetic */ SvgNode $decorationsLayer;
            final /* synthetic */ DrawRectFeedback this$0;
            final /* synthetic */ MouseDragInteraction $interaction;
            {
                this.$decorationsLayer = $decorationsLayer;
                this.this$0 = $receiver;
                this.$interaction = $interaction;
            }

            public void dispose() {
                System.out.println((Object)"DrawRectFeedback dispose.");
                this.$decorationsLayer.children().remove(DrawRectFeedback.access$getRect$p(this.this$0));
                this.$interaction.dispose();
            }
        };
    }

    private final void drawRects(DoubleVector dragFrom, DoubleVector dragTo, DoubleRectangle geomBounds) {
        this.drawRects(this.rect, DrawRectFeedback.Companion.calcUserRect(dragFrom, dragTo, geomBounds));
        this.drawRects(this.viewportSvg, DrawRectFeedback.Companion.calcViewportRect(dragFrom, dragTo, geomBounds));
    }

    public static final /* synthetic */ void access$drawRects(DrawRectFeedback $this, DoubleVector dragFrom, DoubleVector dragTo, DoubleRectangle geomBounds) {
        $this.drawRects(dragFrom, dragTo, geomBounds);
    }

    public static final /* synthetic */ SvgRectElement access$getRect$p(DrawRectFeedback $this) {
        return $this.rect;
    }

    public static final /* synthetic */ SvgRectElement access$getViewportSvg$p(DrawRectFeedback $this) {
        return $this.viewportSvg;
    }

    public static final /* synthetic */ Function1 access$getOnCompleted$p(DrawRectFeedback $this) {
        return $this.onCompleted;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/letsPlot/core/interact/DrawRectFeedback$Companion;", "", "()V", "calcUserRect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "dragFrom", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "dragTo", "geomBounds", "calcViewportRect", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final DoubleRectangle calcUserRect(DoubleVector dragFrom, DoubleVector dragTo, DoubleRectangle geomBounds) {
            double left = Math.min(dragFrom.getX(), dragTo.getX());
            double top = Math.min(dragFrom.getY(), dragTo.getY());
            DoubleRectangle r = new DoubleRectangle(left, top, Math.max(dragFrom.getX(), dragTo.getX()) - left, Math.max(dragFrom.getY(), dragTo.getY()) - top);
            DoubleRectangle doubleRectangle = geomBounds.intersect(r);
            Intrinsics.checkNotNull((Object)doubleRectangle);
            return doubleRectangle;
        }

        private final DoubleRectangle calcViewportRect(DoubleVector dragFrom, DoubleVector dragTo, DoubleRectangle geomBounds) {
            DoubleRectangle userRect = this.calcUserRect(dragFrom, dragTo, geomBounds);
            return userRect.shrinkToAspectRatio(geomBounds.getDimension());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

