/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.awt.canvas;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.canvas.AwtContext2d;
import org.jetbrains.letsPlot.commons.geometry.Vector;
import org.jetbrains.letsPlot.commons.intern.async.Async;
import org.jetbrains.letsPlot.commons.intern.async.Asyncs;
import org.jetbrains.letsPlot.core.canvas.Canvas;
import org.jetbrains.letsPlot.core.canvas.Context2d;
import org.jetbrains.letsPlot.core.canvas.ScaledCanvas;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas;", "Lorg/jetbrains/letsPlot/core/canvas/ScaledCanvas;", "image", "Ljava/awt/image/BufferedImage;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "pixelRatio", "", "(Ljava/awt/image/BufferedImage;Lorg/jetbrains/letsPlot/commons/geometry/Vector;D)V", "getImage", "()Ljava/awt/image/BufferedImage;", "immidiateSnapshot", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "takeSnapshot", "Lorg/jetbrains/letsPlot/commons/intern/async/Async;", "AwtSnapshot", "Companion", "platf-awt"})
public final class AwtCanvas
extends ScaledCanvas {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedImage image;

    private AwtCanvas(BufferedImage image, Vector size2, double pixelRatio) {
        Graphics2D graphics2D = image.createGraphics();
        Intrinsics.checkNotNull((Object)graphics2D, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        super((Context2d)new AwtContext2d(graphics2D), size2, pixelRatio);
        this.image = image;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    @NotNull
    public Async<Canvas.Snapshot> takeSnapshot() {
        return Asyncs.INSTANCE.constant(new AwtSnapshot(this.image));
    }

    @NotNull
    public Canvas.Snapshot immidiateSnapshot() {
        return new AwtSnapshot(this.image);
    }

    public /* synthetic */ AwtCanvas(BufferedImage image, Vector size2, double pixelRatio, DefaultConstructorMarker $constructor_marker) {
        this(image, size2, pixelRatio);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\b\u0010\b\u001a\u00020\u0000H\u0016J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$AwtSnapshot;", "Lorg/jetbrains/letsPlot/core/canvas/Canvas$Snapshot;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "platf-awt"})
    public static final class AwtSnapshot
    implements Canvas.Snapshot {
        @NotNull
        private final BufferedImage image;

        public AwtSnapshot(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.image = image;
        }

        @NotNull
        public final BufferedImage getImage() {
            return this.image;
        }

        @NotNull
        public AwtSnapshot copy() {
            BufferedImage b2 = new BufferedImage(this.image.getWidth(), this.image.getHeight(), this.image.getType());
            Graphics2D graphics2D = b2.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g = graphics2D;
            g.drawImage((Image)this.image, 0, 0, null);
            g.dispose();
            return new AwtSnapshot(b2);
        }

        @NotNull
        public final BufferedImage component1() {
            return this.image;
        }

        @NotNull
        public final AwtSnapshot copy(@NotNull BufferedImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new AwtSnapshot(image);
        }

        public static /* synthetic */ AwtSnapshot copy$default(AwtSnapshot awtSnapshot, BufferedImage bufferedImage, int n, Object object) {
            if ((n & 1) != 0) {
                bufferedImage = awtSnapshot.image;
            }
            return awtSnapshot.copy(bufferedImage);
        }

        @NotNull
        public String toString() {
            return "AwtSnapshot(image=" + this.image + ')';
        }

        public int hashCode() {
            return this.image.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AwtSnapshot)) {
                return false;
            }
            AwtSnapshot awtSnapshot = (AwtSnapshot)other;
            return Intrinsics.areEqual((Object)this.image, (Object)awtSnapshot.image);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/awt/canvas/AwtCanvas$Companion;", "", "()V", "create", "Lorg/jetbrains/letsPlot/core/canvas/Canvas;", "size", "Lorg/jetbrains/letsPlot/commons/geometry/Vector;", "pixelRatio", "", "platf-awt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Canvas create(@NotNull Vector size2, double pixelRatio) {
            Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
            Vector s = Intrinsics.areEqual((Object)size2, (Object)Vector.Companion.getZERO()) ? new Vector(1, 1) : size2;
            return (Canvas)new AwtCanvas(new BufferedImage(s.getX(), s.getY(), 6), s, pixelRatio, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

