/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.dataframe.columns;

import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.LongType;
import com.intellij.bigdatatools.visualization.dataframe.columns.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0011\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020 H\u0096\u0002R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/intellij/bigdatatools/visualization/dataframe/columns/LongColumn;", "Lcom/intellij/bigdatatools/visualization/dataframe/columns/Column;", "", "name", "", "data", "", "(Ljava/lang/String;Ljava/util/List;)V", "isNumerical", "", "()Z", "lazyRange", "Lkotlin/ranges/ClosedRange;", "", "range", "getRange", "()Lkotlin/ranges/ClosedRange;", "type", "Lcom/intellij/bigdatatools/visualization/dataframe/columns/Type;", "getType", "()Lcom/intellij/bigdatatools/visualization/dataframe/columns/Type;", "getComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "descendant", "getDouble", "index", "(I)Ljava/lang/Double;", "isNotNull", "isNull", "iterator", "", "intellij.charts"})
public final class LongColumn
extends Column<Long> {
    private final boolean isNumerical;
    @Nullable
    private ClosedRange<Double> lazyRange;

    public LongColumn(@NotNull String name, @NotNull List<Long> data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        super(name, data);
        this.isNumerical = true;
    }

    @Override
    @NotNull
    public Type<Long> getType() {
        return LongType.INSTANCE;
    }

    @Override
    public boolean isNumerical() {
        return this.isNumerical;
    }

    @Override
    public boolean isNotNull(int index) {
        return this.getData().get(index) != null;
    }

    @Override
    public boolean isNull(int index) {
        return this.getData().get(index) == null;
    }

    @Override
    @Nullable
    public Double getDouble(int index) {
        Long l = (Long)this.getData().get(index);
        return l != null ? Double.valueOf(l.longValue()) : null;
    }

    @Override
    @NotNull
    public Comparator<Integer> getComparator(boolean descendant) {
        return descendant ? (arg_0, arg_1) -> LongColumn.getComparator$lambda$0(this, arg_0, arg_1) : (arg_0, arg_1) -> LongColumn.getComparator$lambda$1(this, arg_0, arg_1);
    }

    @Override
    @NotNull
    public ClosedRange<Double> getRange() {
        if (this.lazyRange != null) {
            ClosedRange<Double> closedRange = this.lazyRange;
            Intrinsics.checkNotNull(closedRange);
            return closedRange;
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        int n = this.getData().size();
        for (int i = 0; i < n; ++i) {
            Long value = (Long)this.getData().get(i);
            if (value == null) continue;
            if (min > value) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        this.lazyRange = (ClosedRange)RangesKt.rangeTo((double)min, (double)max);
        ClosedRange<Double> closedRange = this.lazyRange;
        Intrinsics.checkNotNull(closedRange);
        return closedRange;
    }

    @Override
    @NotNull
    public Iterator<Long> iterator() {
        return this.getData().iterator();
    }

    private static final int getComparator$lambda$0(LongColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)i2);
        Long l = (Long)this$0.get(i2);
        long l2 = l != null ? l : Long.MIN_VALUE;
        Intrinsics.checkNotNull((Object)i1);
        Long l3 = (Long)this$0.get(i1);
        return Intrinsics.compare((long)l2, (long)(l3 != null ? l3 : Long.MIN_VALUE));
    }

    private static final int getComparator$lambda$1(LongColumn this$0, Integer i1, Integer i2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)i1);
        Long l = (Long)this$0.get(i1);
        long l2 = l != null ? l : Long.MIN_VALUE;
        Intrinsics.checkNotNull((Object)i2);
        Long l3 = (Long)this$0.get(i2);
        return Intrinsics.compare((long)l2, (long)(l3 != null ? l3 : Long.MIN_VALUE));
    }
}

