/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.dataframe.columns;

import com.intellij.bigdatatools.visualization.dataframe.columns.Type;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u0001J\u0018\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001e\u001a\u00020\u0015H\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u00150!j\b\u0012\u0004\u0012\u00020\u0015`\"2\u0006\u0010#\u001a\u00020\u000bH&J\u0017\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u0015H&\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0015H&J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0015H&J\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006R\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/intellij/bigdatatools/visualization/dataframe/columns/Column;", "T", "", "name", "", "data", "", "(Ljava/lang/String;Ljava/util/List;)V", "getData", "()Ljava/util/List;", "isNumerical", "", "()Z", "getName", "()Ljava/lang/String;", "range", "Lkotlin/ranges/ClosedRange;", "", "getRange", "()Lkotlin/ranges/ClosedRange;", "size", "", "getSize", "()I", "type", "Lcom/intellij/bigdatatools/visualization/dataframe/columns/Type;", "getType", "()Lcom/intellij/bigdatatools/visualization/dataframe/columns/Type;", "cast", "get", "index", "(I)Ljava/lang/Object;", "getComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "descendant", "getDouble", "(I)Ljava/lang/Double;", "isNotNull", "isNull", "toList", "intellij.charts"})
public abstract class Column<T>
implements Iterable<T>,
KMappedMarker {
    @NotNull
    private final String name;
    @NotNull
    private final List<T> data;
    private final int size;
    private final boolean isNumerical;

    public Column(@NotNull String name, @NotNull List<? extends T> data) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.name = name;
        this.data = data;
        this.size = this.data.size();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected final List<T> getData() {
        return this.data;
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public abstract Type<T> getType();

    public boolean isNumerical() {
        return this.isNumerical;
    }

    @NotNull
    public final List<T> toList() {
        return this.data;
    }

    @Nullable
    public final T get(int index) {
        return this.data.get(index);
    }

    public abstract boolean isNotNull(int var1);

    public abstract boolean isNull(int var1);

    @NotNull
    public abstract Comparator<Integer> getComparator(boolean var1);

    @Nullable
    public abstract Double getDouble(int var1);

    @NotNull
    public final <T> Column<T> cast() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.bigdatatools.visualization.dataframe.columns.Column<T of com.intellij.bigdatatools.visualization.dataframe.columns.Column.cast>");
        return this;
    }

    @NotNull
    public abstract ClosedRange<Double> getRange();

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

