/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.style;

import com.intellij.bigdatatools.visualization.charts.style.ChartsJBColor;
import com.intellij.bigdatatools.visualization.charts.style.ColorTableCopyProvider;
import com.intellij.bigdatatools.visualization.charts.style.ColorTableModel;
import com.intellij.bigdatatools.visualization.charts.style.ColorTablePasteProvider;
import com.intellij.bigdatatools.visualization.charts.style.PaletteDialog;
import com.intellij.bigdatatools.visualization.charts.style.TableColorHexEditor;
import com.intellij.bigdatatools.visualization.charts.style.TableColorHexRenderer;
import com.intellij.bigdatatools.visualization.charts.style.TableColorPickerEditor;
import com.intellij.bigdatatools.visualization.charts.style.TableColorRenderer;
import com.intellij.bigdatatools.visualization.charts.utils.ChartMessagesBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005*\u0001\r\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\r\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0014J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001dJ\u0006\u0010\u001e\u001a\u00020\u0003J\b\u0010\u001f\u001a\u00020\u0003H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u001dH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u001d2\u0006\u0010!\u001a\u00020\u0003H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/bigdatatools/visualization/charts/style/PaletteDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "paletteName", "", "palette", "", "Lcom/intellij/bigdatatools/visualization/charts/style/ChartsJBColor;", "(Ljava/lang/String;Ljava/util/List;)V", "paletteNameField", "Ljavax/swing/JTextField;", "getPaletteNameField$annotations", "()V", "table", "com/intellij/bigdatatools/visualization/charts/style/PaletteDialog$table$1", "Lcom/intellij/bigdatatools/visualization/charts/style/PaletteDialog$table$1;", "tableModel", "Lcom/intellij/bigdatatools/visualization/charts/style/ColorTableModel;", "tabs", "Lcom/intellij/ui/components/JBTabbedPane;", "textArea", "Ljavax/swing/JTextArea;", "createCenterPanel", "Ljavax/swing/JComponent;", "createTablePanel", "Ljavax/swing/JPanel;", "Lorg/jetbrains/annotations/NotNull;", "createTextPanel", "getDimensionServiceKey", "getPalette", "", "getPaletteName", "modelToText", "textToModel", "text", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nPaletteDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaletteDialog.kt\ncom/intellij/bigdatatools/visualization/charts/style/PaletteDialog\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1324#2,3:160\n1#3:163\n1855#4,2:164\n*S KotlinDebug\n*F\n+ 1 PaletteDialog.kt\ncom/intellij/bigdatatools/visualization/charts/style/PaletteDialog\n*L\n51#1:160,3\n134#1:164,2\n*E\n"})
public final class PaletteDialog
extends DialogWrapper {
    @NotNull
    private final JTextField paletteNameField;
    @NotNull
    private final ColorTableModel tableModel;
    @NotNull
    private final table.1 table;
    @NotNull
    private final JTextArea textArea;
    @NotNull
    private final JBTabbedPane tabs;

    /*
     * WARNING - void declaration
     */
    public PaletteDialog(@NotNull String paletteName, @NotNull List<ChartsJBColor> palette) {
        void $this$tabs_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)paletteName, (String)"paletteName");
        Intrinsics.checkNotNullParameter(palette, (String)"palette");
        super(null, false);
        this.paletteNameField = new JTextField(paletteName);
        ColorTableModel colorTableModel = this.tableModel = new ColorTableModel(CollectionsKt.toMutableList((Collection)palette));
        this.table = new DataProvider(colorTableModel){
            @NotNull
            private final ColorTableCopyProvider copyProvider;
            @NotNull
            private final ColorTablePasteProvider pasteProvider;
            {
                this.copyProvider = new ColorTableCopyProvider(this);
                this.pasteProvider = new ColorTablePasteProvider(this);
            }

            @NotNull
            public final ColorTableCopyProvider getCopyProvider() {
                return this.copyProvider;
            }

            @NotNull
            public final ColorTablePasteProvider getPasteProvider() {
                return this.pasteProvider;
            }

            @Nullable
            public Object getData(@NotNull String dataId) {
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? (ActionUpdateThreadAware)this.copyProvider : (PlatformDataKeys.PASTE_PROVIDER.is(dataId) ? (ActionUpdateThreadAware)this.pasteProvider : null);
            }
        };
        this.textArea = new JTextArea();
        ColorTableModel colorTableModel2 = colorTableModel = new JBTabbedPane();
        PaletteDialog paletteDialog = this;
        boolean bl = false;
        $this$tabs_u24lambda_u240.addTab(ChartMessagesBundle.message("colorScheme.tab.table", new Object[0]), (Component)this.createTablePanel());
        $this$tabs_u24lambda_u240.addTab(ChartMessagesBundle.message("colorScheme.tab.text", new Object[0]), (Component)this.createTextPanel());
        paletteDialog.tabs = colorTableModel;
        this.init();
        this.setTitle(ChartMessagesBundle.message("colorScheme.edit.title", new Object[0]));
        Enumeration<TableColumn> enumeration = this.table.getColumnModel().getColumns();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getColumns(...)");
        Sequence $this$forEachIndexed$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TableColumn tableColumn = (TableColumn)item$iv;
            int i = n;
            boolean bl2 = false;
            it.setHeaderValue(switch (i) {
                case 0 -> ChartMessagesBundle.message("colorScheme.column.light.color", new Object[0]);
                case 1 -> ChartMessagesBundle.message("colorScheme.column.light.hex", new Object[0]);
                case 2 -> ChartMessagesBundle.message("colorScheme.column.dark.color", new Object[0]);
                case 3 -> ChartMessagesBundle.message("colorScheme.column.dark.hex", new Object[0]);
                default -> "";
            });
            switch (i) {
                case 0: 
                case 2: {
                    it.setCellRenderer(new TableColorRenderer());
                    it.setCellEditor(new TableColorPickerEditor(this.table));
                    break;
                }
                default: {
                    it.setCellRenderer(new TableColorHexRenderer());
                    it.setCellEditor(new TableColorHexEditor());
                }
            }
        }
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(2);
        this.tabs.addChangeListener(arg_0 -> PaletteDialog._init_$lambda$2(this, arg_0));
    }

    private static /* synthetic */ void getPaletteNameField$annotations() {
    }

    @NotNull
    public final String getPaletteName() {
        String string = this.paletteNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    public final List<ChartsJBColor> getPalette() {
        return this.tabs.getSelectedIndex() == 0 ? this.tableModel.getPalette() : this.textToModel();
    }

    private final JPanel createTablePanel() {
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.table).setAddAction(arg_0 -> PaletteDialog.createTablePanel$lambda$3(this, arg_0)).setRemoveAction(arg_0 -> PaletteDialog.createTablePanel$lambda$4(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    private final JPanel createTextPanel() {
        JPanel jPanel;
        JBScrollPane jBScrollPane;
        JBScrollPane $this$createTextPanel_u24lambda_u245 = jBScrollPane = new JBScrollPane((Component)this.textArea);
        boolean bl = false;
        $this$createTextPanel_u24lambda_u245.setBorder(null);
        JBScrollPane scrollPane = jBScrollPane;
        JLabel hint = new JLabel("<html>" + ChartMessagesBundle.message("colorScheme.text.hint", new Object[0]) + "</html>");
        JPanel $this$createTextPanel_u24lambda_u246 = jPanel = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$createTextPanel_u24lambda_u246.add((Component)scrollPane, "Center");
        $this$createTextPanel_u24lambda_u246.add((Component)hint, "South");
        return jPanel;
    }

    private final String modelToText() {
        StringBuilder sb = new StringBuilder();
        int n = this.tableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = "#%06X";
            Object[] objectArray = new Object[]{0xFFFFFF & this.tableModel.getLight(i)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            sb.append(string2).append(";\t");
            string = "#%06X";
            objectArray = new Object[]{0xFFFFFF & this.tableModel.getDark(i)};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            sb.append(string3).append(System.lineSeparator());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final List<ChartsJBColor> textToModel(String text2) {
        char[] cArray = new char[]{'\n'};
        List lines = StringsKt.split$default((CharSequence)text2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        List palette = new ArrayList();
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{";"};
            List split = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (split.size() < 2) continue;
            String string = ((Object)StringsKt.trim((CharSequence)((String)split.get(0)))).toString().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer a2 = StringsKt.toIntOrNull((String)string, (int)16);
            String string2 = ((Object)StringsKt.trim((CharSequence)((String)split.get(1)))).toString().substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            Integer b2 = StringsKt.toIntOrNull((String)string2, (int)16);
            if (a2 == null || b2 == null) continue;
            palette.add(new ChartsJBColor(a2, b2));
        }
        return palette;
    }

    private final List<ChartsJBColor> textToModel() {
        String string = this.textArea.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return this.textToModel(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        void $this$createCenterPanel_u24lambda_u249_u24lambda_u248;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel $this$createCenterPanel_u24lambda_u249 = jPanel2 = new JPanel(new BorderLayout());
        boolean bl = false;
        JPanel jPanel3 = jPanel = new JPanel(new BorderLayout());
        JPanel jPanel4 = $this$createCenterPanel_u24lambda_u249;
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u249_u24lambda_u248.add((Component)new JLabel(ChartMessagesBundle.message("colorScheme.title", new Object[0])), "Before");
        $this$createCenterPanel_u24lambda_u249_u24lambda_u248.add((Component)this.paletteNameField, "Center");
        jPanel4.add((Component)jPanel, "North");
        $this$createCenterPanel_u24lambda_u249.add((Component)this.tabs, "Center");
        return jPanel2;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "com.intellij.bigdatatools.visualization.charts.style.palette.bounds";
    }

    private static final void _init_$lambda$2(PaletteDialog this$0, ChangeEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.tabs.getSelectedIndex() == 0) {
            this$0.tableModel.setRows(this$0.textToModel());
        } else {
            this$0.textArea.setText(this$0.modelToText());
        }
    }

    private static final void createTablePanel$lambda$3(PaletteDialog this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ColorTableModel colorTableModel = this$0.tableModel;
        JBColor jBColor = JBColor.RED;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"RED");
        Color color = (Color)jBColor;
        JBColor jBColor2 = JBColor.RED;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"RED");
        colorTableModel.addRow(new ChartsJBColor(color, (Color)jBColor2));
        int tableIndex = this$0.table.convertRowIndexToView(this$0.tableModel.getRowCount() - 1);
        this$0.table.setRowSelectionInterval(tableIndex, tableIndex);
        this$0.table.editCellAt(tableIndex, 0);
        TableUtil.scrollSelectionToVisible((JTable)this$0.table);
    }

    private static final void createTablePanel$lambda$4(PaletteDialog this$0, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.table.getSelectedRow() != -1) {
            int modelIndex = this$0.table.convertRowIndexToModel(this$0.table.getSelectedRow());
            this$0.tableModel.removeRow(modelIndex);
        }
    }
}

