/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingResult;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingUtils;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.StockSeriesType;
import com.intellij.bigdatatools.visualization.charts.style.ChartsConfig;
import com.intellij.bigdatatools.visualization.charts.utils.ChartJsonUtilsKt;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.UtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.Stat;
import org.jetbrains.letsPlot.geom.Geom_boxplotKt;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.geom.BoxplotMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001Ba\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010 \u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020\u000bH\u0016J\b\u0010,\u001a\u00020\u000eH\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/StockSeriesSettings;", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "groups", "openValues", "closeValues", "highValues", "lowValues", "showLegend", "", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;Z)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "getCloseValues", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "getGroups", "()Ljava/util/List;", "getHighValues", "getKeys", "getLowValues", "getOpenValues", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/StockSeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/StockSeriesType;", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "hashCode", "isEmpty", "toJson", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nStockSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StockSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/StockSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n23#2:201\n23#2:202\n1#3:203\n1855#4,2:204\n*S KotlinDebug\n*F\n+ 1 StockSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/StockSeriesSettings\n*L\n107#1:201\n125#1:202\n145#1:204,2\n*E\n"})
public final class StockSeriesSettings
extends SeriesSettings {
    @NotNull
    private final StockSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @Nullable
    private final ColumnSettings openValues;
    @Nullable
    private final ColumnSettings closeValues;
    @Nullable
    private final ColumnSettings highValues;
    @Nullable
    private final ColumnSettings lowValues;
    private boolean showLegend;

    @Override
    @NotNull
    public StockSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @Nullable
    public final ColumnSettings getOpenValues() {
        return this.openValues;
    }

    @Nullable
    public final ColumnSettings getCloseValues() {
        return this.closeValues;
    }

    @Nullable
    public final ColumnSettings getHighValues() {
        return this.highValues;
    }

    @Nullable
    public final ColumnSettings getLowValues() {
        return this.lowValues;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public StockSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @Nullable ColumnSettings openValues, @Nullable ColumnSettings closeValues, @Nullable ColumnSettings highValues, @Nullable ColumnSettings lowValues, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        this.type = StockSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.openValues = openValues;
        this.closeValues = closeValues;
        this.highValues = highValues;
        this.lowValues = lowValues;
        this.showLegend = showLegend;
    }

    public /* synthetic */ StockSeriesSettings(List list2, List list3, ColumnSettings columnSettings, ColumnSettings columnSettings2, ColumnSettings columnSettings3, ColumnSettings columnSettings4, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            columnSettings = null;
        }
        if ((n & 8) != 0) {
            columnSettings2 = null;
        }
        if ((n & 0x10) != 0) {
            columnSettings3 = null;
        }
        if ((n & 0x20) != 0) {
            columnSettings4 = null;
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(list2, list3, columnSettings, columnSettings2, columnSettings3, columnSettings4, bl);
    }

    public StockSeriesSettings(@NotNull JsonObject json) {
        ColumnSettings columnSettings;
        ColumnSettings columnSettings2;
        ColumnSettings columnSettings3;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = StockSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        List<ColumnSettings> values2 = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        ColumnSettings columnSettings4 = ChartJsonUtilsKt.optColumnSettings(json, "open");
        if (columnSettings4 == null) {
            columnSettings4 = this.openValues = (ColumnSettings)CollectionsKt.getOrNull(values2, (int)0);
        }
        if ((columnSettings3 = ChartJsonUtilsKt.optColumnSettings(json, "close")) == null) {
            columnSettings3 = this.closeValues = (ColumnSettings)CollectionsKt.getOrNull(values2, (int)1);
        }
        if ((columnSettings2 = ChartJsonUtilsKt.optColumnSettings(json, "high")) == null) {
            columnSettings2 = this.highValues = (ColumnSettings)CollectionsKt.getOrNull(values2, (int)2);
        }
        if ((columnSettings = ChartJsonUtilsKt.optColumnSettings(json, "low")) == null) {
            columnSettings = (ColumnSettings)CollectionsKt.getOrNull(values2, (int)3);
        }
        this.lowValues = columnSettings;
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public JsonObject toJson() {
        void $this$toJson_u24lambda_u241_u24lambda_u240;
        List list2;
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u241 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u241.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "high", this.highValues);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "open", this.openValues);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "close", this.closeValues);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u241, "low", this.lowValues);
        List list3 = list2 = (List)new ArrayList();
        String string = "values";
        JsonObject jsonObject2 = $this$toJson_u24lambda_u241;
        boolean bl2 = false;
        UtilKt.addIfNotNull((List)$this$toJson_u24lambda_u241_u24lambda_u240, (Object)this.highValues);
        UtilKt.addIfNotNull((List)$this$toJson_u24lambda_u241_u24lambda_u240, (Object)this.closeValues);
        UtilKt.addIfNotNull((List)$this$toJson_u24lambda_u241_u24lambda_u240, (Object)this.openValues);
        UtilKt.addIfNotNull((List)$this$toJson_u24lambda_u241_u24lambda_u240, (Object)this.lowValues);
        Unit unit = Unit.INSTANCE;
        ChartJsonUtilsKt.optSet(jsonObject2, string, list2);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u241, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.openValues == null && this.closeValues == null && this.highValues == null && this.lowValues == null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof StockSeriesSettings && Intrinsics.areEqual(((StockSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((StockSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual((Object)((StockSeriesSettings)other).openValues, (Object)this.openValues) && Intrinsics.areEqual((Object)((StockSeriesSettings)other).closeValues, (Object)this.closeValues) && Intrinsics.areEqual((Object)((StockSeriesSettings)other).highValues, (Object)this.highValues) && Intrinsics.areEqual((Object)((StockSeriesSettings)other).lowValues, (Object)this.lowValues) && ((StockSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public StockSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new StockSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.openValues, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.closeValues, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.highValues, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.lowValues, dataFrame), this.showLegend);
    }

    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        ColumnSettings it;
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty()) {
            StockSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(StockSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Stock series should have at least one categories axis.");
            return CollectionsKt.emptyList();
        }
        List[] $this$thisLogger$iv = new List[]{this.keys, this.groups};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        ColumnSettings localOpenValues = StockSeriesSettings.getLetsPlotLayer$settingsOrNull(dataFrame, this.openValues);
        ColumnSettings localCloseValues = StockSeriesSettings.getLetsPlotLayer$settingsOrNull(dataFrame, this.closeValues);
        ColumnSettings localHighValues = StockSeriesSettings.getLetsPlotLayer$settingsOrNull(dataFrame, this.highValues);
        ColumnSettings localLowValues = StockSeriesSettings.getLetsPlotLayer$settingsOrNull(dataFrame, this.lowValues);
        if (!(localOpenValues != null && localCloseValues != null || localHighValues != null && localLowValues != null)) {
            StockSeriesSettings $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger = false;
            Logger logger3 = Logger.getInstance(StockSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.warn("Stock series should have one of open/close or high/low.");
            return CollectionsKt.emptyList();
        }
        ArrayList<ColumnSettings> notNullSettings = new ArrayList<ColumnSettings>(4);
        ColumnSettings columnSettings = localOpenValues;
        if (columnSettings != null) {
            it = columnSettings;
            boolean bl = false;
            notNullSettings.add(it);
        }
        ColumnSettings columnSettings2 = localCloseValues;
        if (columnSettings2 != null) {
            it = columnSettings2;
            boolean bl = false;
            notNullSettings.add(it);
        }
        ColumnSettings columnSettings3 = localHighValues;
        if (columnSettings3 != null) {
            it = columnSettings3;
            boolean bl = false;
            notNullSettings.add(it);
        }
        ColumnSettings columnSettings4 = localLowValues;
        if (columnSettings4 != null) {
            it = columnSettings4;
            boolean bl = false;
            notNullSettings.add(it);
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, (List<ColumnSettings>)notNullSettings);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        Set groupNames = new LinkedHashSet();
        int n = res.getYColumns().size();
        for (int i = 0; i < n; ++i) {
            groupNames.add(StringsKt.removeSuffix((String)res.getYColumns().get(i).getName(), (CharSequence)res.getYColumnsSettings().get(i).getName()));
        }
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = groupNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column<Number> it2;
            String groupName = (String)element$iv;
            boolean bl = false;
            Column<Number> highColumn = StockSeriesSettings.getLetsPlotLayer$lambda$11$getColumn(res, groupName, localHighValues);
            Column<Number> openColumn = StockSeriesSettings.getLetsPlotLayer$lambda$11$getColumn(res, groupName, localOpenValues);
            Column<Number> closeColumn = StockSeriesSettings.getLetsPlotLayer$lambda$11$getColumn(res, groupName, localCloseValues);
            Column<Number> lowColumn = StockSeriesSettings.getLetsPlotLayer$lambda$11$getColumn(res, groupName, localLowValues);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList())};
            Map data = MapsKt.mutableMapOf((Pair[])pairArray);
            if (highColumn != null) {
                boolean bl2 = false;
                data.put(it2.getName(), it2.toList());
            }
            if (openColumn != null) {
                boolean bl3 = false;
                data.put(it2.getName(), it2.toList());
            }
            if (closeColumn != null) {
                boolean bl4 = false;
                data.put(it2.getName(), it2.toList());
            }
            if (lowColumn != null) {
                boolean bl5 = false;
                data.put(it2.getName(), it2.toList());
            }
            Color color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex + result2.size());
            layerTooltips tooltips = new layerTooltips(new String[0]);
            if (!StringsKt.isBlank((CharSequence)groupName)) {
                tooltips = tooltips.line(groupName);
            }
            tooltips = tooltips.line("high\nopen\nclose\nlow|^ymax\n^upper\n^lower\n^ymin");
            Collection collection = result2;
            layerTooltips layerTooltips2 = tooltips;
            collection.add(Geom_boxplotKt.geomBoxplot$default(data, Stat.INSTANCE.getIdentity(), null, false, layerTooltips2, null, null, null, null, null, null, null, null, null, color, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Function1)new Function1<BoxplotMapping, Unit>(res, highColumn, openColumn, closeColumn, lowColumn){
                final /* synthetic */ GroupingResult $res;
                final /* synthetic */ Column<Number> $highColumn;
                final /* synthetic */ Column<Number> $openColumn;
                final /* synthetic */ Column<Number> $closeColumn;
                final /* synthetic */ Column<Number> $lowColumn;
                {
                    this.$res = $res;
                    this.$highColumn = $highColumn;
                    this.$openColumn = $openColumn;
                    this.$closeColumn = $closeColumn;
                    this.$lowColumn = $lowColumn;
                    super(1);
                }

                public final void invoke(@NotNull BoxplotMapping $this$geomBoxplot) {
                    block3: {
                        Column<Number> it;
                        Intrinsics.checkNotNullParameter((Object)$this$geomBoxplot, (String)"$this$geomBoxplot");
                        $this$geomBoxplot.setX(this.$res.getXColumn().getName());
                        Column<Number> column = this.$highColumn;
                        if (column != null) {
                            it = column;
                            boolean bl = false;
                            $this$geomBoxplot.setYmax(it.getName());
                        }
                        Column<Number> column2 = this.$openColumn;
                        if (column2 != null) {
                            it = column2;
                            boolean bl = false;
                            $this$geomBoxplot.setUpper(it.getName());
                        }
                        Column<Number> column3 = this.$closeColumn;
                        if (column3 != null) {
                            it = column3;
                            boolean bl = false;
                            $this$geomBoxplot.setLower(it.getName());
                        }
                        Column<Number> column4 = this.$lowColumn;
                        if (column4 == null) break block3;
                        it = column4;
                        boolean bl = false;
                        $this$geomBoxplot.setYmin(it.getName());
                    }
                }
            }, -16412, 3, null));
        }
        return CollectionsKt.plus((Collection)result2, (Object)LabsKt.ylab(""));
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + ((Object)this.keys).hashCode();
        result2 = 31 * result2 + ((Object)this.groups).hashCode();
        ColumnSettings columnSettings = this.openValues;
        result2 = 31 * result2 + (columnSettings != null ? columnSettings.hashCode() : 0);
        ColumnSettings columnSettings2 = this.closeValues;
        result2 = 31 * result2 + (columnSettings2 != null ? columnSettings2.hashCode() : 0);
        ColumnSettings columnSettings3 = this.highValues;
        result2 = 31 * result2 + (columnSettings3 != null ? columnSettings3.hashCode() : 0);
        ColumnSettings columnSettings4 = this.lowValues;
        result2 = 31 * result2 + (columnSettings4 != null ? columnSettings4.hashCode() : 0);
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        return result2;
    }

    private static final ColumnSettings getLetsPlotLayer$settingsOrNull(DataFrame $dataFrame, ColumnSettings value) {
        return value == null || !$dataFrame.has(value.getColumnId().getName()) ? null : value;
    }

    private static final Column<Number> getLetsPlotLayer$lambda$11$getColumn(GroupingResult res, String $groupName, ColumnSettings columnSettings) {
        Column column;
        if (columnSettings == null) {
            column = null;
        } else {
            Object v1;
            block3: {
                Iterable iterable = res.getYColumns();
                for (Object t : iterable) {
                    Column it = (Column)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)($groupName + columnSettings.getName()))) continue;
                    v1 = t;
                    break block3;
                }
                v1 = null;
            }
            Column column2 = v1;
            column = column2 != null ? column2.cast() : null;
        }
        return column;
    }
}

