/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.bigdatatools.visualization.charts.core.utils.GroupingUtils;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.type.PieSeriesType;
import com.intellij.bigdatatools.visualization.charts.utils.ChartJsonUtilsKt;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.DoubleColumn;
import com.intellij.bigdatatools.visualization.dataframe.columns.StringColumn;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.Stat;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.geom.geomPie;
import org.jetbrains.letsPlot.intern.Layer;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.intern.layer.StatOptions;
import org.jetbrains.letsPlot.intern.layer.geom.PieMapping;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001BK\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\b\u0010'\u001a\u00020\bH\u0016J\b\u0010(\u001a\u00020\fH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006)"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/settings/data/PieSeriesSettings;", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "values", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/ColumnSettings;", "groups", "keys", "showPercents", "", "showLegend", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZZ)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "getGroups", "()Ljava/util/List;", "getKeys", "getShowLegend", "()Z", "setShowLegend", "(Z)V", "getShowPercents", "setShowPercents", "type", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/PieSeriesType;", "getType", "()Lcom/intellij/bigdatatools/visualization/charts/settings/data/type/PieSeriesType;", "getValues", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Layer;", "chartIndex", "", "hashCode", "isEmpty", "toJson", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nPieSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/PieSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n23#2:244\n23#2:245\n23#2:246\n23#2:247\n1#3:248\n*S KotlinDebug\n*F\n+ 1 PieSeriesSettings.kt\ncom/intellij/bigdatatools/visualization/charts/settings/data/PieSeriesSettings\n*L\n83#1:244\n102#1:245\n147#1:246\n154#1:247\n*E\n"})
public final class PieSeriesSettings
extends SeriesSettings {
    @NotNull
    private final PieSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> values;
    @NotNull
    private final List<ColumnSettings> groups;
    private boolean showLegend;
    private boolean showPercents;

    @Override
    @NotNull
    public PieSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public final boolean getShowPercents() {
        return this.showPercents;
    }

    public final void setShowPercents(boolean bl) {
        this.showPercents = bl;
    }

    public PieSeriesSettings(@NotNull List<ColumnSettings> values2, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> keys, boolean showPercents, boolean showLegend) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.type = PieSeriesType.Companion.getInstance();
        this.values = values2;
        this.groups = groups2;
        this.keys = keys;
        this.showPercents = showPercents;
        this.showLegend = showLegend;
    }

    public /* synthetic */ PieSeriesSettings(List list2, List list3, List list4, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        this(list2, list3, list4, bl, bl2);
    }

    public PieSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = PieSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        this.showPercents = ChartJsonUtilsKt.optBoolean(json, "showPercents");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend", true);
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showPercents", this.showPercents);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof PieSeriesSettings && Intrinsics.areEqual(((PieSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((PieSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((PieSeriesSettings)other).values, this.values) && ((PieSeriesSettings)other).showPercents == this.showPercents && ((PieSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public PieSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new PieSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), this.showPercents, this.showLegend);
    }

    @NotNull
    public List<Layer> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.values.isEmpty()) {
            PieSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(PieSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Pie series should have one categories axis.");
            return CollectionsKt.emptyList();
        }
        List[] $this$thisLogger$iv = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        if (this.keys.isEmpty()) {
            Column<Object> mainColumn;
            DataFrame df = GroupingUtils.INSTANCE.getGroupedDataFrame(this.keys, dataFrame);
            Column<Object> column = mainColumn = CollectionsKt.firstOrNull(this.keys) == null ? df.get(((ColumnSettings)CollectionsKt.first(this.values)).getColumnId()).cast() : SeriesSettings.Companion.getAggregatedColumn((ColumnSettings)CollectionsKt.first(this.values), df).cast();
            if (!mainColumn.isNumerical()) {
                PieSeriesSettings $this$thisLogger$iv2 = this;
                boolean $i$f$thisLogger = false;
                Logger logger3 = Logger.getInstance(PieSeriesSettings.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
                logger3.warn("Pie series accepts only number column.");
                return CollectionsKt.emptyList();
            }
            Column<?> labelColumn = CollectionsKt.firstOrNull(this.keys) == null ? null : (df.has(((ColumnSettings)CollectionsKt.first(this.keys)).getColumnId().getName()) ? df.get(((ColumnSettings)CollectionsKt.first(this.keys)).getColumnId()) : null);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)mainColumn.getName(), mainColumn.toList())};
            Map data = MapsKt.mutableMapOf((Pair[])pairArray);
            if (labelColumn != null) {
                data.put(labelColumn.getName(), labelColumn.toList());
            }
            layerTooltips tooltips = new layerTooltips(new String[0]).line(mainColumn.getName() + "|@{" + mainColumn.getName() + "}");
            if (labelColumn != null) {
                tooltips.line(labelColumn.getName() + "|@{" + labelColumn.getName() + "}");
            }
            Collection collection = result2;
            SamplingOptions samplingOptions = SeriesSettings.Companion.getSampling(mainColumn);
            Color color = Color.Companion.getTRANSPARENT();
            java.awt.Color color2 = UIUtil.getTooltipSeparatorColor();
            boolean bl = this.showLegend;
            collection.add(new geomPie(data, null, null, bl, samplingOptions, tooltips, null, null, null, null, null, null, null, null, 1, null, null, color, null, null, null, null, null, color2, "y", null, null, (Function1)new Function1<PieMapping, Unit>(mainColumn, labelColumn){
                final /* synthetic */ Column<? extends Number> $mainColumn;
                final /* synthetic */ Column<?> $labelColumn;
                {
                    this.$mainColumn = $mainColumn;
                    this.$labelColumn = $labelColumn;
                    super(1);
                }

                public final void invoke(@NotNull PieMapping $this$$receiver) {
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    $this$$receiver.setSlice(this.$mainColumn.getName());
                    if (this.$labelColumn != null) {
                        $this$$receiver.setFill(this.$labelColumn.getName());
                    }
                }
            }, 108904390, null));
        } else {
            Object object;
            Object object2;
            List groupingColumns = CollectionsKt.plus((Collection)this.keys, (Iterable)this.groups);
            DataFrame df = GroupingUtils.INSTANCE.getGroupedDataFrame(groupingColumns, dataFrame);
            StringColumn labelColumn = GroupingUtils.INSTANCE.getJoinedColumn(groupingColumns, df);
            StringColumn finalLabelColumn = null;
            Column<Number> mainColumn = null;
            if (this.values.size() == 1) {
                ColumnSettings columnSettings = (ColumnSettings)CollectionsKt.first(this.values);
                if (!SeriesSettings.Companion.columnAggregationSupported(columnSettings, df)) {
                    PieSeriesSettings $this$thisLogger$iv3 = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger4 = Logger.getInstance(PieSeriesSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
                    logger4.warn("Column " + columnSettings.getColumnId().getName() + " aggregation " + columnSettings.getModifier().getTitle() + " not supported in pie chart.");
                    return CollectionsKt.emptyList();
                }
                mainColumn = SeriesSettings.Companion.getAggregatedColumn(columnSettings, df).cast();
                if (!mainColumn.isNumerical()) {
                    PieSeriesSettings $this$thisLogger$iv4 = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger5 = Logger.getInstance(PieSeriesSettings.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"getInstance(...)");
                    logger5.warn("Pie series accepts only numerical column, but " + mainColumn.getName() + " is not numerical.");
                    return CollectionsKt.emptyList();
                }
                finalLabelColumn = labelColumn;
            } else {
                Column<Number> column;
                ArrayList<Object> arrayList;
                boolean hasDifferentTypes;
                Object v5;
                int n;
                block23: {
                    Iterable $i$f$thisLogger = this.values;
                    object2 = $i$f$thisLogger.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        ColumnSettings it = (ColumnSettings)object;
                        n = 0;
                        if (!(!Intrinsics.areEqual(df.get(it.getColumnId()).getType(), df.get(((ColumnSettings)CollectionsKt.first(this.values)).getColumnId()).getType()))) continue;
                        v5 = object;
                        break block23;
                    }
                    v5 = null;
                }
                boolean bl = hasDifferentTypes = v5 != null;
                if (hasDifferentTypes) {
                    arrayList = new ArrayList(this.values.size() * df.getRowsCount());
                } else {
                    ArrayList<?> arrayList2 = df.get(((ColumnSettings)CollectionsKt.first(this.values)).getColumnId()).getType().createDataArray();
                    arrayList = arrayList2;
                    Intrinsics.checkNotNull(arrayList2, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Number?>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Number?> }");
                }
                ArrayList<Object> finalMainColumn = arrayList;
                for (ColumnSettings value : this.values) {
                    Column<Object> col = SeriesSettings.Companion.getAggregatedColumn(value, df);
                    if (hasDifferentTypes) {
                        n = col.getSize();
                        for (int i = 0; i < n; ++i) {
                            finalMainColumn.add(col.getDouble(i));
                        }
                        continue;
                    }
                    List<Object> list2 = col.toList();
                    Intrinsics.checkNotNull(list2, (String)"null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Number>");
                    finalMainColumn.addAll((Collection)list2);
                }
                if (hasDifferentTypes) {
                    data = new ArrayList(this.values.size() * df.getRowsCount());
                    for (ColumnSettings value : this.values) {
                        col = df.get(value.getColumnId());
                        int n2 = col.getSize();
                        for (int i = 0; i < n2; ++i) {
                            data.add(col.getDouble(i));
                        }
                    }
                    column = new DoubleColumn("values", (List<Double>)data);
                } else {
                    ArrayList<?> arrayList3 = df.get(((ColumnSettings)CollectionsKt.first(this.values)).getColumnId()).getType().createDataArray();
                    Intrinsics.checkNotNull(arrayList3, (String)"null cannot be cast to non-null type java.util.ArrayList<kotlin.Number>{ kotlin.collections.TypeAliasesKt.ArrayList<kotlin.Number> }");
                    data = arrayList3;
                    for (ColumnSettings value : this.values) {
                        col = SeriesSettings.Companion.getAggregatedColumn(value, df);
                        List<Object> list3 = col.toList();
                        Intrinsics.checkNotNull(list3, (String)"null cannot be cast to non-null type kotlin.collections.Collection<kotlin.Number>");
                        data.addAll((Collection)list3);
                    }
                    column = df.get(((ColumnSettings)CollectionsKt.first(this.values)).getColumnId()).getType().createDataColumn("data", (List)data).cast();
                }
                mainColumn = column;
                ArrayList finalLabelData = new ArrayList(labelColumn.getSize() * this.values.size());
                for (ColumnSettings value : this.values) {
                    finalLabelData.addAll(labelColumn.toList());
                }
                finalLabelColumn = new StringColumn(labelColumn.getName(), finalLabelData);
            }
            layerTooltips tooltips = new layerTooltips(new String[0]).line(finalLabelColumn.getName() + "|@{" + finalLabelColumn.getName() + "}").line(mainColumn.getName() + "|@{" + mainColumn.getName() + "}");
            Collection collection = result2;
            object2 = new Pair[]{TuplesKt.to((Object)mainColumn.getName(), mainColumn.toList()), TuplesKt.to((Object)finalLabelColumn.getName(), finalLabelColumn.toList())};
            Map map2 = MapsKt.mapOf((Pair[])object2);
            object2 = Stat.INSTANCE.getIdentity();
            object = SeriesSettings.Companion.getSampling(mainColumn);
            boolean bl = this.showLegend;
            java.awt.Color color = UIUtil.getTooltipSeparatorColor();
            Color color3 = Color.Companion.getTRANSPARENT();
            collection.add(new geomPie(map2, (StatOptions)object2, null, bl, (SamplingOptions)object, tooltips, null, null, null, null, null, null, null, null, 1, null, null, color3, null, null, null, null, null, color, "y", null, null, (Function1)new Function1<PieMapping, Unit>(mainColumn, finalLabelColumn){
                final /* synthetic */ Column<Number> $mainColumn;
                final /* synthetic */ StringColumn $finalLabelColumn;
                {
                    this.$mainColumn = $mainColumn;
                    this.$finalLabelColumn = $finalLabelColumn;
                    super(1);
                }

                public final void invoke(@NotNull PieMapping $this$$receiver) {
                    Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                    $this$$receiver.setSlice(this.$mainColumn.getName());
                    $this$$receiver.setFill(this.$finalLabelColumn.getName());
                }
            }, 108904388, null));
        }
        return result2;
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + ((Object)this.keys).hashCode();
        result2 = 31 * result2 + ((Object)this.values).hashCode();
        result2 = 31 * result2 + ((Object)this.groups).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        result2 = 31 * result2 + Boolean.hashCode(this.showPercents);
        return result2;
    }
}

