/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.analyser.checkers;

import com.intellij.bigdatatools.visualization.charts.analyser.checkers.SeriesChecker;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnModifier;
import com.intellij.bigdatatools.visualization.charts.settings.data.ColumnSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.ScatterSeriesSettings;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import com.intellij.bigdatatools.visualization.dataframe.aggregation.Var;
import com.intellij.bigdatatools.visualization.dataframe.columns.Column;
import com.intellij.bigdatatools.visualization.dataframe.columns.ColumnId;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/analyser/checkers/ScatterSeriesChecker;", "Lcom/intellij/bigdatatools/visualization/charts/analyser/checkers/SeriesChecker;", "()V", "check", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nScatterSeriesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScatterSeriesChecker.kt\ncom/intellij/bigdatatools/visualization/charts/analyser/checkers/ScatterSeriesChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,29:1\n1054#2:30\n*S KotlinDebug\n*F\n+ 1 ScatterSeriesChecker.kt\ncom/intellij/bigdatatools/visualization/charts/analyser/checkers/ScatterSeriesChecker\n*L\n21#1:30\n*E\n"})
public final class ScatterSeriesChecker
implements SeriesChecker {
    @Override
    @NotNull
    public List<SeriesSettings> check(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (dataFrame.getColumns().size() < 2) {
            return CollectionsKt.emptyList();
        }
        List<Column<Number>> numericalColumns = SeriesChecker.Companion.getNumericalColumns(dataFrame);
        if (numericalColumns.size() < 2) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$sortedByDescending$iv = numericalColumns;
        boolean $i$f$sortedByDescending = false;
        List numericalColumnsByVariance = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Column it = (Column)b2;
                boolean bl = false;
                Comparable comparable = Var.Companion.columnVariance(it);
                it = (Column)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Var.Companion.columnVariance(it));
            }
        });
        ColumnId columnId = dataFrame.getColumnId((Column)numericalColumnsByVariance.get(1));
        if (columnId == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId xColumnId = columnId;
        ColumnId columnId2 = dataFrame.getColumnId((Column)numericalColumnsByVariance.get(0));
        if (columnId2 == null) {
            return CollectionsKt.emptyList();
        }
        ColumnId yColumnId = columnId2;
        return CollectionsKt.listOf((Object)new ScatterSeriesSettings(CollectionsKt.listOf((Object)new ColumnSettings(xColumnId, ColumnModifier.GroupAndSort)), null, CollectionsKt.listOf((Object)new ColumnSettings(yColumnId, ColumnModifier.Mean)), false, 10, null));
    }
}

