/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.bigdatatools.visualization.charts.analyser;

import com.intellij.bigdatatools.visualization.charts.analyser.checkers.BarSeriesChecker;
import com.intellij.bigdatatools.visualization.charts.analyser.checkers.LineSeriesChecker;
import com.intellij.bigdatatools.visualization.charts.analyser.checkers.PieSeriesChecker;
import com.intellij.bigdatatools.visualization.charts.analyser.checkers.ScatterSeriesChecker;
import com.intellij.bigdatatools.visualization.charts.analyser.checkers.SeriesChecker;
import com.intellij.bigdatatools.visualization.charts.analyser.checkers.StockSeriesChecker;
import com.intellij.bigdatatools.visualization.charts.settings.data.SeriesSettings;
import com.intellij.bigdatatools.visualization.dataframe.DataFrame;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/bigdatatools/visualization/charts/analyser/SeriesSuggester;", "", "()V", "checkers", "", "Lcom/intellij/bigdatatools/visualization/charts/analyser/checkers/SeriesChecker;", "[Lcom/intellij/bigdatatools/visualization/charts/analyser/checkers/SeriesChecker;", "getSingleSuggestion", "", "Lcom/intellij/bigdatatools/visualization/charts/settings/data/SeriesSettings;", "dataFrame", "Lcom/intellij/bigdatatools/visualization/dataframe/DataFrame;", "getSuggestions", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nSeriesSuggester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SeriesSuggester.kt\ncom/intellij/bigdatatools/visualization/charts/analyser/SeriesSuggester\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,31:1\n13309#2,2:32\n*S KotlinDebug\n*F\n+ 1 SeriesSuggester.kt\ncom/intellij/bigdatatools/visualization/charts/analyser/SeriesSuggester\n*L\n22#1:32,2\n*E\n"})
public final class SeriesSuggester {
    @NotNull
    public static final SeriesSuggester INSTANCE = new SeriesSuggester();
    @NotNull
    private static SeriesChecker[] checkers;

    private SeriesSuggester() {
    }

    @NotNull
    public final List<SeriesSettings> getSuggestions(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (dataFrame.getRowsCount() < 2) {
            return CollectionsKt.emptyList();
        }
        ArrayList suggestions = new ArrayList();
        SeriesChecker[] $this$forEach$iv = checkers;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SeriesChecker element$iv;
            SeriesChecker it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            suggestions.addAll(it.check(dataFrame));
        }
        return suggestions;
    }

    @NotNull
    public final List<SeriesSettings> getSingleSuggestion(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        List<SeriesSettings> suggestions = this.getSuggestions(dataFrame);
        return suggestions.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)CollectionsKt.first(suggestions));
    }

    static {
        SeriesChecker[] seriesCheckerArray = new SeriesChecker[]{new StockSeriesChecker(), new BarSeriesChecker(), new LineSeriesChecker(), new ScatterSeriesChecker(), new PieSeriesChecker()};
        checkers = seriesCheckerArray;
    }
}

