/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssNamedItemPresentation;
import com.intellij.psi.css.impl.parsing.CssParser2;
import com.intellij.psi.css.impl.stubs.CssPseudoSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElement;
import com.intellij.psi.css.impl.stubs.base.CssNamedStubElementType;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.resolve.CssResolver;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CssPseudoSelectorBase
extends CssNamedStubElement<CssPseudoSelectorStub<? extends CssPseudoSelector>>
implements CssPseudoSelector {
    public CssPseudoSelectorBase(@NotNull CssPseudoSelectorStub<? extends CssPseudoSelector> stub, @NotNull CssNamedStubElementType nodeType) {
        if (stub == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public CssPseudoSelectorBase(@NotNull ASTNode node) {
        if (node == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @Override
    @NotNull
    public String getName() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                CssPseudoSelectorBase.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = CssPsiUtil.getTokenText(this.getNameIdentifier());
        if (string == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        PsiElement token = CssPsiUtil.findToken(this, CssElementTypes.NAME_TOKEN_TYPES);
        if (token == null) {
            return null;
        }
        PsiElement sibling = token.getNextSibling();
        return sibling == null || sibling.getNode().getElementType() == CssElementTypes.CSS_LPAREN || sibling.getNode().getElementType() == CssElementTypes.CSS_RPAREN ? token : null;
    }

    @Override
    public CssSelector @NotNull [] getExpressionSelectors() {
        CssFunction function;
        CssSelectorList selectorList;
        if (ArrayUtil.contains((String)this.getName(), (String[])CssParser2.PSEUDOS_ACCEPTING_SELECTOR) && (selectorList = (CssSelectorList)PsiTreeUtil.getChildOfType((PsiElement)(function = (CssFunction)PsiTreeUtil.findChildOfType((PsiElement)this, CssFunction.class)), CssSelectorList.class)) != null) {
            CssSelector[] cssSelectorArray = selectorList.getSelectors();
            if (cssSelectorArray == null) {
                CssPseudoSelectorBase.$$$reportNull$$$0(5);
            }
            return cssSelectorArray;
        }
        if (CssSelector.EMPTY_ARRAY == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(6);
        }
        return CssSelector.EMPTY_ARRAY;
    }

    @Override
    public boolean isMatch(@NotNull XmlTag tag, @NotNull CssResolver resolver) {
        if (tag == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(7);
        }
        if (resolver == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(8);
        }
        if (ArrayUtil.contains((String)this.getName(), (String[])CssParser2.PSEUDOS_ACCEPTING_SELECTOR)) {
            CssSelector[] expressionSelectors;
            for (CssSelector selector : expressionSelectors = this.getExpressionSelectors()) {
                if (!selector.isMatch(tag, resolver, null)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(9);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitPseudoSelector(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public int getColonPrefixLength() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            return stub.getColonPrefixLength();
        }
        int result = 0;
        for (ASTNode element : this.getNode().getChildren(null)) {
            if (element == null || element.getElementType() != CssElementTypes.CSS_COLON) break;
            ++result;
        }
        return result;
    }

    @Override
    @NotNull
    public TextRange getColonPrefixRange() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            TextRange textRange = stub.getColonPrefixRange();
            if (textRange == null) {
                CssPseudoSelectorBase.$$$reportNull$$$0(10);
            }
            return textRange;
        }
        int result = 0;
        for (ASTNode element : this.getNode().getChildren(null)) {
            if (element == null || element.getElementType() != CssElementTypes.CSS_COLON) break;
            result += element.getTextLength();
        }
        TextRange textRange = TextRange.create((int)0, (int)result);
        if (textRange == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    @Override
    @Nullable
    public String getExpressionText() {
        CssPseudoSelectorStub stub = (CssPseudoSelectorStub)this.getStub();
        if (stub != null) {
            return stub.getExpressionText();
        }
        CssFunction function = (CssFunction)this.findChildByClass(CssFunction.class);
        if (function == null) {
            return null;
        }
        CssElement args = (CssElement)PsiTreeUtil.getChildOfAnyType((PsiElement)function, (Class[])new Class[]{CssTermList.class, CssSelectorList.class});
        return args != null ? args.getText() : null;
    }

    @Override
    @NotNull
    public Collection<CssPseudoSelectorDescriptor> getDescriptors() {
        Collection<CssPseudoSelectorDescriptor> collection = this.getDescriptors(this);
        if (collection == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public Collection<CssPseudoSelectorDescriptor> getDescriptors(@NotNull PsiElement context) {
        Collection<? extends CssPseudoSelectorDescriptor> descriptors;
        Collection<? extends CssPseudoSelectorDescriptor> filteredDescriptors;
        if (context == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(13);
        }
        Collection<CssPseudoSelectorDescriptor> collection = CssDescriptorsUtil.filterPseudoSelectorDescriptorsByColonPrefix((filteredDescriptors = CssDescriptorsUtil.filterDescriptorsByContext(descriptors = CssDescriptorsUtil.getPseudoSelectorDescriptors(this.getName(), context), context)).isEmpty() ? descriptors : filteredDescriptors, this.getColonPrefixLength());
        if (collection == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement token;
        if (name == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(15);
        }
        if ((token = this.getNameIdentifier()) != null) {
            CssPsiUtil.replaceToken(token, name);
        }
        return this;
    }

    @Override
    @NotNull
    public CssSelectorSuffixType getType() {
        CssSelectorSuffixType cssSelectorSuffixType = CssSelectorSuffixType.UNKNOWN;
        if (cssSelectorSuffixType == null) {
            CssPseudoSelectorBase.$$$reportNull$$$0(16);
        }
        return cssSelectorSuffixType;
    }

    public ItemPresentation getPresentation() {
        String presentableText = StringUtil.repeatSymbol((char)':', (int)this.getColonPrefixLength()) + this.getName();
        String expressionText = this.getExpressionText();
        if (expressionText != null) {
            presentableText = presentableText + "(" + expressionText + ")";
        }
        return new CssNamedItemPresentation(this, presentableText);
    }

    @Override
    @Nullable
    public CssRuleset getRuleset() {
        return (CssRuleset)this.getStubOrPsiParentOfType(CssRuleset.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 10, 11, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssPseudoSelectorBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssPseudoSelectorBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionSelectors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColonPrefixRange";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isMatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 10, 11, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

