/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.configuration;

import com.intellij.codeInsight.template.emmet.configuration.CssPrefix;
import com.intellij.util.BitUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public final class CssPrefixInfo {
    @NotNull
    private final String myPropertyName;
    @NotNull
    private final Collection<CssPrefix> myEnabledPrefixes;

    public CssPrefixInfo(@NotNull String propertyName, CssPrefix ... enabledPrefixes) {
        if (propertyName == null) {
            CssPrefixInfo.$$$reportNull$$$0(0);
        }
        this.myPropertyName = propertyName;
        this.myEnabledPrefixes = enabledPrefixes.length == 0 ? Collections.emptySet() : EnumSet.copyOf(Arrays.asList(enabledPrefixes));
        for (CssPrefix prefix : enabledPrefixes) {
            this.setValue(prefix, true);
        }
    }

    public CssPrefixInfo(@NotNull String propertyName, Collection<CssPrefix> enabledPrefixes) {
        if (propertyName == null) {
            CssPrefixInfo.$$$reportNull$$$0(1);
        }
        this.myPropertyName = propertyName;
        this.myEnabledPrefixes = enabledPrefixes.isEmpty() ? Collections.emptySet() : EnumSet.copyOf(enabledPrefixes);
        for (CssPrefix prefix : enabledPrefixes) {
            this.setValue(prefix, true);
        }
    }

    @NotNull
    public Collection<CssPrefix> getEnabledPrefixes() {
        Collection<CssPrefix> collection = this.myEnabledPrefixes;
        if (collection == null) {
            CssPrefixInfo.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public void setValue(CssPrefix prefix, boolean value) {
        if (value) {
            this.myEnabledPrefixes.add(prefix);
        } else {
            this.myEnabledPrefixes.remove((Object)prefix);
        }
    }

    public boolean getValue(CssPrefix prefix) {
        return this.myEnabledPrefixes.contains((Object)prefix);
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myPropertyName;
        if (string == null) {
            CssPrefixInfo.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static CssPrefixInfo fromIntegerValue(String propertyName, int value) {
        if (value == -1) {
            return new CssPrefixInfo(propertyName, new CssPrefix[0]);
        }
        ArrayList<CssPrefix> enabledPrefixes = new ArrayList<CssPrefix>();
        for (CssPrefix prefix : CssPrefix.values()) {
            if (!BitUtil.isSet((int)value, (int)prefix.myIntMask)) continue;
            enabledPrefixes.add(prefix);
        }
        return new CssPrefixInfo(propertyName, enabledPrefixes);
    }

    public int toIntegerValue() {
        int result = 0;
        for (CssPrefix prefix : this.myEnabledPrefixes) {
            if (!this.getValue(prefix)) continue;
            result |= prefix.myIntMask;
        }
        return result;
    }

    public String toString() {
        return "CssPrefixInfo{myPropertyName='" + this.myPropertyName + "', myEnabledPrefixes=" + this.myEnabledPrefixes + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CssPrefixInfo that = (CssPrefixInfo)o;
        if (!this.myEnabledPrefixes.equals(that.myEnabledPrefixes)) {
            return false;
        }
        return this.myPropertyName.equals(that.myPropertyName);
    }

    public int hashCode() {
        int result = this.myPropertyName.hashCode();
        result = 31 * result + this.myEnabledPrefixes.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/configuration/CssPrefixInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/configuration/CssPrefixInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPrefixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

