/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.jetbrains.dotCommon.externalAppToolWindow.common.CursorMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.common.ResolutionFactory;
import com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers.WindowInputHandlersBundle;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameBufferStorageChannel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWidget;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.WindowTitle;
import com.jetbrains.rd.ide.model.BaseServerMessage;
import com.jetbrains.rd.ide.model.CloseWindow;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.FrameReceivedMessage;
import com.jetbrains.rd.ide.model.InitFramebufferMessage;
import com.jetbrains.rd.ide.model.NewCursorMessage;
import com.jetbrains.rd.ide.model.NewFrameMessage;
import com.jetbrains.rd.ide.model.ResizeWindowMessage;
import com.jetbrains.rd.ide.model.Resolution;
import com.jetbrains.rd.ide.model.WindowRootGotFocusMessage;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeStatus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.UUID;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.YieldKt;
import kotlinx.coroutines.channels.ClosedReceiveChannelException;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003Bk\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010%\u001a\u00020\u0015H\u0016J\u0006\u0010&\u001a\u00020\u0015J\u0012\u0010'\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010*\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010+\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010,\u001a\u00020\u00152\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010-\u001a\u00020\u0015H\u0016J\b\u0010.\u001a\u00020\u0015H\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u00020\u00152\u0006\u00100\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020\u00152\u0006\u00100\u001a\u000205H\u0002J\b\u00106\u001a\u00020\u0015H\u0002J\b\u00107\u001a\u00020\u0015H\u0016J\b\u00108\u001a\u00020\u0015H\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u001cH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ComponentListener;", "Lcom/intellij/openapi/Disposable;", "windowId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "windowTitle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "loadingPanel", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;", "frameBufferStorage", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "onWindowShownCallback", "Lkotlin/Function0;", "", "onWindowClosedCallback", "requestFocusEditor", "(Ljava/util/UUID;Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameBufferStorageChannel;Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "inputHandlersBundle", "Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/WindowInputHandlersBundle;", "isClosed", "", "getLoadingPanel", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/LoadingPanel;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "remoteWidget", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWidget;", "getWindowId", "()Ljava/util/UUID;", "addNotify", "close", "componentHidden", "e", "Ljava/awt/event/ComponentEvent;", "componentMoved", "componentResized", "componentShown", "dispose", "disposeInternal", "handleNewCursor", "msg", "Lcom/jetbrains/rd/ide/model/NewCursorMessage;", "handleNewFrame", "Lcom/jetbrains/rd/ide/model/NewFrameMessage;", "handleServerMessage", "Lcom/jetbrains/rd/ide/model/BaseServerMessage;", "launchRenderRoutine", "removeNotify", "sendResize", "toggleWidgetVisibility", "visible", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nRemoteWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteWindow.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,250:1\n13#2:251\n13#3:252\n*S KotlinDebug\n*F\n+ 1 RemoteWindow.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/ui/RemoteWindow\n*L\n47#1:251\n47#1:252\n*E\n"})
public final class RemoteWindow
extends JPanel
implements ComponentListener,
Disposable {
    @NotNull
    private final UUID windowId;
    @NotNull
    private final WindowTitle windowTitle;
    @NotNull
    private final LoadingPanel loadingPanel;
    @NotNull
    private final FrameBufferStorageChannel frameBufferStorage;
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final IRdDispatcher rdDispatcher;
    @NotNull
    private final Function0<Unit> onWindowShownCallback;
    @NotNull
    private final Function0<Unit> onWindowClosedCallback;
    @NotNull
    private final Function0<Unit> requestFocusEditor;
    private boolean isClosed;
    @Nullable
    private RemoteWidget remoteWidget;
    @NotNull
    private final WindowInputHandlersBundle inputHandlersBundle;
    @NotNull
    private final Logger logger;

    public RemoteWindow(@NotNull UUID windowId, @NotNull WindowTitle windowTitle, @NotNull LoadingPanel loadingPanel, @NotNull FrameBufferStorageChannel frameBufferStorage, @NotNull ExternalAppInputModel inputModel, @NotNull Lifetime lifetime, @NotNull IRdDispatcher rdDispatcher, @NotNull Function0<Unit> onWindowShownCallback, @NotNull Function0<Unit> onWindowClosedCallback, @NotNull Function0<Unit> requestFocusEditor) {
        Intrinsics.checkNotNullParameter((Object)windowId, (String)"windowId");
        Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
        Intrinsics.checkNotNullParameter((Object)loadingPanel, (String)"loadingPanel");
        Intrinsics.checkNotNullParameter((Object)frameBufferStorage, (String)"frameBufferStorage");
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        Intrinsics.checkNotNullParameter(onWindowShownCallback, (String)"onWindowShownCallback");
        Intrinsics.checkNotNullParameter(onWindowClosedCallback, (String)"onWindowClosedCallback");
        Intrinsics.checkNotNullParameter(requestFocusEditor, (String)"requestFocusEditor");
        this.windowId = windowId;
        this.windowTitle = windowTitle;
        this.loadingPanel = loadingPanel;
        this.frameBufferStorage = frameBufferStorage;
        this.inputModel = inputModel;
        this.lifetime = lifetime;
        this.rdDispatcher = rdDispatcher;
        this.onWindowShownCallback = onWindowShownCallback;
        this.onWindowClosedCallback = onWindowClosedCallback;
        this.requestFocusEditor = requestFocusEditor;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.isClosed = false;
        this.setOpaque(false);
        this.setBackground(JBColor.background());
        this.inputHandlersBundle = new WindowInputHandlersBundle(this.inputModel, this, this.rdDispatcher);
        this.frameBufferStorage.registerWindow(this.windowId);
        this.addComponentListener(this);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                if (remoteWidget != null) {
                    RemoteWidget remoteWidget = remoteWidget;
                    Intrinsics.checkNotNull((Object)((Object)remoteWidget));
                    remoteWidget.requestFocusInWindow();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.loadingPanel, "Center");
        this.toggleWidgetVisibility(false);
        this.inputModel.getServerMessage().advise(this.lifetime, (Function1)new Function1<BaseServerMessage, Unit>(){

            public final void invoke(@NotNull BaseServerMessage msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                this.handleServerMessage(msg);
            }
        });
        this.launchRenderRoutine();
    }

    @NotNull
    public final UUID getWindowId() {
        return this.windowId;
    }

    @NotNull
    public final LoadingPanel getLoadingPanel() {
        return this.loadingPanel;
    }

    private final void launchRenderRoutine() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ RemoteWindow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        frameChannel = RemoteWindow.access$getFrameBufferStorage$p(this.this$0).getFrameChannel(this.this$0.getWindowId());
lbl6:
                        // 5 sources

                        while (!frameChannel.isClosedForReceive()) {
                            this.L$0 = frameChannel;
                            this.label = 1;
                            v0 = frameChannel.receive((Continuation)this);
                            ** if (v0 != var4_2) goto lbl14
lbl13:
                            // 1 sources

                            return var4_2;
lbl14:
                            // 1 sources

                            ** GOTO lbl22
                        }
                        break;
                    }
                    case 1: {
                        frameChannel = (ReceiveChannel<Frame>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        frame = (Frame)v0;
                        if (!Intrinsics.areEqual((Object)RemoteWindow.access$getFrameBufferStorage$p(this.this$0).getCurrentOwner(), (Object)this.this$0.getWindowId())) ** GOTO lbl6
                        if (RemoteWindow.access$isClosed$p(this.this$0) || RemoteWindow.access$getFrameBufferStorage$p(this.this$0).isDisposed()) {
                            return Unit.INSTANCE;
                        }
                        RemoteWindow.access$getFrameBufferStorage$p(this.this$0).frameRead(this.this$0.getWindowId());
                        v1 = RemoteWindow.access$getRemoteWidget$p(this.this$0);
                        if (v1 != null) {
                            v1.scheduleFrame(frame);
                        }
                        this.L$0 = frameChannel;
                        this.label = 2;
                        v2 = YieldKt.yield((Continuation)((Continuation)this));
                        ** if (v2 != var4_2) goto lbl35
lbl34:
                        // 1 sources

                        return var4_2;
lbl35:
                        // 1 sources

                        ** GOTO lbl42
                    }
                    case 2: {
                        frameChannel = (ReceiveChannel)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl42:
                            // 2 sources

                            if (!Intrinsics.areEqual((Object)RemoteWindow.access$getFrameBufferStorage$p(this.this$0).getCurrentOwner(), (Object)this.this$0.getWindowId())) ** GOTO lbl6
                            RemoteWindow.access$getRdDispatcher$p(this.this$0).queue((Function0)new Function0<Unit>(this.this$0){
                                final /* synthetic */ RemoteWindow this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    RemoteWindow.access$getInputModel$p(this.this$0).getClientMessage().fire((Object)new FrameReceivedMessage());
                                }
                            });
                        }
                        catch (ClosedReceiveChannelException var3_5) {
                            RemoteWindow.access$getLogger$p(this.this$0).info(RemoteWindow.access$getWindowTitle$p(this.this$0) + " has been closed and frame channel has been finished");
                        }
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void disposeInternal() {
        this.frameBufferStorage.closeWindowChannel(this.windowId);
        this.removeComponentListener(this);
    }

    public void dispose() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.disposeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.isClosed = true;
            RemoteWidget remoteWidget = this.remoteWidget;
            if (remoteWidget != null) {
                remoteWidget.close();
            }
            this.disposeInternal();
        }
        finally {
            this.inputModel.getClientMessage().fire((Object)new CloseWindow());
        }
        this.logger.info(this.windowTitle + " has been closed");
    }

    private final void toggleWidgetVisibility(boolean visible) {
        RemoteWidget remoteWidget = this.remoteWidget;
        if (remoteWidget != null) {
            remoteWidget.setVisible(visible);
        }
        this.loadingPanel.setVisibility(!visible);
    }

    private final void handleNewFrame(NewFrameMessage msg) {
        if (msg.getRenderWidth() <= 0 || msg.getRenderHeight() <= 0) {
            this.frameBufferStorage.skipFrame();
            this.rdDispatcher.queue((Function0)new Function0<Unit>(this){
                final /* synthetic */ RemoteWindow this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    RemoteWindow.access$getInputModel$p(this.this$0).getClientMessage().fire((Object)new FrameReceivedMessage());
                }
            });
            return;
        }
        if (this.remoteWidget != null) {
            RemoteWidget remoteWidget = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget));
            if (!remoteWidget.isVisible()) {
                this.toggleWidgetVisibility(true);
                RemoteWidget remoteWidget2 = this.remoteWidget;
                Intrinsics.checkNotNull((Object)((Object)remoteWidget2));
                remoteWidget2.requestFocusInWindow();
            }
        }
        this.frameBufferStorage.nextFrameAvailable(msg);
    }

    private final void handleNewCursor(NewCursorMessage msg) {
        this.setCursor(Cursor.getPredefinedCursor(CursorMapper.Companion.mapCursorType(msg.getCursorType())));
    }

    private final void handleServerMessage(BaseServerMessage msg) {
        BaseServerMessage baseServerMessage = msg;
        if (baseServerMessage instanceof NewFrameMessage) {
            this.handleNewFrame((NewFrameMessage)msg);
        } else if (baseServerMessage instanceof InitFramebufferMessage) {
            this.frameBufferStorage.resize((InitFramebufferMessage)msg);
        } else if (baseServerMessage instanceof NewCursorMessage) {
            this.handleNewCursor((NewCursorMessage)msg);
        } else if (baseServerMessage instanceof WindowRootGotFocusMessage) {
            if (this.isFocusOwner()) {
                return;
            }
            this.requestFocusEditor.invoke();
        }
    }

    @Override
    public void addNotify() {
        if (this.lifetime.getStatus() != LifetimeStatus.Alive) {
            return;
        }
        RemoteWidget remoteWidget = this.remoteWidget = new RemoteWidget(this.inputModel, this.inputHandlersBundle, this.rdDispatcher);
        Intrinsics.checkNotNull((Object)((Object)remoteWidget));
        remoteWidget.attachTo(this);
        RemoteWidget remoteWidget2 = this.remoteWidget;
        Intrinsics.checkNotNull((Object)((Object)remoteWidget2));
        this.add((Component)((Object)remoteWidget2), "Center");
        this.frameBufferStorage.acquireOwnership(this.windowId);
        super.addNotify();
        this.toggleWidgetVisibility(false);
        this.sendResize();
        this.onWindowShownCallback.invoke();
        RemoteWidget remoteWidget3 = this.remoteWidget;
        Intrinsics.checkNotNull((Object)((Object)remoteWidget3));
        this.logger.info(this.windowTitle + " has been initialized. Used render API: " + remoteWidget3.getRenderApi());
    }

    @Override
    public void removeNotify() {
        if (this.remoteWidget != null) {
            RemoteWidget remoteWidget = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget));
            remoteWidget.setSize(0, 0);
            RemoteWidget remoteWidget2 = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget2));
            remoteWidget2.setVisible(false);
            RemoteWidget remoteWidget3 = this.remoteWidget;
            Intrinsics.checkNotNull((Object)((Object)remoteWidget3));
            remoteWidget3.dispose();
            this.remove((Component)((Object)this.remoteWidget));
            this.remoteWidget = null;
        }
        this.toggleWidgetVisibility(false);
        this.onWindowClosedCallback.invoke();
        super.removeNotify();
    }

    private final void sendResize() {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
        Resolution resolution = ResolutionFactory.Companion.create(n, n2, graphicsConfiguration);
        this.rdDispatcher.queue((Function0)new Function0<Unit>(this, resolution){
            final /* synthetic */ RemoteWindow this$0;
            final /* synthetic */ Resolution $resolution;
            {
                this.this$0 = $receiver;
                this.$resolution = $resolution;
                super(0);
            }

            public final void invoke() {
                RemoteWindow.access$getInputModel$p(this.this$0).getClientMessage().fire((Object)new ResizeWindowMessage(this.$resolution));
            }
        });
    }

    @Override
    public void componentResized(@Nullable ComponentEvent e) {
        this.loadingPanel.setSize(this.getWidth(), this.getHeight());
        RemoteWidget remoteWidget = this.remoteWidget;
        Intrinsics.checkNotNull((Object)((Object)remoteWidget));
        remoteWidget.setSize(this.getWidth(), this.getHeight());
        this.sendResize();
    }

    @Override
    public void componentMoved(@Nullable ComponentEvent e) {
    }

    @Override
    public void componentShown(@Nullable ComponentEvent e) {
    }

    @Override
    public void componentHidden(@Nullable ComponentEvent e) {
    }

    public static final /* synthetic */ FrameBufferStorageChannel access$getFrameBufferStorage$p(RemoteWindow $this) {
        return $this.frameBufferStorage;
    }

    public static final /* synthetic */ boolean access$isClosed$p(RemoteWindow $this) {
        return $this.isClosed;
    }

    public static final /* synthetic */ IRdDispatcher access$getRdDispatcher$p(RemoteWindow $this) {
        return $this.rdDispatcher;
    }

    public static final /* synthetic */ ExternalAppInputModel access$getInputModel$p(RemoteWindow $this) {
        return $this.inputModel;
    }

    public static final /* synthetic */ Logger access$getLogger$p(RemoteWindow $this) {
        return $this.logger;
    }

    public static final /* synthetic */ WindowTitle access$getWindowTitle$p(RemoteWindow $this) {
        return $this.windowTitle;
    }
}

