/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos;

import com.intellij.util.io.ByteBufferUtil;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.Frame;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameSize;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos.MacOsFrameMapper;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.macos.nativeLib.CLib;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0002R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrame;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/Frame;", "frameLocation", "", "frameSize", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "frameMapPtr", "Lcom/sun/jna/Pointer;", "frameMapper", "Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrameMapper;", "(Ljava/lang/String;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;Lcom/sun/jna/Pointer;Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/macos/MacOsFrameMapper;)V", "content", "Ljava/nio/ByteBuffer;", "getContent", "()Ljava/nio/ByteBuffer;", "frameContent", "size", "getSize", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/rendering/frameBuffer/FrameSize;", "close", "", "mapToNewLocation", "location", "renderSizeHasChanged", "newRenderWidth", "", "newRenderHeight", "unmap", "intellij.rider.plugins.dotCommon"})
public final class MacOsFrame
implements Frame {
    @NotNull
    private final String frameLocation;
    @NotNull
    private FrameSize frameSize;
    @NotNull
    private final Pointer frameMapPtr;
    @NotNull
    private final MacOsFrameMapper frameMapper;
    @NotNull
    private final ByteBuffer frameContent;

    public MacOsFrame(@NotNull String frameLocation, @NotNull FrameSize frameSize, @NotNull Pointer frameMapPtr, @NotNull MacOsFrameMapper frameMapper) {
        Intrinsics.checkNotNullParameter((Object)frameLocation, (String)"frameLocation");
        Intrinsics.checkNotNullParameter((Object)frameSize, (String)"frameSize");
        Intrinsics.checkNotNullParameter((Object)frameMapPtr, (String)"frameMapPtr");
        Intrinsics.checkNotNullParameter((Object)frameMapper, (String)"frameMapper");
        this.frameLocation = frameLocation;
        this.frameSize = frameSize;
        this.frameMapPtr = frameMapPtr;
        this.frameMapper = frameMapper;
        ByteBuffer byteBuffer = this.frameMapPtr.getByteBuffer(0L, (long)this.frameSize.getBufferSize());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"getByteBuffer(...)");
        this.frameContent = byteBuffer;
    }

    @Override
    @NotNull
    public FrameSize getSize() {
        return this.frameSize;
    }

    @Override
    @NotNull
    public ByteBuffer getContent() {
        return this.frameContent;
    }

    private final void unmap() {
        CLib.Companion.getINSTANCE().munmap(this.frameMapPtr, this.frameSize.getBufferSize());
        CLib.Companion.getINSTANCE().shm_unlink(this.frameLocation);
        ByteBufferUtil.cleanBuffer((ByteBuffer)this.frameContent);
    }

    @Override
    @NotNull
    public Frame mapToNewLocation(@NotNull String location, @NotNull FrameSize size) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.unmap();
        return this.frameMapper.mapFrame(location, size);
    }

    @Override
    public void renderSizeHasChanged(int newRenderWidth, int newRenderHeight) {
        this.frameSize = this.frameSize.withRenderSize(newRenderWidth, newRenderHeight);
    }

    @Override
    public void close() {
        this.unmap();
    }
}

