/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow;

import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.dotCommon.externalAppToolWindow.common.ObjectExtensionsKt;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowFile;
import com.jetbrains.dotCommon.externalAppToolWindow.remoteDocumentWindow.RemoteDocumentWindowInternals;
import com.jetbrains.dotCommon.externalAppToolWindow.rendering.frameBuffer.FrameBufferStorageChannel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.LoadingPanel;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.rd.ide.model.RiderWindowState;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalIgnoreDependencyViolation
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "openedWindows", "", "Ljava/util/UUID;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/remoteDocumentWindow/RemoteDocumentWindowInternals;", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "closeFile", "", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.rider.plugins.dotCommon"})
public final class RemoteDocumentWindowProvider
implements FileEditorProvider,
DumbAware {
    @NotNull
    private final Map<UUID, RemoteDocumentWindowInternals> openedWindows = new LinkedHashMap();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof RemoteDocumentWindowFile;
    }

    private final void closeFile(VirtualFile file, Project project) {
        FileEditorManagerEx fileManager = FileEditorManagerEx.Companion.getInstanceEx(project);
        for (EditorWindow editorWindow : fileManager.getWindows()) {
            FileEditorManagerEx.Companion.getInstanceEx(project).closeFile(file, editorWindow);
        }
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        RemoteDocumentWindowFile remoteDocWindowFile = (RemoteDocumentWindowFile)file;
        LifetimeDefinition docWindowLifetimeDef = remoteDocWindowFile.getWindowLifetimeDef();
        if (this.openedWindows.containsKey(remoteDocWindowFile.getWindowId())) {
            boolean isReopen = ObjectExtensionsKt.falseIfNull((Boolean)remoteDocWindowFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN));
            if (!isReopen) {
                remoteDocWindowFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, true);
                this.closeFile(file, project);
                remoteDocWindowFile.putUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN, null);
            }
            RemoteDocumentWindowInternals windowInternals = (RemoteDocumentWindowInternals)MapsKt.getValue(this.openedWindows, (Object)remoteDocWindowFile.getWindowId());
            return new RemoteDocumentWindow(windowInternals.getRemoteWindow(), remoteDocWindowFile, this.openedWindows, windowInternals.getFileLifetimeDef());
        }
        FrameBufferStorageChannel framebufferStorage = new FrameBufferStorageChannel(2);
        LoadingPanel loadingPanel = new LoadingPanel(new Dimension(0, 0), docWindowLifetimeDef.getLifetime());
        RemoteWindow remoteWindow2 = new RemoteWindow(remoteDocWindowFile.getWindowId(), remoteDocWindowFile.getWindowTitle(), loadingPanel, framebufferStorage, remoteDocWindowFile.getInputModel(), docWindowLifetimeDef.getLifetime(), remoteDocWindowFile.getDispatcher(), remoteDocWindowFile.getOnWindowShownCallback(), remoteDocWindowFile.getOnWindowClosedCallback(), (Function0<Unit>)((Function0)new Function0<Unit>(project, file){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;
            {
                this.$project = $project;
                this.$file = $file;
                super(0);
            }

            public final void invoke() {
                FileEditorManager.getInstance((Project)this.$project).openFile(this.$file, true);
            }
        }));
        this.openedWindows.put(remoteDocWindowFile.getWindowId(), new RemoteDocumentWindowInternals(remoteWindow2, docWindowLifetimeDef));
        remoteDocWindowFile.getInputModel().getWindowState().advise(docWindowLifetimeDef.getLifetime(), (Function1)new Function1<RiderWindowState, Unit>(docWindowLifetimeDef, file, this, remoteDocWindowFile, project){
            final /* synthetic */ LifetimeDefinition $docWindowLifetimeDef;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ RemoteDocumentWindowProvider this$0;
            final /* synthetic */ RemoteDocumentWindowFile $remoteDocWindowFile;
            final /* synthetic */ Project $project;
            {
                this.$docWindowLifetimeDef = $docWindowLifetimeDef;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$remoteDocWindowFile = $remoteDocWindowFile;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull RiderWindowState windowState) {
                Intrinsics.checkNotNullParameter((Object)windowState, (String)"windowState");
                windowState.getWindowTitle().advise(this.$docWindowLifetimeDef.getLifetime(), (Function1)new Function1<String, Unit>(this.$file, this.this$0){
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ RemoteDocumentWindowProvider this$0;
                    {
                        this.$file = $file;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$file.rename((Object)this.this$0, it);
                    }
                });
                windowState.getWindowIcon().advise(this.$docWindowLifetimeDef.getLifetime(), (Function1)new Function1<String, Unit>(this.$remoteDocWindowFile){
                    final /* synthetic */ RemoteDocumentWindowFile $remoteDocWindowFile;
                    {
                        this.$remoteDocWindowFile = $remoteDocWindowFile;
                        super(1);
                    }

                    public final void invoke(@Nullable String it) {
                        this.$remoteDocWindowFile.updateIcon(it);
                    }
                });
                windowState.getClose().advise(this.$docWindowLifetimeDef.getLifetime(), (Function1)new Function1<Unit, Unit>(this.$docWindowLifetimeDef){
                    final /* synthetic */ LifetimeDefinition $docWindowLifetimeDef;
                    {
                        this.$docWindowLifetimeDef = $docWindowLifetimeDef;
                        super(1);
                    }

                    public final void invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$docWindowLifetimeDef.terminate(true);
                    }
                });
                windowState.getFocusInIde().advise(this.$docWindowLifetimeDef.getLifetime(), (Function1)new Function1<Unit, Unit>(this.$project, this.$remoteDocWindowFile){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RemoteDocumentWindowFile $remoteDocWindowFile;
                    {
                        this.$project = $project;
                        this.$remoteDocWindowFile = $remoteDocWindowFile;
                        super(1);
                    }

                    public final void invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        FileEditorManagerEx.Companion.getInstanceEx(this.$project).openFile((VirtualFile)this.$remoteDocWindowFile, true, true);
                    }
                });
            }
        });
        docWindowLifetimeDef.onTermination((Function0)new Function0<Unit>(this, file, project, framebufferStorage){
            final /* synthetic */ RemoteDocumentWindowProvider this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ FrameBufferStorageChannel $framebufferStorage;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$project = $project;
                this.$framebufferStorage = $framebufferStorage;
                super(0);
            }

            public final void invoke() {
                RemoteDocumentWindowProvider.access$closeFile(this.this$0, this.$file, this.$project);
                this.$framebufferStorage.dispose();
            }
        });
        return new RemoteDocumentWindow(remoteWindow2, remoteDocWindowFile, this.openedWindows, docWindowLifetimeDef);
    }

    @NotNull
    public String getEditorTypeId() {
        return "remote-document-window-provider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    public static final /* synthetic */ void access$closeFile(RemoteDocumentWindowProvider $this, VirtualFile file, Project project) {
        $this.closeFile(file, project);
    }
}

