/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers;

import com.jetbrains.dotCommon.externalAppToolWindow.common.KeyUtils;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.InputModifiers;
import com.jetbrains.rd.ide.model.ScrollEventMessage;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/RemoteWidgetMouseWheelListener;", "Ljava/awt/event/MouseWheelListener;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "(Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;)V", "lastDragTime", "", "isThrottled", "", "mouseWheelMoved", "", "e", "Ljava/awt/event/MouseWheelEvent;", "intellij.rider.plugins.dotCommon"})
public final class RemoteWidgetMouseWheelListener
implements MouseWheelListener {
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final IRdDispatcher rdDispatcher;
    private long lastDragTime;

    public RemoteWidgetMouseWheelListener(@NotNull ExternalAppInputModel inputModel, @NotNull IRdDispatcher rdDispatcher) {
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        this.inputModel = inputModel;
        this.rdDispatcher = rdDispatcher;
    }

    private final boolean isThrottled() {
        long now = System.nanoTime() / (long)1000000;
        long elapsed = now - this.lastDragTime;
        this.lastDragTime = now;
        return elapsed < 10L;
    }

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getWheelRotation() == 0 || this.isThrottled()) {
            return;
        }
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
        Point pos = point;
        int scrollDelta = e.getWheelRotation() * -1;
        int deltaX = 0;
        int deltaY = 0;
        if (e.isShiftDown()) {
            deltaX = scrollDelta;
        } else {
            deltaY = scrollDelta;
        }
        ArrayList<InputModifiers> modifiers = KeyUtils.Companion.getModifiers(e);
        ScrollEventMessage msg = new ScrollEventMessage(pos.x, pos.y, deltaX, deltaY, (List)modifiers);
        this.rdDispatcher.queue((Function0)new Function0<Unit>(this, msg){
            final /* synthetic */ RemoteWidgetMouseWheelListener this$0;
            final /* synthetic */ ScrollEventMessage $msg;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                super(0);
            }

            public final void invoke() {
                RemoteWidgetMouseWheelListener.access$getInputModel$p(this.this$0).getInputMessage().fire((Object)this.$msg);
            }
        });
    }

    public static final /* synthetic */ ExternalAppInputModel access$getInputModel$p(RemoteWidgetMouseWheelListener $this) {
        return $this.inputModel;
    }
}

