/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers;

import com.jetbrains.dotCommon.externalAppToolWindow.common.KeyUtils;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.InputModifiers;
import com.jetbrains.rd.ide.model.PointerMovedEventMessage;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/RemoteWidgetMouseMotionAdapter;", "Ljava/awt/event/MouseMotionAdapter;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "(Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;)V", "lastDragTime", "", "lastMoveTime", "handleMouseMove", "", "e", "Ljava/awt/event/MouseEvent;", "isMoveThrottled", "", "isThrottled", "mouseDragged", "mouseMoved", "intellij.rider.plugins.dotCommon"})
public final class RemoteWidgetMouseMotionAdapter
extends MouseMotionAdapter {
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final IRdDispatcher rdDispatcher;
    private long lastMoveTime;
    private long lastDragTime;

    public RemoteWidgetMouseMotionAdapter(@NotNull ExternalAppInputModel inputModel, @NotNull IRdDispatcher rdDispatcher) {
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        this.inputModel = inputModel;
        this.rdDispatcher = rdDispatcher;
    }

    private final void handleMouseMove(MouseEvent e) {
        Point cursorPos = e.getPoint();
        ArrayList<InputModifiers> modifiers = KeyUtils.Companion.getModifiers(e);
        PointerMovedEventMessage msg = new PointerMovedEventMessage(cursorPos.x, cursorPos.y, (List)modifiers);
        this.rdDispatcher.queue((Function0)new Function0<Unit>(this, msg){
            final /* synthetic */ RemoteWidgetMouseMotionAdapter this$0;
            final /* synthetic */ PointerMovedEventMessage $msg;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                super(0);
            }

            public final void invoke() {
                RemoteWidgetMouseMotionAdapter.access$getInputModel$p(this.this$0).getInputMessage().fire((Object)this.$msg);
            }
        });
    }

    private final boolean isThrottled() {
        long now = System.nanoTime() / (long)1000000;
        long elapsed = now - this.lastDragTime;
        this.lastDragTime = now;
        return elapsed < 10L;
    }

    private final boolean isMoveThrottled() {
        long now = System.nanoTime() / (long)1000000;
        long elapsed = now - this.lastMoveTime;
        this.lastMoveTime = now;
        return elapsed < 8L;
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isMoveThrottled()) {
            return;
        }
        this.handleMouseMove(e);
        super.mouseMoved(e);
    }

    @Override
    public void mouseDragged(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isThrottled()) {
            return;
        }
        this.handleMouseMove(e);
        super.mouseDragged(e);
    }

    public static final /* synthetic */ ExternalAppInputModel access$getInputModel$p(RemoteWidgetMouseMotionAdapter $this) {
        return $this.inputModel;
    }
}

