/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.inputHandlers;

import com.jetbrains.dotCommon.externalAppToolWindow.common.KeyUtils;
import com.jetbrains.rd.ide.model.ExternalAppInputModel;
import com.jetbrains.rd.ide.model.InputModifiers;
import com.jetbrains.rd.ide.model.MouseButton;
import com.jetbrains.rd.ide.model.PointerLeaveMessage;
import com.jetbrains.rd.ide.model.PointerPressedEventMessage;
import com.jetbrains.rd.ide.model.PointerReleasedEventMessage;
import com.jetbrains.rd.platform.protocol.IRdDispatcher;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/RemoteWidgetMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "inputModel", "Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;", "rdDispatcher", "Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;", "(Lcom/jetbrains/rd/ide/model/ExternalAppInputModel;Lcom/jetbrains/rd/platform/protocol/IRdDispatcher;)V", "mouseEntered", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "Companion", "intellij.rider.plugins.dotCommon"})
public final class RemoteWidgetMouseAdapter
extends MouseAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExternalAppInputModel inputModel;
    @NotNull
    private final IRdDispatcher rdDispatcher;
    @NotNull
    private static final ArrayList<InputModifiers> emptyModifiers = new ArrayList();

    public RemoteWidgetMouseAdapter(@NotNull ExternalAppInputModel inputModel, @NotNull IRdDispatcher rdDispatcher) {
        Intrinsics.checkNotNullParameter((Object)inputModel, (String)"inputModel");
        Intrinsics.checkNotNullParameter((Object)rdDispatcher, (String)"rdDispatcher");
        this.inputModel = inputModel;
        this.rdDispatcher = rdDispatcher;
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point pos = e.getPoint();
        int btn = e.getButton();
        ArrayList<InputModifiers> modifiers = KeyUtils.Companion.getModifiers(e);
        PointerPressedEventMessage msg = new PointerPressedEventMessage(pos.x, pos.y, RemoteWidgetMouseAdapter.Companion.convertMouseButton(btn), (List)modifiers);
        this.rdDispatcher.queue((Function0)new Function0<Unit>(this, msg){
            final /* synthetic */ RemoteWidgetMouseAdapter this$0;
            final /* synthetic */ PointerPressedEventMessage $msg;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                super(0);
            }

            public final void invoke() {
                RemoteWidgetMouseAdapter.access$getInputModel$p(this.this$0).getInputMessage().fire((Object)this.$msg);
            }
        });
        super.mousePressed(e);
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Point pos = e.getPoint();
        int btn = e.getButton();
        ArrayList<InputModifiers> modifiers = KeyUtils.Companion.getModifiers(e);
        MouseButton clientMouseButton = RemoteWidgetMouseAdapter.Companion.convertMouseButton(btn);
        PointerReleasedEventMessage msg = new PointerReleasedEventMessage(pos.x, pos.y, clientMouseButton, (List)modifiers);
        this.rdDispatcher.queue((Function0)new Function0<Unit>(this, msg){
            final /* synthetic */ RemoteWidgetMouseAdapter this$0;
            final /* synthetic */ PointerReleasedEventMessage $msg;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                super(0);
            }

            public final void invoke() {
                RemoteWidgetMouseAdapter.access$getInputModel$p(this.this$0).getInputMessage().fire((Object)this.$msg);
            }
        });
        super.mouseReleased(e);
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.mouseEntered(e);
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PointerLeaveMessage msg = new PointerLeaveMessage((List)emptyModifiers);
        this.rdDispatcher.queue((Function0)new Function0<Unit>(this, msg){
            final /* synthetic */ RemoteWidgetMouseAdapter this$0;
            final /* synthetic */ PointerLeaveMessage $msg;
            {
                this.this$0 = $receiver;
                this.$msg = $msg;
                super(0);
            }

            public final void invoke() {
                RemoteWidgetMouseAdapter.access$getInputModel$p(this.this$0).getInputMessage().fire((Object)this.$msg);
            }
        });
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.mouseMoved(e);
    }

    public static final /* synthetic */ ExternalAppInputModel access$getInputModel$p(RemoteWidgetMouseAdapter $this) {
        return $this.inputModel;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/inputHandlers/RemoteWidgetMouseAdapter$Companion;", "", "()V", "emptyModifiers", "Ljava/util/ArrayList;", "Lcom/jetbrains/rd/ide/model/InputModifiers;", "Lkotlin/collections/ArrayList;", "getEmptyModifiers", "()Ljava/util/ArrayList;", "convertMouseButton", "Lcom/jetbrains/rd/ide/model/MouseButton;", "swingButton", "", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<InputModifiers> getEmptyModifiers() {
            return emptyModifiers;
        }

        private final MouseButton convertMouseButton(int swingButton) {
            return switch (swingButton) {
                case 1 -> MouseButton.Left;
                case 2 -> MouseButton.Middle;
                case 3 -> MouseButton.Right;
                default -> MouseButton.None;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

