/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.common;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.ide.model.Resolution;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/common/ResolutionFactory;", "", "()V", "Companion", "intellij.rider.plugins.dotCommon"})
public final class ResolutionFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/common/ResolutionFactory$Companion;", "", "()V", "create", "Lcom/jetbrains/rd/ide/model/Resolution;", "width", "", "height", "graphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "getRenderResolution", "Lkotlin/Pair;", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        private final Pair<Integer, Integer> getRenderResolution() {
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int width = 1;
            int height = 1;
            Intrinsics.checkNotNull((Object)devices);
            for (GraphicsDevice screenDevice : devices) {
                width = Math.max(width, screenDevice.getDisplayMode().getWidth());
                height = Math.max(height, screenDevice.getDisplayMode().getHeight());
            }
            return new Pair((Object)width, (Object)height);
        }

        @NotNull
        public final Resolution create(int width, int height, @NotNull GraphicsConfiguration graphicsConfiguration) {
            Intrinsics.checkNotNullParameter((Object)graphicsConfiguration, (String)"graphicsConfiguration");
            int width2 = Math.max(width, 1);
            int height2 = Math.max(height, 1);
            Pair renderResolution = this.getRenderResolution();
            double scaleFactor = graphicsConfiguration.getDefaultTransform().getScaleX();
            if (SystemInfo.isMac) {
                int scaledRenderWidth = (int)(((Number)renderResolution.getFirst()).doubleValue() * scaleFactor);
                int scaledRenderHeight = (int)(((Number)renderResolution.getSecond()).doubleValue() * scaleFactor);
                renderResolution = new Pair((Object)scaledRenderWidth, (Object)scaledRenderHeight);
            }
            int scaledWidth = (int)((double)width2 * scaleFactor);
            int scaledHeight = (int)((double)height2 * scaleFactor);
            if (((Number)renderResolution.getFirst()).intValue() < scaledWidth || ((Number)renderResolution.getSecond()).intValue() < scaledHeight) {
                scaledWidth = Math.max(((Number)renderResolution.getFirst()).intValue(), scaledWidth);
                scaledHeight = Math.max(((Number)renderResolution.getSecond()).intValue(), scaledHeight);
                return new Resolution(width2, height2, scaledWidth, scaledHeight, scaleFactor);
            }
            return new Resolution(width2, height2, ((Number)renderResolution.getFirst()).intValue(), ((Number)renderResolution.getSecond()).intValue(), scaleFactor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

