/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.common;

import com.jetbrains.dotCommon.externalAppToolWindow.common.MathEx;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\tR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/common/Rect;", "", "x", "", "y", "width", "height", "(IIII)V", "getHeight", "()I", "getWidth", "x1", "getX1", "x2", "getX2", "y1", "getY1", "y2", "getY2", "Union", "rect", "boundToSize", "Companion", "intellij.rider.plugins.dotCommon"})
@SourceDebugExtension(value={"SMAP\nRect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rect.kt\ncom/jetbrains/dotCommon/externalAppToolWindow/common/Rect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class Rect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int x1;
    private final int y1;
    private final int x2;
    private final int y2;
    private final int width;
    private final int height;
    @NotNull
    private static final Rect Zero = new Rect(0, 0, 0, 0);

    public Rect(int x, int y, int width, int height) {
        if (!(width >= 0)) {
            boolean $i$a$-require-Rect$32 = false;
            String $i$a$-require-Rect$32 = "Width should be a non-negative value";
            throw new IllegalArgumentException($i$a$-require-Rect$32.toString());
        }
        if (!(height >= 0)) {
            boolean bl = false;
            String string = "Height should be a non-negative value";
            throw new IllegalArgumentException(string.toString());
        }
        this.x1 = x;
        this.y1 = y;
        this.x2 = x + width;
        this.y2 = y + height;
        this.width = width;
        this.height = height;
    }

    public final int getX1() {
        return this.x1;
    }

    public final int getY1() {
        return this.y1;
    }

    public final int getX2() {
        return this.x2;
    }

    public final int getY2() {
        return this.y2;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Rect Union(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        int uX1 = Math.min(this.x1, rect.x1);
        int uY1 = Math.min(this.y1, rect.y1);
        int uX2 = Math.max(this.x2, rect.x2);
        int uY2 = Math.max(this.y2, rect.y2);
        return new Rect(uX1, uY1, uX2 - uX1, uY2 - uY1);
    }

    @NotNull
    public final Rect boundToSize(int width, int height) {
        if (!(width >= 0)) {
            boolean $i$a$-require-Rect$boundToSize$32 = false;
            String $i$a$-require-Rect$boundToSize$32 = "Width should be a non-negative value";
            throw new IllegalArgumentException($i$a$-require-Rect$boundToSize$32.toString());
        }
        if (!(height >= 0)) {
            boolean $i$a$-require-Rect$boundToSize$42 = false;
            String $i$a$-require-Rect$boundToSize$42 = "Height should be a non-negative value";
            throw new IllegalArgumentException($i$a$-require-Rect$boundToSize$42.toString());
        }
        int x1 = MathEx.INSTANCE.clamp(this.x1, 0, width);
        int y1 = MathEx.INSTANCE.clamp(this.y1, 0, height);
        int x2 = MathEx.INSTANCE.clamp(x1 + this.width, 0, width);
        int y2 = MathEx.INSTANCE.clamp(x1 + this.height, 0, height);
        return new Rect(x1, y1, x2 - x1, y2 - y1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/common/Rect$Companion;", "", "()V", "Zero", "Lcom/jetbrains/dotCommon/externalAppToolWindow/common/Rect;", "getZero", "()Lcom/jetbrains/dotCommon/externalAppToolWindow/common/Rect;", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Rect getZero() {
            return Zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

