/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.common;

import com.jetbrains.rd.ide.model.CursorType;
import java.awt.Cursor;
import java.util.EnumMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/common/CursorMapper;", "", "()V", "Companion", "intellij.rider.plugins.dotCommon"})
public final class CursorMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<CursorType, Integer> cursorMap;

    static {
        int defaultCursor = Cursor.getDefaultCursor().getType();
        cursorMap = new EnumMap(CursorType.class);
        Integer n = defaultCursor;
        cursorMap.put(CursorType.Arrow, n);
        cursorMap.put(CursorType.Ibeam, 2);
        cursorMap.put(CursorType.Wait, 3);
        cursorMap.put(CursorType.Cross, 1);
        cursorMap.put(CursorType.UpArrow, 8);
        cursorMap.put(CursorType.SizeWestEast, 10);
        cursorMap.put(CursorType.SizeNorthSouth, 8);
        cursorMap.put(CursorType.SizeAll, 13);
        n = defaultCursor;
        cursorMap.put(CursorType.No, n);
        cursorMap.put(CursorType.Hand, 12);
        n = defaultCursor;
        cursorMap.put(CursorType.AppStarting, n);
        n = defaultCursor;
        cursorMap.put(CursorType.Help, n);
        cursorMap.put(CursorType.TopSide, 8);
        cursorMap.put(CursorType.BottomSide, 8);
        cursorMap.put(CursorType.LeftSide, 10);
        cursorMap.put(CursorType.RightSide, 10);
        cursorMap.put(CursorType.TopLeftCorner, 6);
        cursorMap.put(CursorType.TopRightCorner, 7);
        cursorMap.put(CursorType.BottomLeftCorner, 7);
        cursorMap.put(CursorType.BottomRightCorner, 6);
        n = defaultCursor;
        cursorMap.put(CursorType.DragMove, n);
        n = defaultCursor;
        cursorMap.put(CursorType.DragCopy, n);
        n = defaultCursor;
        cursorMap.put(CursorType.DragLink, n);
        n = defaultCursor;
        cursorMap.put(CursorType.None, n);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/common/CursorMapper$Companion;", "", "()V", "cursorMap", "", "Lcom/jetbrains/rd/ide/model/CursorType;", "", "mapCursorType", "cursorType", "intellij.rider.plugins.dotCommon"})
    public static final class Companion {
        private Companion() {
        }

        public final int mapCursorType(@NotNull CursorType cursorType) {
            int n;
            Intrinsics.checkNotNullParameter((Object)cursorType, (String)"cursorType");
            if (!cursorMap.containsKey(cursorType)) {
                n = Cursor.getDefaultCursor().getType();
            } else {
                Object v = cursorMap.get(cursorType);
                Intrinsics.checkNotNull(v);
                n = ((Number)v).intValue();
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

