/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.ActionDataContextConstants;
import com.jetbrains.rd.ide.model.ContextMenuValue;
import com.jetbrains.rd.ide.model.IntContextVal;
import com.jetbrains.rd.ide.model.RiderAction;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ \u0010\u0011\u001a\u0004\u0018\u0001H\u0012\"\u0006\b\u0001\u0010\u0012\u0018\u00012\u0006\u0010\u0013\u001a\u00020\u000fH\u0086\b\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u000fH\u0016J!\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0001\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u0002H\u0012\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/actions/RemoteActionDataContext;", "TAppModel", "Lcom/intellij/openapi/actionSystem/DataContext;", "riderAction", "Lcom/jetbrains/rd/ide/model/RiderAction;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "appModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/ide/model/RiderAction;Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "map", "", "", "", "get", "T", "dataId", "(Ljava/lang/String;)Ljava/lang/Object;", "getData", "put", "", "data", "(Ljava/lang/String;Ljava/lang/Object;)V", "intellij.rider.plugins.dotCommon"})
public final class RemoteActionDataContext<TAppModel>
implements DataContext {
    @NotNull
    private final Map<String, Object> map;

    public RemoteActionDataContext(@NotNull RiderAction riderAction, @NotNull ToolWindow toolWindow, @NotNull Project project, TAppModel appModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)riderAction, (String)"riderAction");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.map = new HashMap();
        if (appModel == null) {
            throw new IllegalArgumentException("AppModel parameter should not be null");
        }
        for (IntContextVal intContextVal : riderAction.getIntContextValues()) {
            this.map.put(intContextVal.getId(), intContextVal.getValue());
        }
        for (IntContextVal intContextVal : riderAction.getStringContextValues()) {
            this.map.put(intContextVal.getId(), intContextVal.getValue());
        }
        for (IntContextVal intContextVal : riderAction.getBooleanContextValues()) {
            this.map.put(intContextVal.getId(), intContextVal.getValue());
        }
        if (riderAction.getContextMenuValues() != null) {
            ContextMenuValue contextMenuValue = riderAction.getContextMenuValues();
            Intrinsics.checkNotNull((Object)contextMenuValue);
            String string = contextMenuValue.getId();
            ContextMenuValue contextMenuValue2 = riderAction.getContextMenuValues();
            Intrinsics.checkNotNull((Object)contextMenuValue2);
            this.map.put(string, contextMenuValue2.getValue());
        }
        this.map.put(CommonDataKeys.PROJECT.getName(), project);
        this.map.put(ActionDataContextConstants.Companion.getRiderAppModel(), appModel);
        this.map.put(ActionDataContextConstants.Companion.getProcessLifetime(), lifetime);
        this.map.put(ActionDataContextConstants.Companion.getToolWindow(), toolWindow);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (!this.map.containsKey(dataId)) {
            return null;
        }
        return this.map.get(dataId);
    }

    public final <T> void put(@NotNull String dataId, T data) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (data == null) {
            throw new IllegalArgumentException("Data parameter should not be null");
        }
        this.map.put(dataId, data);
    }

    public final /* synthetic */ <T> T get(String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        boolean $i$f$get = false;
        Object data = this.getData(dataId);
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (data instanceof Object) {
            return (T)data;
        }
        return null;
    }
}

