/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dotCommon.externalAppToolWindow.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.WindowManager;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.ActionDataContextConstants;
import com.jetbrains.dotCommon.externalAppToolWindow.actions.RemoteActionDataContext;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.RemoteWindow;
import com.jetbrains.rd.platform.util.DataContextKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Container;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016JA\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dotCommon/externalAppToolWindow/actions/BaseRemoteAction;", "TAppModel", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "windowId", "Ljava/util/UUID;", "Lcom/jetbrains/rd/util/UUID;", "model", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "processLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Ljava/util/UUID;Ljava/lang/Object;Lcom/intellij/openapi/wm/ToolWindow;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "tryFindWindowId", "component", "Ljava/awt/Component;", "update", "intellij.rider.plugins.dotCommon"})
public abstract class BaseRemoteAction<TAppModel>
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setVisible(false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final UUID tryFindWindowId(Component component) {
        Component currentComponent = component;
        while (currentComponent != null) {
            if (currentComponent instanceof RemoteWindow) {
                return ((RemoteWindow)currentComponent).getWindowId();
            }
            Container container = currentComponent.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
            currentComponent = container;
        }
        return null;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!(e.getDataContext() instanceof RemoteActionDataContext)) {
            return;
        }
        Object appModel = e.getDataContext().getData(DataKey.Companion.create(ActionDataContextConstants.Companion.getRiderAppModel()));
        ToolWindow toolWindow = (ToolWindow)e.getDataContext().getData(DataKey.Companion.create(ActionDataContextConstants.Companion.getToolWindow()));
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Project project = DataContextKt.getProject((DataContext)dataContext);
        Lifetime lifetime = (Lifetime)e.getDataContext().getData(DataKey.Companion.create(ActionDataContextConstants.Companion.getProcessLifetime()));
        Component component = WindowManager.getInstance().getFocusedComponent(project);
        if (component == null) {
            return;
        }
        Component component2 = component;
        UUID uUID = this.tryFindWindowId(component2);
        if (uUID == null) {
            return;
        }
        UUID windowId = uUID;
        if (appModel == null || project == null || lifetime == null || toolWindow == null) {
            return;
        }
        this.actionPerformed(e, windowId, appModel, toolWindow, project, lifetime);
    }

    protected abstract void actionPerformed(@NotNull AnActionEvent var1, @NotNull UUID var2, TAppModel var3, @NotNull ToolWindow var4, @NotNull Project var5, @NotNull Lifetime var6);
}

