/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.LocalTimeCounter;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.ide.model.CompletionItemType;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.cpp.fileType.CppSourceFileType;
import com.jetbrains.rider.editors.sandboxes.SandboxManager;
import com.jetbrains.rider.model.SandboxInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0002\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/cpp/debugger/RiderCppDebuggerEditorsProvider;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "()V", "createDocument", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "text", "Lcom/intellij/xdebugger/XExpression;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "mode", "Lcom/intellij/xdebugger/evaluation/EvaluationMode;", "escapeFilename", "", "filename", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getInlineDebuggerHelper", "Lcom/intellij/xdebugger/evaluation/InlineDebuggerHelper;", "toSandboxSource", "Lcom/jetbrains/rider/model/SandboxInfo;", "position", "intellij.rider.plugins.cpp.debugger"})
public final class RiderCppDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        return (FileType)CppSourceFileType.INSTANCE;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Document createdDocument = this.createDocument(text, project);
        if (sourcePosition != null) {
            SandboxManager.Companion.getInstance().markAsSandbox(createdDocument, (AbstractSandboxInfo)this.toSandboxSource(sourcePosition));
        }
        return createdDocument;
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        return new InlineDebuggerHelper(){

            public boolean shouldEvaluateChildrenByDefault(@Nullable XNamedTreeNode node) {
                return false;
            }
        };
    }

    private final Document createDocument(XExpression text, Project project) {
        Document createdDocument;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        long stamp = LocalTimeCounter.currentTime();
        PsiFile psiFile = factory.createFileFromText("dummy." + this.getFileType().getDefaultExtension(), this.getFileType(), (CharSequence)text.getExpression(), stamp, true, false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"createFileFromText(...)");
        PsiFile psiFile2 = psiFile;
        Document document2 = createdDocument = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile2);
        if (document2 == null) {
            throw new IllegalStateException("Failed to create document");
        }
        return document2;
    }

    private final void escapeFilename(String filename, StringBuilder builder) {
        int n = filename.length();
        for (int i = 0; i < n; ++i) {
            char c = filename.charAt(i);
            char codeUnit = c;
            boolean bl = ' ' <= codeUnit ? codeUnit < '~' : false;
            if (bl && c != '*') {
                builder.append(c);
                continue;
            }
            builder.append("*");
            builder.append(StringsKt.padStart((String)String.valueOf((int)codeUnit), (int)5, (char)'0'));
        }
    }

    private final SandboxInfo toSandboxSource(XSourcePosition position) {
        StringBuilder builder = new StringBuilder();
        builder.append("// ");
        String string = position.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.escapeFilename(string, builder);
        builder.append("\n// ");
        builder.append(position.getOffset());
        builder.append("\n{;}");
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String fullText = string2;
        RdTextRange rdTextRange = new RdTextRange(fullText.length() - 2, fullText.length() - 2);
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.listOf((Object)CompletionItemType.TemplateItem);
        RdLanguage rdLanguage = ProtocolLanguageManagerKt.toRdLanguageOrThrow((Language)((Language)CppLanguage.INSTANCE));
        List list3 = CollectionsKt.emptyList();
        return new SandboxInfo("RiderCppDebuggerEditor", null, fullText, rdTextRange, true, null, list, true, list2, rdLanguage, false, null, true, list3);
    }
}

