/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.toolWindow.log;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unreal.filters.linkInfo.BlueprintClassHyperLinkInfo;
import com.jetbrains.rider.plugins.unreal.filters.linkInfo.MethodReferenceHyperLinkInfo;
import com.jetbrains.rider.plugins.unreal.filters.linkInfo.UnrealClassHyperLinkInfo;
import com.jetbrains.rider.plugins.unreal.model.BlueprintReference;
import com.jetbrains.rider.plugins.unreal.model.FString;
import com.jetbrains.rider.plugins.unreal.model.LogMessageInfo;
import com.jetbrains.rider.plugins.unreal.model.StringRange;
import com.jetbrains.rider.plugins.unreal.model.UClass;
import com.jetbrains.rider.plugins.unreal.model.UnrealLogEvent;
import com.jetbrains.rider.plugins.unreal.model.VerbosityType;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.MethodReference;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.RdRiderModel;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.RdRiderModel_PregeneratedKt;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogCategoryFilterComboBox;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogConsoleViewContentType;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogFilter;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogPanelSettings;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogSettingsActionGroup;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogVerbosityFilterComboBox;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0002J\u0006\u0010\"\u001a\u00020 J\b\u0010#\u001a\u00020 H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020 2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010)\u001a\u00020\u0012H\u0002J\u0018\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020%H\u0002J\u001a\u00100\u001a\u00020 2\b\b\u0002\u00101\u001a\u0002022\u0006\u0010/\u001a\u00020%H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "tabModel", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "categoryFilterActionGroup", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogCategoryFilterComboBox;", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "getConsole", "()Lcom/intellij/execution/impl/ConsoleViewImpl;", "consoleView", "logData", "Ljava/util/ArrayDeque;", "Lcom/jetbrains/rider/plugins/unreal/model/UnrealLogEvent;", "logFilter", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogFilter;", "getProject", "()Lcom/intellij/openapi/project/Project;", "settings", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanelSettings;", "settingsActionGroup", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogSettingsActionGroup;", "getTabModel", "()Ljava/lang/String;", "verbosityFilterActionGroup", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogVerbosityFilterComboBox;", "addLogDataItem", "", "item", "clear", "filter", "getMessageStyle", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "type", "Lcom/jetbrains/rider/plugins/unreal/model/VerbosityType;", "print", "unrealLogEvent", "printImpl", "", "printInfo", "s", "Lcom/jetbrains/rider/plugins/unreal/model/LogMessageInfo;", "style", "printSpaces", "n", "", "Companion", "intellij.rider.plugins.unreal.link"})
@SourceDebugExtension(value={"SMAP\nUnrealLogPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealLogPanel.kt\ncom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1045#2:253\n*S KotlinDebug\n*F\n+ 1 UnrealLogPanel.kt\ncom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel\n*L\n194#1:253\n*E\n"})
public final class UnrealLogPanel
extends SimpleToolWindowPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tabModel;
    @NotNull
    private final Project project;
    @NotNull
    private final UnrealLogPanelSettings settings;
    @NotNull
    private final ArrayDeque<UnrealLogEvent> logData;
    @NotNull
    private final ConsoleViewImpl consoleView;
    @NotNull
    private final UnrealLogFilter logFilter;
    @NotNull
    private final UnrealLogVerbosityFilterComboBox verbosityFilterActionGroup;
    @NotNull
    private final UnrealLogCategoryFilterComboBox categoryFilterActionGroup;
    @NotNull
    private final UnrealLogSettingsActionGroup settingsActionGroup;
    private static final int MAX_STORED_LOG_DATA_ITEMS = 32768;
    private static final int TIME_WIDTH = 29;
    private static final int VERBOSITY_WIDTH = 12;

    public UnrealLogPanel(@NotNull String tabModel, @NotNull Lifetime lifetime, @NotNull Project project) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)tabModel, (String)"tabModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(false);
        this.tabModel = tabModel;
        this.project = project;
        this.settings = UnrealLogPanelSettings.Companion.getInstance(this.project);
        this.logData = new ArrayDeque();
        this.consoleView = UnrealLogPanel.Companion.createConsole(this.project, lifetime);
        this.logFilter = new UnrealLogFilter(lifetime, this.settings);
        this.verbosityFilterActionGroup = new UnrealLogVerbosityFilterComboBox(this.settings);
        this.categoryFilterActionGroup = new UnrealLogCategoryFilterComboBox(this.settings, this.logFilter);
        this.settingsActionGroup = new UnrealLogSettingsActionGroup(this.settings);
        this.setContent((JComponent)this.consoleView);
        DefaultActionGroup $this$_init__u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        AnAction[] anActionArray = this.consoleView.createConsoleActions();
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"createConsoleActions(...)");
        $this$_init__u24lambda_u240.addAll((Collection)ArraysKt.toList((Object[])anActionArray));
        DefaultActionGroup actionGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)actionGroup, this.myVertical);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        DefaultActionGroup $this$_init__u24lambda_u241 = bl = new DefaultActionGroup();
        boolean bl2 = false;
        $this$_init__u24lambda_u241.add((AnAction)this.verbosityFilterActionGroup);
        $this$_init__u24lambda_u241.add((AnAction)this.categoryFilterActionGroup);
        $this$_init__u24lambda_u241.add((AnAction)this.settingsActionGroup);
        DefaultActionGroup topGroup = bl;
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)topGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar topToolbar = actionToolbar2;
        JPanel topPanel = new JPanel((LayoutManager)new HorizontalLayout(0, 0, 2, null));
        topToolbar.setTargetComponent((JComponent)topPanel);
        topPanel.add(topToolbar.getComponent());
        this.consoleView.scrollTo(0);
        this.consoleView.add((Component)topPanel, (Object)"North");
        toolbar.setTargetComponent((JComponent)((Object)this));
        this.setToolbar(toolbar.getComponent());
        this.logFilter.addFilterChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.filter();
            }
        }));
        RdRiderModel model = RdRiderModel_PregeneratedKt.getRdRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project));
        model.isConnectedToUnrealEditor().advise(lifetime, (Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                if (it && settings.getClearOnStart()) {
                    this.clear();
                }
            }
        });
        model.getUnrealLog().advise(lifetime, (Function1)new Function1<UnrealLogEvent, Unit>(){

            public final void invoke(@NotNull UnrealLogEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.print(event);
            }
        });
    }

    @NotNull
    public final String getTabModel() {
        return this.tabModel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ConsoleViewImpl getConsole() {
        return this.consoleView;
    }

    public final void clear() {
        this.logData.clear();
        this.consoleView.clear();
    }

    private final void print(UnrealLogEvent unrealLogEvent) {
        this.addLogDataItem(unrealLogEvent);
        this.printImpl(unrealLogEvent);
    }

    private final void filter() {
        int currentScroll = this.consoleView.getEditor().getScrollingModel().getVerticalScrollOffset();
        this.consoleView.clear();
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, currentScroll){
            final /* synthetic */ UnrealLogPanel this$0;
            final /* synthetic */ int $currentScroll;
            {
                this.this$0 = $receiver;
                this.$currentScroll = $currentScroll;
                super(0);
            }

            public final void invoke() {
                for (UnrealLogEvent logEvent : UnrealLogPanel.access$getLogData$p(this.this$0)) {
                    Intrinsics.checkNotNull((Object)logEvent);
                    UnrealLogPanel.access$printImpl(this.this$0, logEvent);
                }
                UnrealLogPanel.access$getConsoleView$p(this.this$0).getEditor().getScrollingModel().scrollVertically(this.$currentScroll);
            }
        }), (int)1, null);
    }

    private final void printSpaces(int n, ConsoleViewContentType style) {
        if (n <= 0) {
            return;
        }
        this.consoleView.print(StringsKt.repeat((CharSequence)" ", (int)n), style);
    }

    static /* synthetic */ void printSpaces$default(UnrealLogPanel unrealLogPanel, int n, ConsoleViewContentType consoleViewContentType, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        unrealLogPanel.printSpaces(n, consoleViewContentType);
    }

    private final void printInfo(LogMessageInfo s, ConsoleViewContentType style) {
        if (this.settings.getShowTimestamps()) {
            String timeString;
            Date date = s.getTime();
            String string = timeString = date != null ? date.toString() : null;
            if (timeString != null) {
                this.consoleView.print(timeString, style);
                this.printSpaces(30 - timeString.length(), style);
            } else {
                this.printSpaces(30, style);
            }
        }
        if (this.settings.getAlignMessages()) {
            if (this.settings.getShowVerbosity()) {
                verbosityString = s.getType().toString();
                this.consoleView.print(verbosityString, style);
                this.printSpaces(12 - verbosityString.length() + 1, style);
            }
            String category = s.getCategory().getData();
            this.consoleView.print(category, style);
            this.printSpaces(this.settings.getCategoryWidth() - category.length(), style);
            this.printSpaces(1, style);
        } else {
            if (this.settings.getShowVerbosity()) {
                verbosityString = s.getType().toString();
                this.consoleView.print(verbosityString, style);
                this.consoleView.print(": ", style);
            }
            this.consoleView.print(s.getCategory().getData(), style);
            this.consoleView.print(": ", style);
        }
    }

    private final ConsoleViewContentType getMessageStyle(VerbosityType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_FATAL();
            case 2 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_ERROR();
            case 3 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_WARNING();
            case 4 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_DISPLAY();
            case 5 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_LOG();
            case 6 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_VERBOSE();
            case 7 -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_VERY_VERBOSE();
            default -> UnrealLogConsoleViewContentType.Companion.getUE_LOG_LOG();
        };
    }

    private final boolean printImpl(UnrealLogEvent unrealLogEvent) {
        this.logFilter.addCategory(unrealLogEvent.getInfo().getCategory().getData());
        if (!this.logFilter.isMessageAllowed(unrealLogEvent.getInfo())) {
            return false;
        }
        ConsoleViewContentType style = this.getMessageStyle(unrealLogEvent.getInfo().getType());
        this.printInfo(unrealLogEvent.getInfo(), style);
        if (unrealLogEvent.getBpPathRanges().isEmpty() && unrealLogEvent.getMethodRanges().isEmpty()) {
            ConsoleViewImpl $this$printImpl_u24lambda_u242 = this.consoleView;
            boolean bl = false;
            $this$printImpl_u24lambda_u242.print(unrealLogEvent.getText().getData(), style);
            this.consoleView.print(PlatformDependentKt.getEol(), style);
            return true;
        }
        Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)unrealLogEvent.getBpPathRanges(), (Iterable)unrealLogEvent.getMethodRanges());
        boolean $i$f$sortedBy2 = false;
        List sortedRanges = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                StringRange it = (StringRange)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getFirst());
                it = (StringRange)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getFirst()));
            }
        });
        boolean bl = $this$sortedBy$iv = !((Collection)sortedRanges).isEmpty();
        if (_Assertions.ENABLED && !$this$sortedBy$iv) {
            String $i$f$sortedBy2 = "Assertion failed";
            throw new AssertionError((Object)$i$f$sortedBy2);
        }
        ArrayList<StringRange> allRanges = new ArrayList<StringRange>();
        StringRange lastAddedRange = (StringRange)sortedRanges.get(0);
        allRanges.add(lastAddedRange);
        int n = sortedRanges.size();
        for (int index = 1; index < n; ++index) {
            StringRange curRange = (StringRange)sortedRanges.get(index);
            if (lastAddedRange.getLast() > curRange.getFirst()) continue;
            allRanges.add(curRange);
            lastAddedRange = curRange;
        }
        String line = unrealLogEvent.getText().getData();
        if (((StringRange)CollectionsKt.first((List)allRanges)).getFirst() > 0) {
            String string = line.substring(0, ((StringRange)allRanges.get(0)).getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.consoleView.print(string, style);
        }
        RdRiderModel model = RdRiderModel_PregeneratedKt.getRdRiderModel(SolutionHostExtensionsKt.getSolution((Project)this.project));
        for (IndexedValue rangeWithIndex : CollectionsKt.withIndex((Iterable)allRanges)) {
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(((StringRange)rangeWithIndex.getValue()).getFirst(), ((StringRange)rangeWithIndex.getValue()).getLast()), (String)"substring(...)");
            if (unrealLogEvent.getBpPathRanges().contains(rangeWithIndex.getValue())) {
                BlueprintClassHyperLinkInfo hyperLinkInfo = new BlueprintClassHyperLinkInfo(model.getOpenBlueprint(), new BlueprintReference(new FString(match), new FString("")));
                this.consoleView.printHyperlink(match, (HyperlinkInfo)hyperLinkInfo);
            } else {
                String[] stringArray = new String[]{"::"};
                List list = StringsKt.split$default((CharSequence)match, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String string = (String)list.get(0);
                String method = (String)list.get(1);
                MethodReference methodReference = new MethodReference(new UClass(new FString(string)), new FString(method));
                UnrealClassHyperLinkInfo classHyperLinkInfo = new UnrealClassHyperLinkInfo(model, methodReference, new UClass(new FString(string)));
                this.consoleView.printHyperlink(string, (HyperlinkInfo)classHyperLinkInfo);
                this.consoleView.print("::", style);
                MethodReferenceHyperLinkInfo methodHyperLinkInfo = new MethodReferenceHyperLinkInfo(model, methodReference);
                this.consoleView.printHyperlink(method, (HyperlinkInfo)methodHyperLinkInfo);
            }
            if (rangeWithIndex.getIndex() >= allRanges.size() - 1 || ((StringRange)allRanges.get(rangeWithIndex.getIndex() + 1)).getFirst() == ((StringRange)rangeWithIndex.getValue()).getLast()) continue;
            String string = line.substring(((StringRange)rangeWithIndex.getValue()).getLast(), ((StringRange)allRanges.get(rangeWithIndex.getIndex() + 1)).getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.consoleView.print(string, style);
        }
        if (((StringRange)CollectionsKt.last((List)allRanges)).getLast() < line.length()) {
            String string = line.substring(((StringRange)CollectionsKt.last((List)allRanges)).getLast());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.consoleView.print(string, style);
        }
        this.consoleView.print(PlatformDependentKt.getEol(), style);
        return true;
    }

    private final void addLogDataItem(UnrealLogEvent item) {
        while (this.logData.size() >= 32768) {
            this.logData.removeFirst();
        }
        this.logData.add(item);
    }

    public static final /* synthetic */ ArrayDeque access$getLogData$p(UnrealLogPanel $this) {
        return $this.logData;
    }

    public static final /* synthetic */ boolean access$printImpl(UnrealLogPanel $this, UnrealLogEvent unrealLogEvent) {
        return $this.printImpl(unrealLogEvent);
    }

    public static final /* synthetic */ ConsoleViewImpl access$getConsoleView$p(UnrealLogPanel $this) {
        return $this.consoleView;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanel$Companion;", "", "()V", "MAX_STORED_LOG_DATA_ITEMS", "", "TIME_WIDTH", "VERBOSITY_WIDTH", "createConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider.plugins.unreal.link"})
    public static final class Companion {
        private Companion() {
        }

        private final ConsoleViewImpl createConsole(Project project, Lifetime lifetime) {
            ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
            ConsoleViewImpl consoleView2 = (ConsoleViewImpl)consoleView;
            lifetime.bracketIfAlive((Function0)new Function0<JComponent>(consoleView2){
                final /* synthetic */ ConsoleViewImpl $consoleView;
                {
                    this.$consoleView = $consoleView;
                    super(0);
                }

                @NotNull
                public final JComponent invoke() {
                    return this.$consoleView.getComponent();
                }
            }, (Function0)new Function0<Unit>(consoleView2){
                final /* synthetic */ ConsoleViewImpl $consoleView;
                {
                    this.$consoleView = $consoleView;
                    super(0);
                }

                public final void invoke() {
                    this.$consoleView.dispose();
                }
            });
            return consoleView2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VerbosityType.values().length];
            try {
                nArray[VerbosityType.Fatal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Warning.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Display.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Log.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.Verbose.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerbosityType.VeryVerbose.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

