/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.actions;

import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.UnrealLinkBundle;
import com.jetbrains.rider.plugins.unreal.UnrealHost;
import com.jetbrains.rider.plugins.unreal.actions.ActionsUtilsKt;
import com.jetbrains.rider.plugins.unreal.model.PlayState;
import com.jetbrains.rider.plugins.unreal.model.RequestFailed;
import com.jetbrains.rider.plugins.unreal.model.RequestResultBase;
import com.jetbrains.rider.plugins.unreal.model.RequestSucceed;
import com.jetbrains.rider.plugins.unreal.model.frontendBackend.RdRiderModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\bJ\u0006\u0010\u000f\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/unreal/actions/PlayStateActionStateService;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentRequestID", "", "disabledUntilModelChange", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "disableUntilStateChange", "", "invalidate", "isDisabledUntilStateChange", "nextRequestID", "Companion", "intellij.rider.plugins.unreal.link"})
public final class PlayStateActionStateService
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private boolean disabledUntilModelChange;
    private int currentRequestID;
    @NotNull
    private static final String RIDER_LINK_ACTIONS_NOTIFICATION_GROUP_ID = "RiderLinkActions";

    public PlayStateActionStateService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        UnrealHost host = UnrealHost.Companion.getInstance(this.project);
        host.performModelAction((Function1)new Function1<RdRiderModel, Unit>(){

            public final void invoke(@NotNull RdRiderModel model) {
                Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
                model.isConnectedToUnrealEditor().getChange().advise(this.getServiceLifetime(), (Function1)new Function1<Boolean, Unit>(){

                    public final void invoke(boolean it) {
                        this.invalidate();
                    }
                });
                model.getNotificationReplyFromEditor().advise(this.getServiceLifetime(), (Function1)new Function1<RequestResultBase, Unit>(){

                    public final void invoke(@NotNull RequestResultBase it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (it.getRequestID() != currentRequestID) {
                            return;
                        }
                        RequestResultBase requestResultBase = it;
                        if (requestResultBase instanceof RequestSucceed) {
                            this.invalidate();
                        } else if (requestResultBase instanceof RequestFailed) {
                            this.invalidate();
                            String title = UnrealLinkBundle.message("notification.RiderLink.ReplyFromEditor.title", new Object[0]);
                            String message = ((RequestFailed)it).getMessage().getData();
                            NotificationType type = switch (WhenMappings.$EnumSwitchMapping$0[((RequestFailed)it).getType().ordinal()]) {
                                case 1 -> NotificationType.INFORMATION;
                                case 2 -> NotificationType.ERROR;
                                default -> throw new NoWhenBranchMatchedException();
                            };
                            NotificationGroupManager.getInstance().getNotificationGroup(PlayStateActionStateService.RIDER_LINK_ACTIONS_NOTIFICATION_GROUP_ID).createNotification(title, message, type).notify(this.getProject());
                        }
                    }

                    @Metadata(mv={1, 9, 0}, k=3, xi=48)
                    public final class WhenMappings {
                        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                        static {
                            int[] nArray = new int[com.jetbrains.rider.plugins.unreal.model.NotificationType.values().length];
                            try {
                                nArray[com.jetbrains.rider.plugins.unreal.model.NotificationType.Message.ordinal()] = 1;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {
                                // empty catch block
                            }
                            try {
                                nArray[com.jetbrains.rider.plugins.unreal.model.NotificationType.Error.ordinal()] = 2;
                            }
                            catch (NoSuchFieldError noSuchFieldError) {
                                // empty catch block
                            }
                            $EnumSwitchMapping$0 = nArray;
                        }
                    }
                });
            }
        });
        host.getPlayStateModel$intellij_rider_plugins_unreal_link().getChange().advise(this.getServiceLifetime(), (Function1)new Function1<PlayState, Unit>(){

            public final void invoke(@NotNull PlayState it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.invalidate();
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void invalidate() {
        this.disabledUntilModelChange = false;
        ActionsUtilsKt.forceTriggerUIUpdate();
    }

    public final void disableUntilStateChange() {
        this.disabledUntilModelChange = true;
    }

    public final boolean isDisabledUntilStateChange() {
        return this.disabledUntilModelChange;
    }

    public final int nextRequestID() {
        int n = this.currentRequestID;
        this.currentRequestID = n + 1;
        return this.currentRequestID;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/unreal/actions/PlayStateActionStateService$Companion;", "", "()V", "RIDER_LINK_ACTIONS_NOTIFICATION_GROUP_ID", "", "getInstance", "Lcom/jetbrains/rider/plugins/unreal/actions/PlayStateActionStateService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.unreal.link"})
    @SourceDebugExtension(value={"SMAP\nPlayActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayActions.kt\ncom/jetbrains/rider/plugins/unreal/actions/PlayStateActionStateService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,227:1\n31#2,2:228\n*S KotlinDebug\n*F\n+ 1 PlayActions.kt\ncom/jetbrains/rider/plugins/unreal/actions/PlayStateActionStateService$Companion\n*L\n28#1:228,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PlayStateActionStateService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PlayStateActionStateService> serviceClass$iv = PlayStateActionStateService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PlayStateActionStateService)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

