/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemberSignature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String signature;

    private MemberSignature(String signature2) {
        this.signature = signature2;
    }

    @NotNull
    public final String getSignature() {
        return this.signature;
    }

    @NotNull
    public String toString() {
        return "MemberSignature(signature=" + this.signature + ')';
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof MemberSignature)) {
            return false;
        }
        MemberSignature memberSignature = (MemberSignature)other2;
        return Intrinsics.areEqual(this.signature, memberSignature.signature);
    }

    public /* synthetic */ MemberSignature(String signature2, DefaultConstructorMarker $constructor_marker) {
        this(signature2);
    }

    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final MemberSignature fromMethod(@NotNull NameResolver nameResolver, @NotNull JvmProtoBuf.JvmMethodSignature signature2) {
            Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
            Intrinsics.checkNotNullParameter(signature2, "signature");
            return this.fromMethodNameAndDesc(nameResolver.getString(signature2.getName()), nameResolver.getString(signature2.getDesc()));
        }

        @JvmStatic
        @NotNull
        public final MemberSignature fromMethodNameAndDesc(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(desc, "desc");
            return new MemberSignature(name + desc, null);
        }

        @JvmStatic
        @NotNull
        public final MemberSignature fromFieldNameAndDesc(@NotNull String name, @NotNull String desc) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(desc, "desc");
            return new MemberSignature(name + '#' + desc, null);
        }

        @JvmStatic
        @NotNull
        public final MemberSignature fromJvmMemberSignature(@NotNull JvmMemberSignature signature2) {
            MemberSignature memberSignature;
            Intrinsics.checkNotNullParameter(signature2, "signature");
            JvmMemberSignature jvmMemberSignature = signature2;
            if (jvmMemberSignature instanceof JvmMemberSignature.Method) {
                memberSignature = this.fromMethodNameAndDesc(signature2.getName(), signature2.getDesc());
            } else if (jvmMemberSignature instanceof JvmMemberSignature.Field) {
                memberSignature = this.fromFieldNameAndDesc(signature2.getName(), signature2.getDesc());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return memberSignature;
        }

        @JvmStatic
        @NotNull
        public final MemberSignature fromMethodSignatureAndParameterIndex(@NotNull MemberSignature signature2, int index) {
            Intrinsics.checkNotNullParameter(signature2, "signature");
            return new MemberSignature(signature2.getSignature() + '@' + index, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

