/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.lifetime;

import com.jetbrains.rd.util.AtomicReference;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000b\u001a\u00020\f2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J(\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f\u0018\u00010\u0013H\u0004J\b\u0010\u0014\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "currentDef", "Lcom/jetbrains/rd/util/AtomicReference;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "isTerminated", "", "()Z", "defineNext", "", "fNext", "Lkotlin/Function2;", "next", "setCurrentLifetime", "newDef", "action", "Lkotlin/Function1;", "terminateCurrent", "rd-core"})
public class SequentialLifetimes {
    @NotNull
    private final Lifetime parentLifetime;
    @NotNull
    private final AtomicReference<LifetimeDefinition> currentDef;

    public SequentialLifetimes(@NotNull Lifetime parentLifetime) {
        Intrinsics.checkNotNullParameter(parentLifetime, "parentLifetime");
        this.parentLifetime = parentLifetime;
        this.currentDef = new AtomicReference<LifetimeDefinition>(LifetimeDefinition.Companion.getTerminated());
        RLifetimeKt.plusAssign(this.parentLifetime, new Function0<Unit>(){

            @Override
            public final void invoke() {
                SequentialLifetimes.setCurrentLifetime$default(this, LifetimeDefinition.Companion.getTerminated(), null, 2, null);
            }
        });
    }

    @NotNull
    public LifetimeDefinition next() {
        LifetimeDefinition newDef = this.parentLifetime.createNested();
        SequentialLifetimes.setCurrentLifetime$default(this, newDef, null, 2, null);
        return newDef;
    }

    public void terminateCurrent() {
        SequentialLifetimes.setCurrentLifetime$default(this, LifetimeDefinition.Companion.getTerminated(), null, 2, null);
    }

    public final boolean isTerminated() {
        LifetimeDefinition current = this.currentDef.get();
        return RLifetimeKt.isEternal(current) || !RLifetimeKt.isAlive(current);
    }

    public void defineNext(@NotNull Function2<? super LifetimeDefinition, ? super Lifetime, Unit> fNext) {
        Intrinsics.checkNotNullParameter(fNext, "fNext");
        this.setCurrentLifetime(this.parentLifetime.createNested(), (Function1<? super LifetimeDefinition, Unit>)new Function1<LifetimeDefinition, Unit>(fNext){
            final /* synthetic */ Function2<LifetimeDefinition, Lifetime, Unit> $fNext;
            {
                this.$fNext = $fNext;
                super(1);
            }

            public final void invoke(@NotNull LifetimeDefinition ld) {
                Intrinsics.checkNotNullParameter(ld, "ld");
                try {
                    ld.executeIfAlive((Function0)new Function0<Unit>(this.$fNext, ld){
                        final /* synthetic */ Function2<LifetimeDefinition, Lifetime, Unit> $fNext;
                        final /* synthetic */ LifetimeDefinition $ld;
                        {
                            this.$fNext = $fNext;
                            this.$ld = $ld;
                            super(0);
                        }

                        public final void invoke() {
                            this.$fNext.invoke(this.$ld, this.$ld.getLifetime());
                        }
                    });
                }
                catch (Throwable t) {
                    LifetimeDefinition.terminate$default(ld, false, 1, null);
                    throw t;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setCurrentLifetime(@NotNull LifetimeDefinition newDef, @Nullable Function1<? super LifetimeDefinition, Unit> action) {
        Intrinsics.checkNotNullParameter(newDef, "newDef");
        LifetimeDefinition tempLifetimeDefinition = new LifetimeDefinition();
        LifetimeDefinition.terminate$default(tempLifetimeDefinition, false, 1, null);
        LifetimeDefinition old = this.currentDef.getAndSet(tempLifetimeDefinition);
        try {
            old.terminate(true);
        }
        catch (Throwable t) {
            LoggerKt.error((Logger)Logger.Companion.getRoot(), t);
        }
        try {
            Function1<? super LifetimeDefinition, Unit> function1 = action;
            if (function1 != null) {
                function1.invoke(newDef);
            }
        }
        finally {
            if (!this.currentDef.compareAndSet(tempLifetimeDefinition, newDef)) {
                newDef.terminate(true);
            }
        }
    }

    public static /* synthetic */ void setCurrentLifetime$default(SequentialLifetimes sequentialLifetimes, LifetimeDefinition lifetimeDefinition, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setCurrentLifetime");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        sequentialLifetimes.setCurrentLifetime(lifetimeDefinition, function1);
    }
}

