/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.models.RdDateTimeOffset;
import com.jetbrains.jdbc.base.models.RdSetDateTimeOffsetRequest;
import com.jetbrains.jdbc.base.models.RdSetNullRequest;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.sqlserver.JDBCTypeExt;
import com.jetbrains.jdbc.sqlserver.SqlServerJdbcToNativeTypeTranslator;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0012\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u0016\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0017\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u0019\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u001b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/set/SetTimestampWithTimezoneConverter;", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "()V", "to", "", "Ljava/sql/SQLType;", "getTo", "()Ljava/util/List;", "fromNString", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "value", "", "sqlType", "", "fromOffsetDateTime", "Ljava/time/OffsetDateTime;", "fromOffsetTime", "Ljava/time/OffsetTime;", "fromSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "fromString", "fromTime", "Ljava/sql/Time;", "fromTimestamp", "Ljava/sql/Timestamp;", "fromUtilDate", "Ljava/util/Date;", "Frontend"})
public final class SetTimestampWithTimezoneConverter
extends SetValueConverter {
    @NotNull
    public static final SetTimestampWithTimezoneConverter INSTANCE = new SetTimestampWithTimezoneConverter();
    @NotNull
    private static final List<SQLType> to;

    private SetTimestampWithTimezoneConverter() {
        super(SqlServerJdbcToNativeTypeTranslator.INSTANCE);
    }

    @Override
    @NotNull
    public List<SQLType> getTo() {
        return to;
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTimestamp(@Nullable Timestamp value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant();
        java.util.Date date = Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdDateTimeOffset rdDateTimeOffset = new RdDateTimeOffset(0, date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeOffsetRequest(rdDateTimeOffset, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromSqlDate(@Nullable Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        Instant converted = DateTimeUtilsKt.resetTime(DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone)).toInstant();
        java.util.Date date = Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdDateTimeOffset rdDateTimeOffset = new RdDateTimeOffset(0, date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeOffsetRequest(rdDateTimeOffset, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromUtilDate(@Nullable java.util.Date value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = value2.toInstant();
        Intrinsics.checkNotNullExpressionValue(instant, "value.toInstant()");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant();
        java.util.Date date = Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdDateTimeOffset rdDateTimeOffset = new RdDateTimeOffset(0, date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeOffsetRequest(rdDateTimeOffset, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromTime(@Nullable Time value2, @NotNull TimeZone timeZone, int sqlType) {
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        Instant instant = Instant.ofEpochMilli(value2.getTime());
        Intrinsics.checkNotNullExpressionValue(instant, "ofEpochMilli(value.time)");
        Instant converted = DateTimeUtilsKt.fromGregorianToPureGregorian(instant, timeZone).toInstant();
        java.util.Date date = Date.from(converted);
        Intrinsics.checkNotNullExpressionValue(date, "from(converted)");
        RdDateTimeOffset rdDateTimeOffset = new RdDateTimeOffset(0, date, 0);
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeOffsetRequest(rdDateTimeOffset, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromOffsetDateTime(@Nullable OffsetDateTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        int offsetSeconds = value2.getOffset().getTotalSeconds();
        Instant instant = value2.toLocalDateTime().toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        RdDateTimeOffset rdDateTimeOffset = new RdDateTimeOffset(offsetSeconds, date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeOffsetRequest(rdDateTimeOffset, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromOffsetTime(@Nullable OffsetTime value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        int offsetSeconds = value2.getOffset().getTotalSeconds();
        Instant instant = value2.toLocalTime().atDate(LocalDate.EPOCH).toInstant(ZoneOffset.UTC);
        java.util.Date date = java.util.Date.from(instant);
        Intrinsics.checkNotNullExpressionValue(date, "from(instant)");
        Intrinsics.checkNotNullExpressionValue(instant, "instant");
        RdDateTimeOffset rdDateTimeOffset = new RdDateTimeOffset(offsetSeconds, date, DateTimeUtilsKt.getLeftNanos(instant));
        Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
        return new RdSetDateTimeOffsetRequest(rdDateTimeOffset, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public RdSetValueRequest fromString(@Nullable String value2, int sqlType) {
        if (value2 == null) {
            Integer n = this.getTranslator().fromJdbcToNative(sqlType).getVendorTypeNumber();
            Intrinsics.checkNotNullExpressionValue(n, "translator.fromJdbcToNat\u2026sqlType).vendorTypeNumber");
            return new RdSetNullRequest(((Number)n).intValue());
        }
        OffsetDateTime offsetDateTime = SqlDateTimeFormatter.INSTANCE.parseOffsetDateTime(value2);
        return this.fromOffsetDateTime(offsetDateTime, sqlType);
    }

    @Override
    @NotNull
    public RdSetValueRequest fromNString(@Nullable String value2, int sqlType) {
        return this.fromString(value2, sqlType);
    }

    static {
        SQLType[] sQLTypeArray = new SQLType[]{JDBCType.TIMESTAMP_WITH_TIMEZONE, JDBCTypeExt.DateTimeOffset};
        to = CollectionsKt.listOf(sQLTypeArray);
    }
}

