/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdGetByteResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.math.BigDecimal;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b(R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetTinyIntConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getBigDecimal", "Ljava/math/BigDecimal;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNString", "", "getObject", "", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getString", "getValue", "Lkotlin/UByte;", "getValue-do-JOtI", "Frontend"})
@ExperimentalUnsignedTypes
public final class GetTinyIntConverter
extends GetValueConverter {
    @NotNull
    public static final GetTinyIntConverter INSTANCE = new GetTinyIntConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.TinyInt);

    private GetTinyIntConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public Byte getByte(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        return uByte != null ? Byte.valueOf(uByte.unbox-impl()) : null;
    }

    @Override
    @Nullable
    public Short getShort(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return (short)((short)value2 & 0xFF);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return value2 & 0xFF;
    }

    @Override
    @Nullable
    public Long getLong(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return (long)value2 & 0xFFL;
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return Float.valueOf(value2 & 0xFF);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return value2 & 0xFF;
    }

    @Override
    @NotNull
    public Boolean getBoolean(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return false;
        }
        byte value2 = uByte.unbox-impl();
        int n = 0;
        return Integer.compareUnsigned(UInt.constructor-impl(value2 & 0xFF), n) > 0;
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return new BigDecimal(value2 & 0xFF);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        return uByte != null ? Short.valueOf((short)((short)uByte.unbox-impl() & 0xFF)) : null;
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        UByte uByte = this.getValue-do-JOtI(response);
        if (uByte == null) {
            return null;
        }
        byte value2 = uByte.unbox-impl();
        return UByte.toString-impl(value2);
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    private final UByte getValue-do-JOtI(RdGetValueResponse response) {
        UByte uByte;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetByteResponse) {
            uByte = ((RdGetByteResponse)response).getValue-7PGSa80();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            uByte = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetByteResponse.Companion.get_type()).getName(), "RdGetByteResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return uByte;
    }
}

