/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver.converters.get;

import com.jetbrains.jdbc.base.conversions.get.GetValueConverter;
import com.jetbrains.jdbc.base.models.RdDateTimeOffset;
import com.jetbrains.jdbc.base.models.RdGetDateTimeOffsetResponse;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdNullResponse;
import com.jetbrains.jdbc.base.utils.conversions.DateTimeUtilsKt;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.sqlserver.converters.SqlDateTimeFormatter;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lcom/jetbrains/jdbc/sqlserver/converters/get/GetDateTimeOffsetConverter;", "Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "()V", "from", "", "Lcom/jetbrains/jdbc/sqlserver/converters/SqlServerType;", "getFrom", "()Ljava/util/List;", "getLocalDate", "Ljava/time/LocalDate;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getNString", "", "getObject", "", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetTime", "Ljava/time/OffsetTime;", "getSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getUtilDate", "Ljava/util/Date;", "getValue", "Lcom/jetbrains/jdbc/base/models/RdDateTimeOffset;", "Frontend"})
@SourceDebugExtension(value={"SMAP\nGetDateTimeOffsetConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GetDateTimeOffsetConverter.kt\ncom/jetbrains/jdbc/sqlserver/converters/get/GetDateTimeOffsetConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n1#2:147\n*E\n"})
public final class GetDateTimeOffsetConverter
extends GetValueConverter {
    @NotNull
    public static final GetDateTimeOffsetConverter INSTANCE = new GetDateTimeOffsetConverter();
    @NotNull
    private static final List<SqlServerType> from = CollectionsKt.listOf(SqlServerType.DateTimeOffset);

    private GetDateTimeOffsetConverter() {
    }

    @NotNull
    public List<SqlServerType> getFrom() {
        return from;
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        instant = instant.plusNanos(value2.getNanos());
        LocalDateTime local = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return OffsetDateTime.of(local, ZoneOffset.ofTotalSeconds(value2.getOffsetInSeconds()));
    }

    @Override
    @Nullable
    public OffsetTime getOffsetTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        instant = instant.plusNanos(value2.getNanos());
        LocalTime local = LocalTime.ofInstant(instant, ZoneId.of("UTC"));
        return OffsetTime.of(local, ZoneOffset.ofTotalSeconds(value2.getOffsetInSeconds()));
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        SimpleTimeZone timezone = new SimpleTimeZone(value2.getOffsetInSeconds() * 1000, "");
        Instant instant2 = instant;
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timezone).toInstant().plusNanos(value2.getNanos());
        return Timestamp.from(instant);
    }

    @Override
    @Nullable
    public Time getTime(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        SimpleTimeZone timezone = new SimpleTimeZone(value2.getOffsetInSeconds() * 1000, "");
        Instant instant2 = instant;
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.setBaseDate(DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timezone)).toInstant();
        return new Time(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public Date getSqlDate(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        SimpleTimeZone timezone = new SimpleTimeZone(value2.getOffsetInSeconds() * 1000, "");
        Instant instant2 = instant;
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.resetTime(DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timezone)).toInstant();
        return new Date(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public java.util.Date getUtilDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        SimpleTimeZone timezone = new SimpleTimeZone(value2.getOffsetInSeconds() * 1000, "");
        Instant instant2 = instant;
        Intrinsics.checkNotNullExpressionValue(instant2, "instant");
        instant = DateTimeUtilsKt.fromPureGregorianToGregorian(instant2, timezone).toInstant();
        return new java.util.Date(instant.toEpochMilli());
    }

    @Override
    @Nullable
    public LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        RdDateTimeOffset rdDateTimeOffset = this.getValue(response);
        if (rdDateTimeOffset == null) {
            return null;
        }
        RdDateTimeOffset value2 = rdDateTimeOffset;
        Instant instant = value2.getDatetime().toInstant();
        LocalDateTime local = LocalDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return local.plusNanos(value2.getNanos()).minusSeconds(value2.getOffsetInSeconds());
    }

    @Override
    @Nullable
    public LocalDate getLocalDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        LocalDateTime localDateTime = this.getLocalDateTime(response);
        return localDateTime != null ? localDateTime.toLocalDate() : null;
    }

    @Override
    @Nullable
    public LocalTime getLocalTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        LocalDateTime localDateTime = this.getLocalDateTime(response);
        return localDateTime != null ? localDateTime.toLocalTime() : null;
    }

    @Override
    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        String string;
        OffsetDateTime offsetDateTime;
        Intrinsics.checkNotNullParameter(response, "response");
        OffsetDateTime offsetDateTime2 = offsetDateTime = this.getOffsetDateTime(response);
        if (offsetDateTime2 != null) {
            OffsetDateTime it = offsetDateTime2;
            boolean bl = false;
            string = SqlDateTimeFormatter.INSTANCE.format(offsetDateTime);
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getString(response);
    }

    @Override
    @Nullable
    public Object getObject(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        return this.getOffsetDateTime(response);
    }

    private final RdDateTimeOffset getValue(RdGetValueResponse response) {
        RdDateTimeOffset rdDateTimeOffset;
        RdGetValueResponse rdGetValueResponse = response;
        if (rdGetValueResponse instanceof RdGetDateTimeOffsetResponse) {
            rdDateTimeOffset = ((RdGetDateTimeOffsetResponse)response).getValue();
        } else if (rdGetValueResponse instanceof RdNullResponse) {
            rdDateTimeOffset = null;
        } else {
            String string = response.getClass().getName();
            Intrinsics.checkNotNullExpressionValue(string, "response::class.java.name");
            String[] stringArray = new String[2];
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdGetDateTimeOffsetResponse.Companion.get_type()).getName(), "RdGetDateTimeOffsetResponse._type.java.name");
            Intrinsics.checkNotNullExpressionValue(JvmClassMappingKt.getJavaClass(RdNullResponse.Companion.get_type()).getName(), "RdNullResponse._type.java.name");
            throw ExceptionsKt.invalidValueReceived(string, stringArray);
        }
        return rdDateTimeOffset;
    }
}

