/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver;

import com.jetbrains.jdbc.base.models.RdParsedStatement;
import com.jetbrains.jdbc.base.statements.IStatementParser;
import com.jetbrains.jdbc.sqlserver.parsing.JdbcSyntaxParser;
import com.jetbrains.jdbc.sqlserver.parsing.LimitSyntaxParser;
import com.jetbrains.jdbc.sqlserver.parsing.ParametersPositionProvider;
import com.jetbrains.jdbc.sqlserver.parsing.ParseResult;
import com.jetbrains.jdbc.sqlserver.parsing.TsqlSyntaxParser;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/jdbc/sqlserver/SqlServerStatementParser;", "Lcom/jetbrains/jdbc/base/statements/IStatementParser;", "()V", "parse", "Lcom/jetbrains/jdbc/sqlserver/parsing/ParseResult;", "sql", "", "parseSqlWithParams", "Lcom/jetbrains/jdbc/base/models/RdParsedStatement;", "translateSql", "Frontend"})
public final class SqlServerStatementParser
implements IStatementParser {
    @NotNull
    public static final SqlServerStatementParser INSTANCE = new SqlServerStatementParser();

    private SqlServerStatementParser() {
    }

    @Override
    @NotNull
    public RdParsedStatement parseSqlWithParams(@NotNull String sql) {
        RdParsedStatement rdParsedStatement;
        Intrinsics.checkNotNullParameter(sql, "sql");
        ParseResult parseResult = this.parse(sql);
        if (Intrinsics.areEqual(parseResult, ParseResult.Failure.INSTANCE)) {
            rdParsedStatement = new RdParsedStatement(LimitSyntaxParser.INSTANCE.translateLimit(sql), ParametersPositionProvider.INSTANCE.getParameterPositions(sql), null, false);
        } else if (parseResult instanceof ParseResult.Success) {
            rdParsedStatement = new RdParsedStatement(LimitSyntaxParser.INSTANCE.translateLimit(((ParseResult.Success)parseResult).getNativeSql()), ParametersPositionProvider.INSTANCE.getParameterPositions(((ParseResult.Success)parseResult).getNativeSql()), ((ParseResult.Success)parseResult).getProcedureName(), ((ParseResult.Success)parseResult).getHasReturnValueSyntax());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return rdParsedStatement;
    }

    @Override
    @NotNull
    public String translateSql(@NotNull String sql) {
        String string;
        ParseResult parseResult;
        Intrinsics.checkNotNullParameter(sql, "sql");
        ParseResult parseResult2 = parseResult = this.parse(sql);
        if (Intrinsics.areEqual(parseResult2, ParseResult.Failure.INSTANCE)) {
            string = sql;
        } else if (parseResult2 instanceof ParseResult.Success) {
            string = ((ParseResult.Success)parseResult).getNativeSql();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return LimitSyntaxParser.INSTANCE.translateLimit(string);
    }

    private final ParseResult parse(String sql) {
        ParseResult parseResult;
        ParseResult jdbcParseResult = JdbcSyntaxParser.INSTANCE.parse(sql);
        if (Intrinsics.areEqual(jdbcParseResult, ParseResult.Failure.INSTANCE)) {
            parseResult = TsqlSyntaxParser.INSTANCE.parse(sql);
        } else if (jdbcParseResult instanceof ParseResult.Success) {
            parseResult = jdbcParseResult;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return parseResult;
    }
}

