/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver;

import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToNativeTypeTranslator;
import com.jetbrains.jdbc.sqlserver.JDBCTypeExt;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.sql.JDBCType;
import java.sql.SQLType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/jdbc/sqlserver/SqlServerJdbcToNativeTypeTranslator;", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;", "()V", "convert", "", "jdbcType", "fromJdbcToNative", "Ljava/sql/SQLType;", "fromNativeToJdbc", "nativeType", "Frontend"})
public final class SqlServerJdbcToNativeTypeTranslator
implements IJdbcToNativeTypeTranslator {
    @NotNull
    public static final SqlServerJdbcToNativeTypeTranslator INSTANCE = new SqlServerJdbcToNativeTypeTranslator();

    private SqlServerJdbcToNativeTypeTranslator() {
    }

    @Override
    @NotNull
    public SQLType fromJdbcToNative(int jdbcType) {
        return SqlServerType.Companion.valueOf(this.convert(jdbcType));
    }

    @Override
    @NotNull
    public SQLType fromNativeToJdbc(int nativeType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[SqlServerType.Companion.valueOf(nativeType).ordinal()]) {
            case 1 -> JDBCType.BIGINT;
            case 2 -> JDBCType.BINARY;
            case 3 -> JDBCType.BIT;
            case 4 -> JDBCType.CHAR;
            case 5 -> JDBCType.TIMESTAMP;
            case 6 -> JDBCType.DECIMAL;
            case 7 -> JDBCType.DOUBLE;
            case 8 -> JDBCType.LONGVARBINARY;
            case 9 -> JDBCType.INTEGER;
            case 10 -> JDBCType.DECIMAL;
            case 11 -> JDBCType.NCHAR;
            case 12 -> JDBCType.LONGNVARCHAR;
            case 13 -> JDBCType.NVARCHAR;
            case 14 -> JDBCType.REAL;
            case 15 -> JDBCType.VARCHAR;
            case 16 -> JDBCType.TIMESTAMP;
            case 17 -> JDBCType.SMALLINT;
            case 18 -> JDBCType.DECIMAL;
            case 19 -> JDBCType.LONGVARCHAR;
            case 20 -> JDBCType.TIMESTAMP;
            case 21 -> JDBCType.TINYINT;
            case 22 -> JDBCType.VARBINARY;
            case 23 -> JDBCType.VARCHAR;
            case 24 -> JDBCType.OTHER;
            case 25 -> JDBCType.SQLXML;
            case 26 -> JDBCType.VARBINARY;
            case 27 -> JDBCType.DATE;
            case 28 -> JDBCType.TIME;
            case 29 -> JDBCType.TIMESTAMP;
            case 30 -> JDBCTypeExt.DateTimeOffset;
            case 31 -> throw new NotImplementedError("Structured types are not supported");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final int convert(int jdbcType) {
        int n;
        int n2;
        Integer n3 = JDBCType.BIT.getVendorTypeNumber();
        if (n3 != null && (n2 = jdbcType) == n3) {
            n = SqlServerType.Bit.getVendorTypeNumber();
        } else {
            Integer n4 = JDBCType.TINYINT.getVendorTypeNumber();
            if (n4 != null && n2 == n4) {
                n = SqlServerType.TinyInt.getVendorTypeNumber();
            } else {
                Integer n5 = JDBCType.SMALLINT.getVendorTypeNumber();
                if (n5 != null && n2 == n5) {
                    n = SqlServerType.SmallInt.getVendorTypeNumber();
                } else {
                    Integer n6 = JDBCType.INTEGER.getVendorTypeNumber();
                    if (n6 != null && n2 == n6) {
                        n = SqlServerType.Int.getVendorTypeNumber();
                    } else {
                        Integer n7 = JDBCType.BIGINT.getVendorTypeNumber();
                        if (n7 != null && n2 == n7) {
                            n = SqlServerType.BigInt.getVendorTypeNumber();
                        } else {
                            Integer n8 = JDBCType.FLOAT.getVendorTypeNumber();
                            if (n8 != null && n2 == n8) {
                                n = SqlServerType.Float.getVendorTypeNumber();
                            } else {
                                Integer n9 = JDBCType.REAL.getVendorTypeNumber();
                                if (n9 != null && n2 == n9) {
                                    n = SqlServerType.Real.getVendorTypeNumber();
                                } else {
                                    Integer n10 = JDBCType.DOUBLE.getVendorTypeNumber();
                                    if (n10 != null && n2 == n10) {
                                        n = SqlServerType.Float.getVendorTypeNumber();
                                    } else {
                                        Integer n11 = JDBCType.NUMERIC.getVendorTypeNumber();
                                        if (n11 != null && n2 == n11) {
                                            n = SqlServerType.Decimal.getVendorTypeNumber();
                                        } else {
                                            Integer n12 = JDBCType.DECIMAL.getVendorTypeNumber();
                                            if (n12 != null && n2 == n12) {
                                                n = SqlServerType.Decimal.getVendorTypeNumber();
                                            } else {
                                                Integer n13 = JDBCType.CHAR.getVendorTypeNumber();
                                                if (n13 != null && n2 == n13) {
                                                    n = SqlServerType.Char.getVendorTypeNumber();
                                                } else {
                                                    Integer n14 = JDBCType.VARCHAR.getVendorTypeNumber();
                                                    if (n14 != null && n2 == n14) {
                                                        n = SqlServerType.VarChar.getVendorTypeNumber();
                                                    } else {
                                                        Integer n15 = JDBCType.LONGVARCHAR.getVendorTypeNumber();
                                                        if (n15 != null && n2 == n15) {
                                                            n = SqlServerType.Text.getVendorTypeNumber();
                                                        } else {
                                                            Integer n16 = JDBCType.DATE.getVendorTypeNumber();
                                                            if (n16 != null && n2 == n16) {
                                                                n = SqlServerType.Date.getVendorTypeNumber();
                                                            } else {
                                                                Integer n17 = JDBCType.TIME.getVendorTypeNumber();
                                                                if (n17 != null && n2 == n17) {
                                                                    n = SqlServerType.Time.getVendorTypeNumber();
                                                                } else {
                                                                    Integer n18 = JDBCType.TIMESTAMP.getVendorTypeNumber();
                                                                    if (n18 != null && n2 == n18) {
                                                                        n = SqlServerType.DateTime2.getVendorTypeNumber();
                                                                    } else {
                                                                        Integer n19 = JDBCType.BINARY.getVendorTypeNumber();
                                                                        if (n19 != null && n2 == n19) {
                                                                            n = SqlServerType.Binary.getVendorTypeNumber();
                                                                        } else {
                                                                            Integer n20 = JDBCType.VARBINARY.getVendorTypeNumber();
                                                                            if (n20 != null && n2 == n20) {
                                                                                n = SqlServerType.VarBinary.getVendorTypeNumber();
                                                                            } else {
                                                                                Integer n21 = JDBCType.LONGVARBINARY.getVendorTypeNumber();
                                                                                if (n21 != null && n2 == n21) {
                                                                                    n = SqlServerType.Image.getVendorTypeNumber();
                                                                                } else {
                                                                                    Integer n22 = JDBCType.BLOB.getVendorTypeNumber();
                                                                                    if (n22 != null && n2 == n22) {
                                                                                        n = SqlServerType.Image.getVendorTypeNumber();
                                                                                    } else {
                                                                                        Integer n23 = JDBCType.CLOB.getVendorTypeNumber();
                                                                                        if (n23 != null && n2 == n23) {
                                                                                            n = SqlServerType.Text.getVendorTypeNumber();
                                                                                        } else {
                                                                                            Integer n24 = JDBCType.BOOLEAN.getVendorTypeNumber();
                                                                                            if (n24 != null && n2 == n24) {
                                                                                                n = SqlServerType.Bit.getVendorTypeNumber();
                                                                                            } else {
                                                                                                Integer n25 = JDBCType.NCHAR.getVendorTypeNumber();
                                                                                                if (n25 != null && n2 == n25) {
                                                                                                    n = SqlServerType.NChar.getVendorTypeNumber();
                                                                                                } else {
                                                                                                    Integer n26 = JDBCType.NVARCHAR.getVendorTypeNumber();
                                                                                                    if (n26 != null && n2 == n26) {
                                                                                                        n = SqlServerType.NVarChar.getVendorTypeNumber();
                                                                                                    } else {
                                                                                                        Integer n27 = JDBCType.LONGNVARCHAR.getVendorTypeNumber();
                                                                                                        if (n27 != null && n2 == n27) {
                                                                                                            n = SqlServerType.NText.getVendorTypeNumber();
                                                                                                        } else {
                                                                                                            Integer n28 = JDBCType.NCLOB.getVendorTypeNumber();
                                                                                                            if (n28 != null && n2 == n28) {
                                                                                                                n = SqlServerType.NText.getVendorTypeNumber();
                                                                                                            } else {
                                                                                                                Integer n29 = JDBCType.SQLXML.getVendorTypeNumber();
                                                                                                                if (n29 != null && n2 == n29) {
                                                                                                                    n = SqlServerType.Xml.getVendorTypeNumber();
                                                                                                                } else {
                                                                                                                    Integer n30 = JDBCType.TIME_WITH_TIMEZONE.getVendorTypeNumber();
                                                                                                                    if (n30 != null && n2 == n30) {
                                                                                                                        n = SqlServerType.DateTimeOffset.getVendorTypeNumber();
                                                                                                                    } else {
                                                                                                                        Integer n31 = JDBCType.TIMESTAMP_WITH_TIMEZONE.getVendorTypeNumber();
                                                                                                                        if (n31 != null && n2 == n31) {
                                                                                                                            n = SqlServerType.DateTimeOffset.getVendorTypeNumber();
                                                                                                                        } else {
                                                                                                                            Integer n32 = JDBCType.OTHER.getVendorTypeNumber();
                                                                                                                            if (n32 != null && n2 == n32) {
                                                                                                                                n = SqlServerType.Variant.getVendorTypeNumber();
                                                                                                                            } else {
                                                                                                                                Integer n33 = JDBCType.NULL.getVendorTypeNumber();
                                                                                                                                if (n33 != null && n2 == n33) {
                                                                                                                                    n = SqlServerType.VarChar.getVendorTypeNumber();
                                                                                                                                } else if (n2 == JDBCTypeExt.DateTimeOffset.getVendorTypeNumber()) {
                                                                                                                                    n = SqlServerType.DateTimeOffset.getVendorTypeNumber();
                                                                                                                                } else {
                                                                                                                                    boolean bl;
                                                                                                                                    boolean bl2;
                                                                                                                                    boolean bl3;
                                                                                                                                    boolean bl4;
                                                                                                                                    boolean bl5;
                                                                                                                                    boolean bl6;
                                                                                                                                    boolean bl7;
                                                                                                                                    Integer n34 = JDBCType.JAVA_OBJECT.getVendorTypeNumber();
                                                                                                                                    if (n34 != null && n2 == n34) {
                                                                                                                                        bl7 = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n35 = JDBCType.DISTINCT.getVendorTypeNumber();
                                                                                                                                        bl7 = n35 != null && n2 == n35;
                                                                                                                                    }
                                                                                                                                    if (bl7) {
                                                                                                                                        bl6 = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n36 = JDBCType.STRUCT.getVendorTypeNumber();
                                                                                                                                        bl6 = n36 != null && n2 == n36;
                                                                                                                                    }
                                                                                                                                    if (bl6) {
                                                                                                                                        bl5 = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n37 = JDBCType.ARRAY.getVendorTypeNumber();
                                                                                                                                        bl5 = n37 != null && n2 == n37;
                                                                                                                                    }
                                                                                                                                    if (bl5) {
                                                                                                                                        bl4 = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n38 = JDBCType.REF.getVendorTypeNumber();
                                                                                                                                        bl4 = n38 != null && n2 == n38;
                                                                                                                                    }
                                                                                                                                    if (bl4) {
                                                                                                                                        bl3 = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n39 = JDBCType.DATALINK.getVendorTypeNumber();
                                                                                                                                        bl3 = n39 != null && n2 == n39;
                                                                                                                                    }
                                                                                                                                    if (bl3) {
                                                                                                                                        bl2 = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n40 = JDBCType.ROWID.getVendorTypeNumber();
                                                                                                                                        bl2 = n40 != null && n2 == n40;
                                                                                                                                    }
                                                                                                                                    if (bl2) {
                                                                                                                                        bl = true;
                                                                                                                                    } else {
                                                                                                                                        Integer n41 = JDBCType.REF_CURSOR.getVendorTypeNumber();
                                                                                                                                        bl = n41 != null && n2 == n41;
                                                                                                                                    }
                                                                                                                                    if (bl) {
                                                                                                                                        throw ExceptionsKt.unsupportedJdbcType(jdbcType);
                                                                                                                                    }
                                                                                                                                    throw ExceptionsKt.unsupportedJdbcType(jdbcType);
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlServerType.values().length];
            try {
                nArray[SqlServerType.BigInt.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Binary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Bit.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Char.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.DateTime.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Decimal.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Float.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Image.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Int.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Money.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.NChar.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.NText.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.NVarChar.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Real.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.UniqueIdentifier.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.SmallDateTime.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.SmallInt.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.SmallMoney.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Text.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Timestamp.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.TinyInt.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.VarBinary.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.VarChar.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Variant.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Xml.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Udt.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Date.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Time.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.DateTime2.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.DateTimeOffset.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Structured.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

