/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.sqlserver;

import com.jetbrains.jdbc.base.models.sql.xml.ProtocolXml;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToJavaTypeTranslator;
import com.jetbrains.jdbc.sqlserver.converters.SqlServerType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/jdbc/sqlserver/SqlServerJdbcToJavaTypeTranslator;", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToJavaTypeTranslator;", "()V", "fromNativeToJava", "", "nativeType", "", "Frontend"})
public final class SqlServerJdbcToJavaTypeTranslator
implements IJdbcToJavaTypeTranslator {
    @NotNull
    public static final SqlServerJdbcToJavaTypeTranslator INSTANCE = new SqlServerJdbcToJavaTypeTranslator();

    private SqlServerJdbcToJavaTypeTranslator() {
    }

    @Override
    @NotNull
    public String fromNativeToJava(int nativeType) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[SqlServerType.Companion.valueOf(nativeType).ordinal()]) {
            case 1: {
                String string2 = Long.class.getName();
                string = string2;
                Intrinsics.checkNotNullExpressionValue(string2, "java.lang.Long::class.java.name");
                break;
            }
            case 2: {
                String string3 = byte[].class.getName();
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "ByteArray::class.java.name");
                break;
            }
            case 3: {
                String string4 = Boolean.class.getName();
                string = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "java.lang.Boolean::class.java.name");
                break;
            }
            case 4: {
                String string5 = String.class.getName();
                string = string5;
                Intrinsics.checkNotNullExpressionValue(string5, "String::class.java.name");
                break;
            }
            case 5: {
                String string6 = Timestamp.class.getName();
                string = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "Timestamp::class.java.name");
                break;
            }
            case 6: {
                String string7 = BigDecimal.class.getName();
                string = string7;
                Intrinsics.checkNotNullExpressionValue(string7, "BigDecimal::class.java.name");
                break;
            }
            case 7: {
                String string8 = Double.class.getName();
                string = string8;
                Intrinsics.checkNotNullExpressionValue(string8, "java.lang.Double::class.java.name");
                break;
            }
            case 8: {
                String string9 = byte[].class.getName();
                string = string9;
                Intrinsics.checkNotNullExpressionValue(string9, "ByteArray::class.java.name");
                break;
            }
            case 9: {
                String string10 = Integer.class.getName();
                string = string10;
                Intrinsics.checkNotNullExpressionValue(string10, "java.lang.Integer::class.java.name");
                break;
            }
            case 10: {
                String string11 = BigDecimal.class.getName();
                string = string11;
                Intrinsics.checkNotNullExpressionValue(string11, "BigDecimal::class.java.name");
                break;
            }
            case 11: {
                String string12 = String.class.getName();
                string = string12;
                Intrinsics.checkNotNullExpressionValue(string12, "String::class.java.name");
                break;
            }
            case 12: {
                String string13 = String.class.getName();
                string = string13;
                Intrinsics.checkNotNullExpressionValue(string13, "String::class.java.name");
                break;
            }
            case 13: {
                String string14 = String.class.getName();
                string = string14;
                Intrinsics.checkNotNullExpressionValue(string14, "String::class.java.name");
                break;
            }
            case 14: {
                String string15 = Float.class.getName();
                string = string15;
                Intrinsics.checkNotNullExpressionValue(string15, "java.lang.Float::class.java.name");
                break;
            }
            case 15: {
                String string16 = UUID.class.getName();
                string = string16;
                Intrinsics.checkNotNullExpressionValue(string16, "UUID::class.java.name");
                break;
            }
            case 16: {
                String string17 = Timestamp.class.getName();
                string = string17;
                Intrinsics.checkNotNullExpressionValue(string17, "Timestamp::class.java.name");
                break;
            }
            case 17: {
                String string18 = Short.class.getName();
                string = string18;
                Intrinsics.checkNotNullExpressionValue(string18, "java.lang.Short::class.java.name");
                break;
            }
            case 18: {
                String string19 = BigDecimal.class.getName();
                string = string19;
                Intrinsics.checkNotNullExpressionValue(string19, "BigDecimal::class.java.name");
                break;
            }
            case 19: {
                String string20 = String.class.getName();
                string = string20;
                Intrinsics.checkNotNullExpressionValue(string20, "String::class.java.name");
                break;
            }
            case 20: {
                String string21 = byte[].class.getName();
                string = string21;
                Intrinsics.checkNotNullExpressionValue(string21, "ByteArray::class.java.name");
                break;
            }
            case 21: {
                String string22 = Short.class.getName();
                string = string22;
                Intrinsics.checkNotNullExpressionValue(string22, "java.lang.Short::class.java.name");
                break;
            }
            case 22: {
                String string23 = byte[].class.getName();
                string = string23;
                Intrinsics.checkNotNullExpressionValue(string23, "ByteArray::class.java.name");
                break;
            }
            case 23: {
                String string24 = String.class.getName();
                string = string24;
                Intrinsics.checkNotNullExpressionValue(string24, "String::class.java.name");
                break;
            }
            case 24: {
                String string25 = Object.class.getName();
                string = string25;
                Intrinsics.checkNotNullExpressionValue(string25, "Any::class.java.name");
                break;
            }
            case 25: {
                String string26 = ProtocolXml.class.getName();
                string = string26;
                Intrinsics.checkNotNullExpressionValue(string26, "ProtocolXml::class.java.name");
                break;
            }
            case 26: {
                String string27 = byte[].class.getName();
                string = string27;
                Intrinsics.checkNotNullExpressionValue(string27, "ByteArray::class.java.name");
                break;
            }
            case 27: {
                String string28 = Date.class.getName();
                string = string28;
                Intrinsics.checkNotNullExpressionValue(string28, "Date::class.java.name");
                break;
            }
            case 28: {
                String string29 = Time.class.getName();
                string = string29;
                Intrinsics.checkNotNullExpressionValue(string29, "Time::class.java.name");
                break;
            }
            case 29: {
                String string30 = Timestamp.class.getName();
                string = string30;
                Intrinsics.checkNotNullExpressionValue(string30, "Timestamp::class.java.name");
                break;
            }
            case 30: {
                String string31 = OffsetDateTime.class.getName();
                string = string31;
                Intrinsics.checkNotNullExpressionValue(string31, "OffsetDateTime::class.java.name");
                break;
            }
            case 31: {
                throw new NotImplementedError("Structured types are not supported");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SqlServerType.values().length];
            try {
                nArray[SqlServerType.BigInt.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Binary.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Bit.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Char.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.DateTime.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Decimal.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Float.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Image.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Int.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Money.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.NChar.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.NText.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.NVarChar.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Real.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.UniqueIdentifier.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.SmallDateTime.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.SmallInt.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.SmallMoney.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Text.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Timestamp.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.TinyInt.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.VarBinary.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.VarChar.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Variant.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Xml.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Udt.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Date.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Time.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.DateTime2.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.DateTimeOffset.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SqlServerType.Structured.ordinal()] = 31;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

