/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.translators;

import com.jetbrains.jdbc.base.models.RdConnectionProperty;
import com.jetbrains.jdbc.base.models.RdDriverPropertyInfo;
import com.jetbrains.jdbc.base.models.RdResultSetRowStatus;
import com.jetbrains.jdbc.base.resultsets.models.ResultSetRowStatus;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\u0002\u0010\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"toDriverProperties", "", "Ljava/sql/DriverPropertyInfo;", "Lcom/jetbrains/jdbc/base/models/RdDriverPropertyInfo;", "([Lcom/jetbrains/jdbc/base/models/RdDriverPropertyInfo;)[Ljava/sql/DriverPropertyInfo;", "toModel", "Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRowStatus;", "Lcom/jetbrains/jdbc/base/models/RdResultSetRowStatus;", "toRdConnectionProperties", "Lcom/jetbrains/jdbc/base/models/RdConnectionProperty;", "Ljava/util/Properties;", "(Ljava/util/Properties;)[Lcom/jetbrains/jdbc/base/models/RdConnectionProperty;", "Frontend"})
@SourceDebugExtension(value={"SMAP\nTranslators.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Translators.kt\ncom/jetbrains/jdbc/base/utils/translators/TranslatorsKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,44:1\n37#2,2:45\n37#2,2:47\n*S KotlinDebug\n*F\n+ 1 Translators.kt\ncom/jetbrains/jdbc/base/utils/translators/TranslatorsKt\n*L\n17#1:45,2\n32#1:47,2\n*E\n"})
public final class TranslatorsKt {
    @NotNull
    public static final RdConnectionProperty[] toRdConnectionProperties(@NotNull Properties $this$toRdConnectionProperties) {
        Intrinsics.checkNotNullParameter($this$toRdConnectionProperties, "<this>");
        List rdProperties = new ArrayList();
        for (Map.Entry prop : ((Map)$this$toRdConnectionProperties).entrySet()) {
            rdProperties.add(new RdConnectionProperty(prop.getKey().toString(), prop.getValue().toString()));
        }
        Collection $this$toTypedArray$iv = rdProperties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new RdConnectionProperty[0]);
    }

    @NotNull
    public static final DriverPropertyInfo[] toDriverProperties(@NotNull RdDriverPropertyInfo[] $this$toDriverProperties) {
        Intrinsics.checkNotNullParameter($this$toDriverProperties, "<this>");
        List driverProperties = new ArrayList();
        for (RdDriverPropertyInfo prop : $this$toDriverProperties) {
            DriverPropertyInfo driverProperty = new DriverPropertyInfo(prop.getName(), prop.getValue());
            driverProperty.description = prop.getDescription();
            driverProperty.choices = prop.getChoices();
            driverProperty.required = prop.getRequired();
            driverProperties.add(driverProperty);
        }
        Collection $this$toTypedArray$iv = driverProperties;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new DriverPropertyInfo[0]);
    }

    @NotNull
    public static final ResultSetRowStatus toModel(@NotNull RdResultSetRowStatus $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, "<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toModel.ordinal()]) {
            case 1 -> ResultSetRowStatus.Deleted;
            case 2 -> ResultSetRowStatus.Inserted;
            case 3 -> ResultSetRowStatus.Updated;
            case 4 -> ResultSetRowStatus.Untouched;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdResultSetRowStatus.values().length];
            try {
                nArray[RdResultSetRowStatus.Deleted.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdResultSetRowStatus.Inserted.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdResultSetRowStatus.Updated.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdResultSetRowStatus.NotTouched.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

