/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol.pooling;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdConnection;
import com.jetbrains.jdbc.base.models.RdParsedStatement;
import com.jetbrains.jdbc.base.models.RdStatement;
import com.jetbrains.jdbc.base.models.RdStatementWithParams;
import com.jetbrains.jdbc.base.models.RdStatementWithParamsInitialState;
import com.jetbrains.jdbc.base.utils.protocol.ProtocolUtilsKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.InitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.ProtocolPool;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00050\u00042\u00020\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ5\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\nH$\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u0005H$\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u0005H$J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\rH$J3\u0010%\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0002\u0010&J\u0013\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00028\u0000\u00a2\u0006\u0002\u0010)R'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/jetbrains/jdbc/base/utils/protocol/pooling/StatementWithParamsPool;", "T", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;", "TResponse", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/InitializationData;", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParamsInitialState;", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/ProtocolPool;", "model", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "poolSize", "", "(Lcom/jetbrains/jdbc/base/models/JdbcModel;I)V", "storage", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "getStorage", "()Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "storage$delegate", "Lkotlin/Lazy;", "createInitialState", "rdStatement", "parsedStatement", "Lcom/jetbrains/jdbc/base/models/RdParsedStatement;", "type", "concurrency", "holdability", "(Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;Lcom/jetbrains/jdbc/base/models/RdParsedStatement;III)Lcom/jetbrains/jdbc/base/models/RdStatementWithParamsInitialState;", "createRdStatement", "id", "(I)Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;", "createResponse", "state", "(Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;Lcom/jetbrains/jdbc/base/models/RdStatementWithParamsInitialState;)Lcom/jetbrains/jdbc/base/utils/protocol/initialization/InitializationData;", "fireCreateStatement", "", "connection", "Lcom/jetbrains/jdbc/base/models/RdConnection;", "getStatementStorage", "rent", "(Lcom/jetbrains/jdbc/base/models/RdConnection;Lcom/jetbrains/jdbc/base/models/RdParsedStatement;III)Lcom/jetbrains/jdbc/base/utils/protocol/initialization/InitializationData;", "returnStatement", "statement", "(Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;)V", "Frontend"})
public abstract class StatementWithParamsPool<T extends RdStatementWithParams, TResponse extends InitializationData<T, RdStatementWithParamsInitialState>>
extends ProtocolPool {
    @NotNull
    private final Lazy storage$delegate;

    public StatementWithParamsPool(@NotNull JdbcModel model, int poolSize) {
        Intrinsics.checkNotNullParameter(model, "model");
        super(model, poolSize);
        this.storage$delegate = LazyKt.lazy(new Function0<IMutableViewableMap<Integer, T>>(this){
            final /* synthetic */ StatementWithParamsPool<T, TResponse> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IMutableViewableMap<Integer, T> invoke() {
                return this.this$0.getStatementStorage();
            }
        });
    }

    private final IMutableViewableMap<Integer, T> getStorage() {
        Lazy lazy = this.storage$delegate;
        return (IMutableViewableMap)lazy.getValue();
    }

    @NotNull
    public final TResponse rent(@NotNull RdConnection connection, @NotNull RdParsedStatement parsedStatement, int type2, int concurrency, int holdability) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(parsedStatement, "parsedStatement");
        return (TResponse)((InitializationData)ProtocolUtilsKt.queueAndWait(this.getScheduler(), new Function0<TResponse>(this, parsedStatement, type2, concurrency, holdability, connection){
            final /* synthetic */ StatementWithParamsPool<T, TResponse> this$0;
            final /* synthetic */ RdParsedStatement $parsedStatement;
            final /* synthetic */ int $type;
            final /* synthetic */ int $concurrency;
            final /* synthetic */ int $holdability;
            final /* synthetic */ RdConnection $connection;
            {
                this.this$0 = $receiver;
                this.$parsedStatement = $parsedStatement;
                this.$type = $type;
                this.$concurrency = $concurrency;
                this.$holdability = $holdability;
                this.$connection = $connection;
                super(0);
            }

            @NotNull
            public final TResponse invoke() {
                RdStatementWithParams statement;
                if (this.this$0.getFreeObjects().isEmpty()) {
                    StatementWithParamsPool<T, TResponse> statementWithParamsPool = this.this$0;
                    statementWithParamsPool.setObjectId(statementWithParamsPool.getObjectId() + 1);
                    T statement2 = this.this$0.createRdStatement(statementWithParamsPool.getObjectId());
                    RdStatementWithParamsInitialState state = StatementWithParamsPool.access$createInitialState(this.this$0, statement2, this.$parsedStatement, this.$type, this.$concurrency, this.$holdability);
                    ((Map)StatementWithParamsPool.access$getStorage(this.this$0)).put(((RdStatement)statement2).getId(), statement2);
                    this.this$0.fireCreateStatement(this.$connection, state);
                    return this.this$0.createResponse(statement2, state);
                }
                Integer statementId = this.this$0.getFreeObjects().removeFirst();
                RdStatementWithParams rdStatementWithParams = statement = (RdStatementWithParams)StatementWithParamsPool.access$getStorage(this.this$0).get(statementId);
                Intrinsics.checkNotNull(rdStatementWithParams);
                RdStatementWithParamsInitialState state = StatementWithParamsPool.access$createInitialState(this.this$0, rdStatementWithParams, this.$parsedStatement, this.$type, this.$concurrency, this.$holdability);
                this.this$0.fireCreateStatement(this.$connection, state);
                V v = StatementWithParamsPool.access$getStorage(this.this$0).get(statementId);
                Intrinsics.checkNotNull(v);
                return this.this$0.createResponse((RdStatementWithParams)v, state);
            }
        }));
    }

    public final void returnStatement(@NotNull T statement) {
        Intrinsics.checkNotNullParameter(statement, "statement");
        ProtocolUtilsKt.queueAndWait(this.getScheduler(), (Function0)new Function0<Object>(this, statement){
            final /* synthetic */ StatementWithParamsPool<T, TResponse> this$0;
            final /* synthetic */ T $statement;
            {
                this.this$0 = $receiver;
                this.$statement = $statement;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                Object object;
                if (this.this$0.getFreeObjects().size() >= this.this$0.getPoolSize()) {
                    object = StatementWithParamsPool.access$getStorage(this.this$0).remove(((RdStatement)this.$statement).getId());
                } else {
                    ((RdStatement)this.$statement).getClose().fire(Unit.INSTANCE);
                    this.this$0.getFreeObjects().addLast(((RdStatement)this.$statement).getId());
                    object = Unit.INSTANCE;
                }
                return object;
            }
        });
    }

    private final RdStatementWithParamsInitialState createInitialState(T rdStatement, RdParsedStatement parsedStatement, int type2, int concurrency, int holdability) {
        return new RdStatementWithParamsInitialState(parsedStatement, 0, 0, 100, 1002, 0, type2, concurrency, holdability, ((RdStatement)rdStatement).getId());
    }

    @NotNull
    protected abstract T createRdStatement(int var1);

    @NotNull
    protected abstract TResponse createResponse(@NotNull T var1, @NotNull RdStatementWithParamsInitialState var2);

    protected abstract void fireCreateStatement(@NotNull RdConnection var1, @NotNull RdStatementWithParamsInitialState var2);

    @NotNull
    protected abstract IMutableViewableMap<Integer, T> getStatementStorage();

    public static final /* synthetic */ RdStatementWithParamsInitialState access$createInitialState(StatementWithParamsPool $this, RdStatementWithParams rdStatement, RdParsedStatement parsedStatement, int type2, int concurrency, int holdability) {
        return $this.createInitialState(rdStatement, parsedStatement, type2, concurrency, holdability);
    }

    public static final /* synthetic */ IMutableViewableMap access$getStorage(StatementWithParamsPool $this) {
        return $this.getStorage();
    }
}

