/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.protocol;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdEntityCreated;
import com.jetbrains.jdbc.base.models.RdExecutionResult;
import com.jetbrains.jdbc.base.models.RdResultSet;
import com.jetbrains.jdbc.base.models.RdResultSetExecutionResult;
import com.jetbrains.jdbc.base.models.RdResultSetInitialState;
import com.jetbrains.jdbc.base.models.RdStatement;
import com.jetbrains.jdbc.base.models.RdUpdateCountExecutionResult;
import com.jetbrains.jdbc.base.statements.models.ExecutionResult;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.InitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ResultSetInitializationData;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.IViewableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001aC\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\u0099\u0001\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u0002\"\b\b\u0001\u0010\u000b*\u00020\f\"\b\b\u0002\u0010\r*\u00020\u000e\"\u0014\b\u0003\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\r0\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u000b0\u00122\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u00010\u0015\u00a2\u0006\u0002\u0010\u0016\u001a+\u0010\u0017\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001a2\u0006\u0010\u0005\u001a\u0002H\u00192\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001b\u001a\u001c\u0010\u0017\u001a\u00020\u0018*\f\u0012\u0004\u0012\u00020\u00180\u001aj\u0002`\u001c2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001b\u0010\u001d\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190\u001e\u00a2\u0006\u0002\u0010\u001f\u001a#\u0010 \u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u0019*\u00020\u00072\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u00190\"\u00a2\u0006\u0002\u0010#\u001a+\u0010$\u001a\u00020\u0018\"\u0004\b\u0000\u0010\u0019*\b\u0012\u0004\u0012\u0002H\u00190%2\u0006\u0010&\u001a\u0002H\u00192\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010'\u001aA\u0010\u0000\u001a\u00020(\"\u0004\b\u0000\u0010\u0002*\u00020)2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\u00022\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020+0\t2\u0006\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.\u001a7\u0010/\u001a\u0002H0\"\u0004\b\u0000\u0010\u0019\"\u0004\b\u0001\u00100*\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u0002H00\t2\u0006\u0010\u0005\u001a\u0002H\u00192\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u00101\u00a8\u00062"}, d2={"sync", "TResponse", "TRequest", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "request", "scheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "syncCall", "Lcom/jetbrains/rd/framework/IRdCall;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/IScheduler;Lcom/jetbrains/rd/framework/IRdCall;)Ljava/lang/Object;", "TRd", "", "TState", "Lcom/jetbrains/jdbc/base/models/RdEntityCreated;", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/InitializationData;", "getEntityIdCall", "entitySource", "Lcom/jetbrains/rd/util/reactive/IViewableMap;", "", "constructResponse", "Lkotlin/Function2;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/IScheduler;Lcom/jetbrains/rd/framework/IRdCall;Lcom/jetbrains/rd/util/reactive/IViewableMap;Lkotlin/jvm/functions/Function2;)Lcom/jetbrains/jdbc/base/utils/protocol/initialization/InitializationData;", "fireOnScheduler", "", "T", "Lcom/jetbrains/rd/util/reactive/ISignal;", "(Lcom/jetbrains/rd/util/reactive/ISignal;Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/IScheduler;)V", "Lcom/jetbrains/rd/util/reactive/IVoidSignal;", "getOrThrow", "Ljava/util/concurrent/CompletableFuture;", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "queueAndWait", "func", "Lkotlin/Function0;", "(Lcom/jetbrains/rd/util/reactive/IScheduler;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "setOnScheduler", "Lcom/jetbrains/rd/util/reactive/IMutablePropertyBase;", "newValue", "(Lcom/jetbrains/rd/util/reactive/IMutablePropertyBase;Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/IScheduler;)V", "Lcom/jetbrains/jdbc/base/statements/models/ExecutionResult;", "Lcom/jetbrains/jdbc/base/models/RdStatement;", "executeCall", "Lcom/jetbrains/jdbc/base/models/RdExecutionResult;", "rdModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "(Lcom/jetbrains/jdbc/base/models/RdStatement;Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;Lcom/jetbrains/rd/framework/IRdCall;Lcom/jetbrains/jdbc/base/models/JdbcModel;)Lcom/jetbrains/jdbc/base/statements/models/ExecutionResult;", "syncOnScheduler", "R", "(Lcom/jetbrains/rd/framework/IRdCall;Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/IScheduler;)Ljava/lang/Object;", "Frontend"})
public final class ProtocolUtilsKt {
    public static final <T, R> R syncOnScheduler(@NotNull IRdCall<? super T, ? extends R> $this$syncOnScheduler, T request, @NotNull IScheduler scheduler) {
        Intrinsics.checkNotNullParameter($this$syncOnScheduler, "<this>");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        return (R)ProtocolUtilsKt.queueAndWait(scheduler, new Function0<R>($this$syncOnScheduler, request){
            final /* synthetic */ IRdCall<T, R> $this_syncOnScheduler;
            final /* synthetic */ T $request;
            {
                this.$this_syncOnScheduler = $receiver;
                this.$request = $request;
                super(0);
            }

            public final R invoke() {
                return (R)IRdCall.DefaultImpls.sync$default(this.$this_syncOnScheduler, this.$request, null, 2, null);
            }
        });
    }

    public static final <T> void fireOnScheduler(@NotNull ISignal<T> $this$fireOnScheduler, T request, @NotNull IScheduler scheduler) {
        Intrinsics.checkNotNullParameter($this$fireOnScheduler, "<this>");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        scheduler.queue(new Function0<Unit>($this$fireOnScheduler, request){
            final /* synthetic */ ISignal<T> $this_fireOnScheduler;
            final /* synthetic */ T $request;
            {
                this.$this_fireOnScheduler = $receiver;
                this.$request = $request;
                super(0);
            }

            public final void invoke() {
                this.$this_fireOnScheduler.fire(this.$request);
            }
        });
    }

    public static final void fireOnScheduler(@NotNull ISignal<Unit> $this$fireOnScheduler, @NotNull IScheduler scheduler) {
        Intrinsics.checkNotNullParameter($this$fireOnScheduler, "<this>");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        scheduler.queue(new Function0<Unit>($this$fireOnScheduler){
            final /* synthetic */ ISignal<Unit> $this_fireOnScheduler;
            {
                this.$this_fireOnScheduler = $receiver;
                super(0);
            }

            public final void invoke() {
                this.$this_fireOnScheduler.fire(Unit.INSTANCE);
            }
        });
    }

    public static final <T> void setOnScheduler(@NotNull IMutablePropertyBase<T> $this$setOnScheduler, T newValue, @NotNull IScheduler scheduler) {
        Intrinsics.checkNotNullParameter($this$setOnScheduler, "<this>");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        scheduler.queue(new Function0<Unit>($this$setOnScheduler, newValue){
            final /* synthetic */ IMutablePropertyBase<T> $this_setOnScheduler;
            final /* synthetic */ T $newValue;
            {
                this.$this_setOnScheduler = $receiver;
                this.$newValue = $newValue;
                super(0);
            }

            public final void invoke() {
                this.$this_setOnScheduler.set(this.$newValue);
            }
        });
    }

    public static final <T> T queueAndWait(@NotNull IScheduler $this$queueAndWait, @NotNull Function0<? extends T> func) {
        Intrinsics.checkNotNullParameter($this$queueAndWait, "<this>");
        Intrinsics.checkNotNullParameter(func, "func");
        if ($this$queueAndWait.isActive()) {
            try {
                return func.invoke();
            }
            catch (Exception exception) {
                throw ExceptionsKt.wrapException(exception);
            }
        }
        CompletableFuture future = new CompletableFuture();
        $this$queueAndWait.queue(new Function0<Unit>($this$queueAndWait, func, future){
            final /* synthetic */ IScheduler $this_queueAndWait;
            final /* synthetic */ Function0<T> $func;
            final /* synthetic */ CompletableFuture<T> $future;
            {
                this.$this_queueAndWait = $receiver;
                this.$func = $func;
                this.$future = $future;
                super(0);
            }

            public final void invoke() {
                IScheduler iScheduler = this.$this_queueAndWait;
                Function0<T> function0 = this.$func;
                CompletableFuture<T> completableFuture = this.$future;
                IScheduler $this$invoke_u24lambda_u240 = iScheduler;
                boolean bl = false;
                try {
                    T result2 = function0.invoke();
                    completableFuture.complete(result2);
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
        return ProtocolUtilsKt.getOrThrow(future);
    }

    public static final <T> T getOrThrow(@NotNull CompletableFuture<T> $this$getOrThrow) {
        Intrinsics.checkNotNullParameter($this$getOrThrow, "<this>");
        try {
            return $this$getOrThrow.get();
        }
        catch (ExecutionException ex) {
            Throwable throwable = ex.getCause();
            if (throwable == null) {
                throwable = ex;
            }
            throw ExceptionsKt.wrapException(throwable);
        }
    }

    @Nullable
    public static final <TRequest, TRd, TState extends RdEntityCreated, TResponse extends InitializationData<TRd, TState>> TResponse sync(@NotNull Lifetime lifetime, TRequest request, @NotNull IScheduler scheduler, @NotNull IRdCall<? super TRequest, ? extends TState> getEntityIdCall, @NotNull IViewableMap<Integer, ? extends TRd> entitySource, @NotNull Function2<? super TRd, ? super TState, ? extends TResponse> constructResponse) {
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        Intrinsics.checkNotNullParameter(getEntityIdCall, "getEntityIdCall");
        Intrinsics.checkNotNullParameter(entitySource, "entitySource");
        Intrinsics.checkNotNullParameter(constructResponse, "constructResponse");
        CompletableFuture future = new CompletableFuture();
        scheduler.invokeOrQueue(new Function0<Unit>(getEntityIdCall, lifetime, request, future, constructResponse, entitySource){
            final /* synthetic */ IRdCall<TRequest, TState> $getEntityIdCall;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ TRequest $request;
            final /* synthetic */ CompletableFuture<TResponse> $future;
            final /* synthetic */ Function2<TRd, TState, TResponse> $constructResponse;
            final /* synthetic */ IViewableMap<Integer, TRd> $entitySource;
            {
                this.$getEntityIdCall = $getEntityIdCall;
                this.$lifetime = $lifetime;
                this.$request = $request;
                this.$future = $future;
                this.$constructResponse = $constructResponse;
                this.$entitySource = $entitySource;
                super(0);
            }

            public final void invoke() {
                try {
                    IRdTask rdTask = IRdCall.DefaultImpls.start$default(this.$getEntityIdCall, this.$lifetime, this.$request, null, 4, null);
                    rdTask.getResult().advise(this.$lifetime, (Function1)new Function1<RdTaskResult<? extends TState>, Unit>(this.$future, this.$constructResponse, this.$entitySource){
                        final /* synthetic */ CompletableFuture<TResponse> $future;
                        final /* synthetic */ Function2<TRd, TState, TResponse> $constructResponse;
                        final /* synthetic */ IViewableMap<Integer, TRd> $entitySource;
                        {
                            this.$future = $future;
                            this.$constructResponse = $constructResponse;
                            this.$entitySource = $entitySource;
                            super(1);
                        }

                        public final void invoke(@NotNull RdTaskResult<? extends TState> rdTaskResult) {
                            Intrinsics.checkNotNullParameter(rdTaskResult, "rdTaskResult");
                            RdTaskResult<? extends TState> rdTaskResult2 = rdTaskResult;
                            if (rdTaskResult2 instanceof RdTaskResult.Success) {
                                RdEntityCreated rdEntityCreated = (RdEntityCreated)((RdTaskResult.Success)rdTaskResult).getValue();
                                if (rdEntityCreated != null) {
                                    RdEntityCreated rdEntityCreated2 = rdEntityCreated;
                                    CompletableFuture<TResponse> completableFuture = this.$future;
                                    Function2<TRd, TState, TResponse> function2 = this.$constructResponse;
                                    IViewableMap<Integer, TRd> iViewableMap = this.$entitySource;
                                    RdEntityCreated it = rdEntityCreated2;
                                    boolean bl = false;
                                    V v = iViewableMap.get(it.getId());
                                    Intrinsics.checkNotNull(v);
                                    v2 = completableFuture.complete(function2.invoke(v, it));
                                } else {
                                    v2 = this.$future.complete(null);
                                }
                            } else if (rdTaskResult2 instanceof RdTaskResult.Fault) {
                                this.$future.completeExceptionally(((RdTaskResult.Fault)rdTaskResult).getError());
                            } else if (rdTaskResult2 instanceof RdTaskResult.Cancelled) {
                                this.$future.cancel(true);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    this.$future.completeExceptionally(exception);
                }
            }
        });
        return (TResponse)((InitializationData)ProtocolUtilsKt.getOrThrow(future));
    }

    public static final <TRequest, TResponse> TResponse sync(@NotNull Lifetime lifetime, TRequest request, @NotNull IScheduler scheduler, @NotNull IRdCall<? super TRequest, ? extends TResponse> syncCall) {
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        Intrinsics.checkNotNullParameter(syncCall, "syncCall");
        CompletableFuture future = new CompletableFuture();
        scheduler.invokeOrQueue(new Function0<Unit>(syncCall, lifetime, request, future){
            final /* synthetic */ IRdCall<TRequest, TResponse> $syncCall;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ TRequest $request;
            final /* synthetic */ CompletableFuture<TResponse> $future;
            {
                this.$syncCall = $syncCall;
                this.$lifetime = $lifetime;
                this.$request = $request;
                this.$future = $future;
                super(0);
            }

            public final void invoke() {
                try {
                    IRdTask rdTask = IRdCall.DefaultImpls.start$default(this.$syncCall, this.$lifetime, this.$request, null, 4, null);
                    rdTask.getResult().advise(this.$lifetime, (Function1)new Function1<RdTaskResult<? extends TResponse>, Unit>(this.$future){
                        final /* synthetic */ CompletableFuture<TResponse> $future;
                        {
                            this.$future = $future;
                            super(1);
                        }

                        public final void invoke(@NotNull RdTaskResult<? extends TResponse> rdTaskResult) {
                            Intrinsics.checkNotNullParameter(rdTaskResult, "rdTaskResult");
                            RdTaskResult<? extends TResponse> rdTaskResult2 = rdTaskResult;
                            if (rdTaskResult2 instanceof RdTaskResult.Success) {
                                this.$future.complete(((RdTaskResult.Success)rdTaskResult).getValue());
                            } else if (rdTaskResult2 instanceof RdTaskResult.Fault) {
                                this.$future.completeExceptionally(((RdTaskResult.Fault)rdTaskResult).getError());
                            } else if (rdTaskResult2 instanceof RdTaskResult.Cancelled) {
                                this.$future.cancel(true);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    this.$future.completeExceptionally(exception);
                }
            }
        });
        return (TResponse)ProtocolUtilsKt.getOrThrow(future);
    }

    @NotNull
    public static final <TRequest> ExecutionResult sync(@NotNull RdStatement $this$sync, @NotNull Lifetime lifetime, TRequest request, @NotNull IRdCall<? super TRequest, ? extends RdExecutionResult> executeCall, @NotNull JdbcModel rdModel) {
        Intrinsics.checkNotNullParameter($this$sync, "<this>");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(executeCall, "executeCall");
        Intrinsics.checkNotNullParameter(rdModel, "rdModel");
        CompletableFuture<ExecutionResult> future = new CompletableFuture<ExecutionResult>();
        JdbcModelExtKt.getScheduler($this$sync).invokeOrQueue(new Function0<Unit>(executeCall, lifetime, request, future, rdModel){
            final /* synthetic */ IRdCall<TRequest, RdExecutionResult> $executeCall;
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ TRequest $request;
            final /* synthetic */ CompletableFuture<ExecutionResult> $future;
            final /* synthetic */ JdbcModel $rdModel;
            {
                this.$executeCall = $executeCall;
                this.$lifetime = $lifetime;
                this.$request = $request;
                this.$future = $future;
                this.$rdModel = $rdModel;
                super(0);
            }

            public final void invoke() {
                try {
                    IRdTask rdTask = IRdCall.DefaultImpls.start$default(this.$executeCall, this.$lifetime, this.$request, null, 4, null);
                    rdTask.getResult().advise(this.$lifetime, (Function1)new Function1<RdTaskResult<? extends RdExecutionResult>, Unit>(this.$rdModel, this.$future){
                        final /* synthetic */ JdbcModel $rdModel;
                        final /* synthetic */ CompletableFuture<ExecutionResult> $future;
                        {
                            this.$rdModel = $rdModel;
                            this.$future = $future;
                            super(1);
                        }

                        public final void invoke(@NotNull RdTaskResult<? extends RdExecutionResult> it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            RdTaskResult<? extends RdExecutionResult> rdTaskResult = it;
                            if (rdTaskResult instanceof RdTaskResult.Success) {
                                RdExecutionResult executionResult = (RdExecutionResult)((RdTaskResult.Success)rdTaskResult).getValue();
                                if (executionResult instanceof RdResultSetExecutionResult) {
                                    RdResultSetInitialState rsInfo = ((RdResultSetExecutionResult)executionResult).getResultSetInfo();
                                    V v = this.$rdModel.getResultSets().get(rsInfo.getId());
                                    Intrinsics.checkNotNull(v);
                                    ResultSetInitializationData receivedResultSet = new ResultSetInitializationData((RdResultSet)v, rsInfo);
                                    this.$future.complete(new ExecutionResult.ResultSet(receivedResultSet));
                                } else if (executionResult instanceof RdUpdateCountExecutionResult) {
                                    this.$future.complete(new ExecutionResult.UpdateCount(((RdUpdateCountExecutionResult)executionResult).getUpdateCount()));
                                }
                            } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                                this.$future.completeExceptionally(((RdTaskResult.Fault)rdTaskResult).getError());
                            } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                                this.$future.cancel(true);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    this.$future.completeExceptionally(exception);
                }
            }
        });
        return ProtocolUtilsKt.getOrThrow(future);
    }
}

