/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils.logging;

import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdLogEntry;
import com.jetbrains.jdbc.base.models.RdLogSeverity;
import com.jetbrains.jdbc.base.utils.logging.ILoggerProvider;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/jdbc/base/utils/logging/BackendLogListener;", "", "loggerProvider", "Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;", "(Lcom/jetbrains/jdbc/base/utils/logging/ILoggerProvider;)V", "logger", "Ljava/util/logging/Logger;", "getLevel", "Ljava/util/logging/Level;", "entry", "Lcom/jetbrains/jdbc/base/models/RdLogEntry;", "listenToLogMessages", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "Frontend"})
public final class BackendLogListener {
    @NotNull
    private final Logger logger;

    public BackendLogListener(@NotNull ILoggerProvider loggerProvider) {
        Intrinsics.checkNotNullParameter(loggerProvider, "loggerProvider");
        this.logger = loggerProvider.getLogger(BackendLogListener.class);
    }

    public final void listenToLogMessages(@NotNull Lifetime lifetime, @NotNull JdbcModel model) {
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(model, "model");
        model.getLogMessage().advise(lifetime, new Function1<RdLogEntry, Unit>(this){
            final /* synthetic */ BackendLogListener this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull RdLogEntry it) {
                Intrinsics.checkNotNullParameter(it, "it");
                BackendLogListener.access$getLogger$p(this.this$0).log(BackendLogListener.access$getLevel(this.this$0, it), it.getText());
            }
        });
    }

    private final Level getLevel(RdLogEntry entry) {
        Level level;
        switch (WhenMappings.$EnumSwitchMapping$0[entry.getSeverity().ordinal()]) {
            case 1: {
                Level level2 = Level.SEVERE;
                level = level2;
                Intrinsics.checkNotNullExpressionValue(level2, "SEVERE");
                break;
            }
            case 2: {
                Level level3 = Level.WARNING;
                level = level3;
                Intrinsics.checkNotNullExpressionValue(level3, "WARNING");
                break;
            }
            case 3: {
                Level level4 = Level.INFO;
                level = level4;
                Intrinsics.checkNotNullExpressionValue(level4, "INFO");
                break;
            }
            case 4: {
                Level level5 = Level.FINE;
                level = level5;
                Intrinsics.checkNotNullExpressionValue(level5, "FINE");
                break;
            }
            case 5: {
                Level level6 = Level.FINER;
                level = level6;
                Intrinsics.checkNotNullExpressionValue(level6, "FINER");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return level;
    }

    public static final /* synthetic */ Logger access$getLogger$p(BackendLogListener $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Level access$getLevel(BackendLogListener $this, RdLogEntry entry) {
        return $this.getLevel(entry);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdLogSeverity.values().length];
            try {
                nArray[RdLogSeverity.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdLogSeverity.WARN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdLogSeverity.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdLogSeverity.TRACE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdLogSeverity.VERBOSE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

