/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"getLongestPrefixSuffixArray", "", "pattern", "", "kmpSearch", "", "position", "Frontend"})
public final class SearchUtilsKt {
    public static final int kmpSearch(@NotNull byte[] $this$kmpSearch, @NotNull byte[] pattern, int position) {
        Intrinsics.checkNotNullParameter($this$kmpSearch, "<this>");
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        int patternPointer = 0;
        int[] longestPrefixSuffix = SearchUtilsKt.getLongestPrefixSuffixArray(pattern);
        int textPointer = position;
        while (textPointer < $this$kmpSearch.length) {
            if (pattern[patternPointer] == $this$kmpSearch[textPointer]) {
                ++patternPointer;
                ++textPointer;
            } else if (patternPointer != 0) {
                patternPointer = longestPrefixSuffix[patternPointer - 1];
            } else {
                ++textPointer;
            }
            if (patternPointer != pattern.length) continue;
            return textPointer - patternPointer;
        }
        return -1;
    }

    private static final int[] getLongestPrefixSuffixArray(byte[] pattern) {
        int[] longestPrefixSuffix = new int[pattern.length];
        int leftPointer = 0;
        int rightPointer = 1;
        while (rightPointer < pattern.length) {
            if (pattern[rightPointer] == pattern[leftPointer]) {
                longestPrefixSuffix[rightPointer] = ++leftPointer;
                ++rightPointer;
                continue;
            }
            if (leftPointer != 0) {
                leftPointer = longestPrefixSuffix[leftPointer - 1];
                continue;
            }
            longestPrefixSuffix[rightPointer] = 0;
            ++rightPointer;
        }
        return longestPrefixSuffix;
    }
}

